/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.server.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.test.base.TestMethodTracer;
import org.apache.asterix.test.common.TestExecutor;
import org.apache.asterix.test.common.TestHelper;
import org.apache.asterix.testframework.context.TestCaseContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hyracks.util.file.FileUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class SampleLocalClusterIT {
    private static final String TARGET_DIR = FileUtil.joinPath((String[])new String[]{"target"});
    private static final String OUTPUT_DIR = FileUtil.joinPath((String[])new String[]{TARGET_DIR, "sample local cluster"});
    private static final String LOCAL_SAMPLES_DIR = FileUtil.joinPath((String[])new String[]{OUTPUT_DIR, "opt", "local"});
    @Rule
    public TestRule watcher = new TestMethodTracer();

    @BeforeClass
    public static void setUp() throws Exception {
        File outDir = new File(OUTPUT_DIR);
        if (outDir.isDirectory()) {
            FileUtils.deleteDirectory((File)outDir);
        }
        outDir.mkdirs();
        String[] pathElements = new String[]{TARGET_DIR, new File(TARGET_DIR).list((dir, name) -> name.matches("asterix-server.*-binary-assembly.zip"))[0]};
        String installerZip = FileUtil.joinPath((String[])pathElements);
        TestHelper.unzip((String)installerZip, (String)OUTPUT_DIR);
    }

    private static List<File> findLogFiles(File directory, List<File> fileList) {
        File[] match = directory.listFiles(pathname -> pathname.isDirectory() || pathname.toString().endsWith(".log"));
        if (match != null) {
            for (File file : match) {
                if (file.isDirectory()) {
                    SampleLocalClusterIT.findLogFiles(file, fileList);
                    continue;
                }
                fileList.add(file);
            }
        }
        return fileList;
    }

    @AfterClass
    public static void teardown() throws Exception {
        File destDir = new File(TARGET_DIR, FileUtil.joinPath((String[])new String[]{"failsafe-reports", SampleLocalClusterIT.class.getSimpleName()}));
        for (File f : SampleLocalClusterIT.findLogFiles(new File(OUTPUT_DIR), new ArrayList<File>())) {
            FileUtils.copyFileToDirectory((File)f, (File)destDir);
        }
    }

    @Test
    public void test0_startCluster() throws Exception {
        Process process = new ProcessBuilder(FileUtil.joinPath((String[])new String[]{LOCAL_SAMPLES_DIR, "bin/stop-sample-cluster.sh"}), "-f").inheritIO().start();
        Assert.assertEquals((long)0L, (long)process.waitFor());
        process = new ProcessBuilder(FileUtil.joinPath((String[])new String[]{LOCAL_SAMPLES_DIR, "bin/start-sample-cluster.sh"})).inheritIO().start();
        Assert.assertEquals((long)0L, (long)process.waitFor());
    }

    @Test
    public void test1_sanityQuery() throws Exception {
        TestExecutor testExecutor = new TestExecutor();
        InputStream resultStream = testExecutor.executeQuery("1+1", TestCaseContext.OutputFormat.ADM, new URI("http", null, "127.0.0.1", 19002, "/query", null, null), Collections.emptyList());
        StringWriter sw = new StringWriter();
        IOUtils.copy((InputStream)resultStream, (Writer)sw);
        Assert.assertEquals((Object)"2", (Object)sw.toString().trim());
    }

    @Test
    public void test2_stopCluster() throws Exception {
        Process process = new ProcessBuilder(FileUtil.joinPath((String[])new String[]{LOCAL_SAMPLES_DIR, "bin/stop-sample-cluster.sh"})).inheritIO().start();
        Assert.assertEquals((long)0L, (long)process.waitFor());
        try {
            new URL("http://127.0.0.1:19002").openConnection().connect();
            Assert.assertTrue((String)"Expected connection to be refused.", (boolean)false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

