/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.server.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.asterix.test.common.TestExecutor;
import org.apache.asterix.test.runtime.HDFSCluster;
import org.apache.asterix.testframework.context.TestCaseContext;
import org.apache.asterix.testframework.xml.TestGroup;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.server.process.HyracksCCProcess;
import org.apache.hyracks.server.process.HyracksNCServiceProcess;
import org.apache.hyracks.server.process.HyracksVirtualCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Parameterized;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@RunWith(value=Parameterized.class)
public class NCServiceExecutionIT {
    private static final String TARGET_DIR = StringUtils.join((Object[])new String[]{"target"}, (String)File.separator);
    private static final String INSTANCE_DIR = StringUtils.join((Object[])new String[]{TARGET_DIR, "tmp"}, (String)File.separator);
    private static final String LOG_DIR = StringUtils.join((Object[])new String[]{TARGET_DIR, "failsafe-reports"}, (String)File.separator);
    private static final String CONF_DIR = StringUtils.join((Object[])new String[]{TARGET_DIR, "test-classes", "NCServiceExecutionIT"}, (String)File.separator);
    private static final String APP_HOME = StringUtils.join((Object[])new String[]{TARGET_DIR, "appassembler"}, (String)File.separator);
    private static final String ASTERIX_APP_DIR = StringUtils.join((Object[])new String[]{"..", "asterix-app"}, (String)File.separator);
    protected static final String TESTS_DIR = StringUtils.join((Object[])new String[]{ASTERIX_APP_DIR, "src", "test", "resources", "runtimets"}, (String)File.separator);
    private static final String ACTUAL_RESULTS_DIR = StringUtils.join((Object[])new String[]{TARGET_DIR, "ittest"}, (String)File.separator);
    private static final Logger LOGGER = Logger.getLogger(NCServiceExecutionIT.class.getName());
    private static HyracksCCProcess cc;
    private static HyracksNCServiceProcess nc1;
    private static HyracksNCServiceProcess nc2;
    private final TestCaseContext tcCtx;
    private static final TestExecutor testExecutor;
    private static final List<String> badTestCases;
    private static HyracksVirtualCluster cluster;
    private final KillCommand killType;

    @BeforeClass
    public static void setUp() throws Exception {
        File outDir = new File(ACTUAL_RESULTS_DIR);
        outDir.mkdirs();
        File instanceDir = new File(INSTANCE_DIR);
        if (instanceDir.isDirectory()) {
            FileUtils.deleteDirectory((File)instanceDir);
        }
        HDFSCluster.getInstance().setup(ASTERIX_APP_DIR + File.separator);
        cluster = new HyracksVirtualCluster(new File(APP_HOME), new File(ASTERIX_APP_DIR));
        nc1 = cluster.addNCService(new File(CONF_DIR, "ncservice1.conf"), new File(LOG_DIR, "ncservice1.log"));
        nc2 = cluster.addNCService(new File(CONF_DIR, "ncservice2.conf"), new File(LOG_DIR, "ncservice2.log"));
        cc = cluster.start(new File(CONF_DIR, "cc.conf"), new File(LOG_DIR, "cc.log"));
        testExecutor.waitForClusterActive(30, TimeUnit.SECONDS);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        File outdir = new File(ACTUAL_RESULTS_DIR);
        File[] files = outdir.listFiles();
        if (files == null || files.length == 0) {
            outdir.delete();
        }
        cluster.stop();
        HDFSCluster.getInstance().cleanup();
        if (!badTestCases.isEmpty()) {
            System.out.println("The following test cases left some data");
            for (String testCase : badTestCases) {
                System.out.println(testCase);
            }
        }
    }

    @Parameterized.Parameters(name="NCServiceExecutionTest {index}: {0}")
    public static Collection<Object[]> tests() throws Exception {
        ArrayList<Object[]> testArgs = new ArrayList<Object[]>();
        Random random = NCServiceExecutionIT.getRandom();
        TestCaseContext.Builder b = new TestCaseContext.Builder();
        for (TestCaseContext ctx : b.build(new File(TESTS_DIR))) {
            if (!NCServiceExecutionIT.skip(ctx)) {
                testArgs.add(new Object[]{ctx, ctx, null});
            }
            if (testArgs.size() % 50 != 0) continue;
            KillCommand killCommand = KillCommand.values()[random.nextInt(KillCommand.values().length)];
            testArgs.add(new Object[]{killCommand, null, killCommand});
        }
        return testArgs;
    }

    private static Random getRandom() {
        Random random;
        if (System.getProperty("random.seed") == null) {
            random = new Random(){

                @Override
                public synchronized void setSeed(long seed) {
                    super.setSeed(seed);
                    System.err.println("using generated seed: " + seed + "; use -Drandom.seed to use specific seed");
                }
            };
        } else {
            long seed = Long.getLong("random.seed");
            System.err.println("using provided seed (-Drandom.seed): " + seed);
            random = new Random(seed);
        }
        return random;
    }

    private static boolean skip(TestCaseContext tcCtx) {
        for (TestGroup group : tcCtx.getTestGroups()) {
            if (!group.getName().startsWith("external-") && !group.getName().equals("feeds") && !group.getName().equals("api")) continue;
            LOGGER.info("Skipping test: " + tcCtx.toString());
            return true;
        }
        return false;
    }

    public NCServiceExecutionIT(Object description, TestCaseContext tcCtx, KillCommand killType) {
        this.tcCtx = tcCtx;
        this.killType = killType;
    }

    @Test
    public void test() throws Exception {
        if (this.tcCtx != null) {
            testExecutor.executeTest(ACTUAL_RESULTS_DIR, this.tcCtx, null, false);
            testExecutor.cleanup(this.tcCtx.toString(), badTestCases);
        } else {
            switch (this.killType) {
                case CC: {
                    LOGGER.info("Killing CC...");
                    cc.stop(true);
                    cc.start();
                    break;
                }
                case NC1: {
                    LOGGER.info("Killing NC1...");
                    nc1.stop();
                    testExecutor.waitForClusterState("UNUSABLE", 60, TimeUnit.SECONDS);
                    nc1.start();
                    break;
                }
                case NC2: {
                    LOGGER.info("Killing NC2...");
                    nc2.stop();
                    testExecutor.waitForClusterState("UNUSABLE", 60, TimeUnit.SECONDS);
                    nc2.start();
                    break;
                }
                default: {
                    Assert.fail((String)("killType: " + (Object)((Object)this.killType)));
                }
            }
            testExecutor.waitForClusterActive(30, TimeUnit.SECONDS);
        }
    }

    static {
        testExecutor = new TestExecutor();
        badTestCases = new ArrayList<String>();
    }

    static enum KillCommand {
        CC,
        NC1,
        NC2;


        public String toString() {
            return "<kill " + this.name().toLowerCase() + ">";
        }
    }
}

