/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.server.test;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.util.file.FileUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.JVM)
public class LicensingIT {
    private static final String TARGET_DIR = FileUtil.joinPath((String[])new String[]{"target"});
    protected String installerDir;

    @Before
    public void setup() {
        String pattern = this.getInstallerDirPattern();
        Object[] list = new File(TARGET_DIR).list((dir, name) -> name.matches(pattern));
        Assert.assertNotNull((String)"installerDir", (Object)list);
        Assert.assertFalse((String)("Ambiguous install dir (" + pattern + "): " + Arrays.toString(list)), (list.length > 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)("Can't find install dir (" + pattern + ")"), (long)1L, (long)list.length);
        this.installerDir = FileUtil.joinPath((String[])new String[]{TARGET_DIR, list[0]});
    }

    protected String getInstallerDirPattern() {
        return "asterix-server.*-binary-assembly";
    }

    protected String pathToLicensingFiles() {
        return "";
    }

    @Test
    public void testLicenseNoticeFilesPresent() throws IOException {
        for (String name : Arrays.asList("LICENSE", "NOTICE")) {
            String fileName = FileUtil.joinPath((String[])new String[]{this.installerDir, this.pathToLicensingFiles(), name});
            Assert.assertTrue((String)(fileName + " missing"), (boolean)new File(fileName).exists());
        }
    }

    @Test
    public void testNoMissingLicenses() throws IOException {
        File licenseFile = new File(FileUtil.joinPath((String[])new String[]{this.installerDir, this.pathToLicensingFiles(), "LICENSE"}));
        ArrayList<String> badLines = new ArrayList<String>();
        for (String line : FileUtils.readLines((File)licenseFile, (Charset)StandardCharsets.UTF_8)) {
            if (!line.matches("^\\s*MISSING:.*")) continue;
            badLines.add(line.trim());
        }
        Assert.assertEquals((String)("Missing licenses in " + licenseFile + ": " + badLines), (long)0L, (long)badLines.size());
    }
}

