/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.management;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.replication.IReplicationChannel;
import org.apache.asterix.replication.api.IReplicaTask;
import org.apache.asterix.replication.api.IReplicationWorker;
import org.apache.asterix.replication.logging.RemoteLogsProcessor;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicationChannel
extends Thread
implements IReplicationChannel {
    private static final Logger LOGGER = LogManager.getLogger();
    private ServerSocketChannel serverSocketChannel = null;
    private final INcApplicationContext appCtx;
    private final RemoteLogsProcessor logsProcessor;

    public ReplicationChannel(INcApplicationContext appCtx) {
        this.appCtx = appCtx;
        this.logsProcessor = new RemoteLogsProcessor(appCtx);
    }

    @Override
    public void run() {
        String nodeId = this.appCtx.getServiceContext().getNodeId();
        Thread.currentThread().setName(nodeId + " Replication Channel Thread");
        ReplicationProperties replicationProperties = this.appCtx.getReplicationProperties();
        String nodeIP = replicationProperties.getReplicationAddress();
        int dataPort = replicationProperties.getReplicationPort();
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.configureBlocking(true);
            InetSocketAddress replicationChannelAddress = new InetSocketAddress(InetAddress.getByName(nodeIP), dataPort);
            this.serverSocketChannel.socket().bind(replicationChannelAddress);
            LOGGER.log(Level.INFO, "opened Replication Channel @ IP Address: " + nodeIP + ":" + dataPort);
            while (this.serverSocketChannel.isOpen()) {
                SocketChannel socketChannel = this.serverSocketChannel.accept();
                socketChannel.configureBlocking(true);
                this.appCtx.getThreadExecutor().execute(new ReplicationWorker(socketChannel));
            }
        }
        catch (AsynchronousCloseException e) {
            LOGGER.debug("Replication channel closed", (Throwable)e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to bind replication channel @ " + nodeIP + ":" + dataPort, e);
        }
    }

    public RemoteLogsProcessor getRemoteLogsProcessor() {
        return this.logsProcessor;
    }

    public void close() throws IOException {
        if (this.serverSocketChannel != null) {
            this.serverSocketChannel.close();
            LOGGER.info("Replication channel closed.");
        }
    }

    private class ReplicationWorker
    implements IReplicationWorker {
        private final SocketChannel socketChannel;
        private final ByteBuffer inBuffer;
        private final ByteBuffer outBuffer;

        public ReplicationWorker(SocketChannel socketChannel) {
            this.socketChannel = socketChannel;
            this.inBuffer = ByteBuffer.allocate(ReplicationProtocol.INITIAL_BUFFER_SIZE);
            this.outBuffer = ByteBuffer.allocate(ReplicationProtocol.INITIAL_BUFFER_SIZE);
        }

        @Override
        public void run() {
            Thread.currentThread().setName("Replication Worker");
            try {
                ReplicationProtocol.ReplicationRequestType requestType = ReplicationProtocol.getRequestType(this.socketChannel, this.inBuffer);
                while (requestType != ReplicationProtocol.ReplicationRequestType.GOODBYE) {
                    this.handle(requestType);
                    requestType = ReplicationProtocol.getRequestType(this.socketChannel, this.inBuffer);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Unexpectedly error during replication.", (Throwable)e);
            }
            finally {
                if (this.socketChannel.isOpen()) {
                    try {
                        this.socketChannel.close();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to close replication socket.", (Throwable)e);
                    }
                }
            }
        }

        @Override
        public SocketChannel getChannel() {
            return this.socketChannel;
        }

        @Override
        public ByteBuffer getReusableBuffer() {
            return this.outBuffer;
        }

        private void handle(ReplicationProtocol.ReplicationRequestType requestType) throws HyracksDataException {
            IReplicaTask task = (IReplicaTask)ReplicationProtocol.readMessage(requestType, this.socketChannel, this.inBuffer);
            task.perform(ReplicationChannel.this.appCtx, this);
        }
    }
}

