/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.management;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.Callable;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.replication.Replica;
import org.apache.asterix.replication.functions.ReplicationProtocol;
import org.apache.asterix.replication.management.ReplicationManager;

public class ReplicaStateChecker
implements Callable<Void> {
    private final int WAIT_TIME = 2000;
    private final Replica replica;
    private final int replicationTimeOut;
    private final ReplicationManager replicationManager;
    private final ReplicationProperties asterixReplicationProperties;
    private final boolean suspendReplication;

    public ReplicaStateChecker(Replica replica, int replicationTimeOut, ReplicationManager replicationManager, ReplicationProperties asterixReplicationProperties, boolean suspendReplication) {
        this.replica = replica;
        this.replicationTimeOut = replicationTimeOut;
        this.replicationManager = replicationManager;
        this.asterixReplicationProperties = asterixReplicationProperties;
        this.suspendReplication = suspendReplication;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void call() throws Exception {
        Thread.currentThread().setName("ReplicaConnector Thread");
        long startTime = System.currentTimeMillis();
        InetSocketAddress replicaAddress = this.replica.getAddress(this.asterixReplicationProperties);
        while (true) {
            try (SocketChannel connection = SocketChannel.open();){
                connection.configureBlocking(true);
                connection.connect(new InetSocketAddress(replicaAddress.getHostString(), replicaAddress.getPort()));
                ByteBuffer buffer = ReplicationProtocol.getGoodbyeBuffer();
                connection.write(buffer);
                this.replicationManager.updateReplicaState(this.replica.getId(), Replica.ReplicaState.ACTIVE, this.suspendReplication);
                Void void_ = null;
                return void_;
            }
            catch (IOException | UnresolvedAddressException e) {
                Thread.sleep(2000L);
                if ((System.currentTimeMillis() - startTime) / 1000L < (long)this.replicationTimeOut) continue;
                this.replicationManager.updateReplicaState(this.replica.getId(), Replica.ReplicaState.DEAD, this.suspendReplication);
                return null;
            }
            break;
        }
    }
}

