/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.functions;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public class ReplicaLogsRequest {
    Set<String> replicaIds;
    long fromLSN;

    public ReplicaLogsRequest(Set<String> replicaIds, long fromLSN) {
        this.replicaIds = replicaIds;
        this.fromLSN = fromLSN;
    }

    public void serialize(OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        dos.writeInt(this.replicaIds.size());
        for (String replicaId : this.replicaIds) {
            dos.writeUTF(replicaId);
        }
        dos.writeLong(this.fromLSN);
    }

    public static ReplicaLogsRequest create(DataInput input) throws IOException {
        int size = input.readInt();
        HashSet<String> replicaIds = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            replicaIds.add(input.readUTF());
        }
        long fromLSN = input.readLong();
        return new ReplicaLogsRequest(replicaIds, fromLSN);
    }

    public Set<String> getReplicaIds() {
        return this.replicaIds;
    }

    public void setReplicaIds(Set<String> replicaIds) {
        this.replicaIds = replicaIds;
    }

    public long getFromLSN() {
        return this.fromLSN;
    }

    public void setFromLSN(long fromLSN) {
        this.fromLSN = fromLSN;
    }
}

