/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.storage;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.replication.storage.LSMComponentProperties;

public class LSMIndexFileProperties {
    private String fileName;
    private long fileSize;
    private String nodeId;
    private String dataverse;
    private String idxName;
    private boolean lsmComponentFile;
    private String filePath;
    private boolean requiresAck = false;
    private long LSNByteOffset;
    private int partition;

    public LSMIndexFileProperties() {
    }

    public LSMIndexFileProperties(String filePath, long fileSize, String nodeId, boolean lsmComponentFile, long LSNByteOffset, boolean requiresAck) {
        this.initialize(filePath, fileSize, nodeId, lsmComponentFile, LSNByteOffset, requiresAck);
    }

    public LSMIndexFileProperties(LSMComponentProperties lsmComponentProperties) {
        this.initialize(lsmComponentProperties.getComponentId(), -1L, lsmComponentProperties.getNodeId(), false, -1L, false);
    }

    public void initialize(String filePath, long fileSize, String nodeId, boolean lsmComponentFile, long LSNByteOffset, boolean requiresAck) {
        this.filePath = filePath;
        this.fileSize = fileSize;
        this.nodeId = nodeId;
        this.lsmComponentFile = lsmComponentFile;
        this.LSNByteOffset = LSNByteOffset;
        this.requiresAck = requiresAck;
    }

    public void splitFileName() {
        String[] tokens = this.filePath.split(File.separator);
        int arraySize = tokens.length;
        this.fileName = tokens[arraySize - 1];
        this.idxName = tokens[arraySize - 2];
        this.dataverse = tokens[arraySize - 3];
        this.partition = StoragePathUtil.getPartitionNumFromName((String)tokens[arraySize - 4]);
    }

    public void serialize(OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        dos.writeUTF(this.nodeId);
        dos.writeUTF(this.filePath);
        dos.writeLong(this.fileSize);
        dos.writeBoolean(this.lsmComponentFile);
        dos.writeLong(this.LSNByteOffset);
        dos.writeBoolean(this.requiresAck);
    }

    public static LSMIndexFileProperties create(DataInput input) throws IOException {
        String nodeId = input.readUTF();
        String filePath = input.readUTF();
        long fileSize = input.readLong();
        boolean lsmComponentFile = input.readBoolean();
        long LSNByteOffset = input.readLong();
        boolean requiresAck = input.readBoolean();
        LSMIndexFileProperties fileProp = new LSMIndexFileProperties(filePath, fileSize, nodeId, lsmComponentFile, LSNByteOffset, requiresAck);
        return fileProp;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getDataverse() {
        return this.dataverse;
    }

    public void setDataverse(String dataverse) {
        this.dataverse = dataverse;
    }

    public String getIdxName() {
        return this.idxName;
    }

    public boolean isLSMComponentFile() {
        return this.lsmComponentFile;
    }

    public boolean requiresAck() {
        return this.requiresAck;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("File Name: " + this.fileName + "  ");
        sb.append("File Size: " + this.fileSize + "  ");
        sb.append("Node ID: " + this.nodeId + "  ");
        sb.append("Partition: " + this.partition + "  ");
        sb.append("IDX Name: " + this.idxName + "  ");
        sb.append("isLSMComponentFile : " + this.lsmComponentFile + "  ");
        sb.append("Dataverse: " + this.dataverse);
        sb.append("LSN Byte Offset: " + this.LSNByteOffset);
        return sb.toString();
    }

    public long getLSNByteOffset() {
        return this.LSNByteOffset;
    }

    public int getPartition() {
        return this.partition;
    }
}

