/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.functions;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public class ReplicaIndexFlushRequest {
    Set<Long> laggingRescouresIds;

    public ReplicaIndexFlushRequest(Set<Long> laggingRescouresIds) {
        this.laggingRescouresIds = laggingRescouresIds;
    }

    public void serialize(OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        dos.writeInt(this.laggingRescouresIds.size());
        for (Long resourceId : this.laggingRescouresIds) {
            dos.writeLong(resourceId);
        }
    }

    public static ReplicaIndexFlushRequest create(DataInput input) throws IOException {
        int numOfResources = input.readInt();
        HashSet<Long> laggingRescouresIds = new HashSet<Long>(numOfResources);
        for (int i = 0; i < numOfResources; ++i) {
            laggingRescouresIds.add(input.readLong());
        }
        return new ReplicaIndexFlushRequest(laggingRescouresIds);
    }

    public Set<Long> getLaggingRescouresIds() {
        return this.laggingRescouresIds;
    }

    public void setLaggingRescouresIds(Set<Long> laggingRescouresIds) {
        this.laggingRescouresIds = laggingRescouresIds;
    }
}

