/* Generated By:JavaCC: Do not edit this line. SQLPPParser.java */
package org.apache.asterix.lang.sqlpp.parser;

// For SQL++ ParserTokenManager
import java.util.ArrayDeque;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.asterix.common.annotations.AutoDataGen;
import org.apache.asterix.common.annotations.DateBetweenYearsDataGen;
import org.apache.asterix.common.annotations.DatetimeAddRandHoursDataGen;
import org.apache.asterix.common.annotations.DatetimeBetweenYearsDataGen;
import org.apache.asterix.common.annotations.FieldIntervalDataGen;
import org.apache.asterix.common.annotations.FieldValFileDataGen;
import org.apache.asterix.common.annotations.FieldValFileSameIndexDataGen;
import org.apache.asterix.common.annotations.IRecordFieldDataGen;
import org.apache.asterix.common.annotations.InsertRandIntDataGen;
import org.apache.asterix.common.annotations.ListDataGen;
import org.apache.asterix.common.annotations.ListValFileDataGen;
import org.apache.asterix.common.annotations.SkipSecondaryIndexSearchExpressionAnnotation;
import org.apache.asterix.common.annotations.TypeDataGen;
import org.apache.asterix.common.annotations.UndeclaredFieldsDataGen;
import org.apache.asterix.common.config.DatasetConfig.DatasetType;
import org.apache.asterix.common.config.DatasetConfig.IndexType;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.UpdateClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.context.RootScopeFactory;
import org.apache.asterix.lang.common.context.Scope;
import org.apache.asterix.lang.common.expression.AbstractAccessor;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.OrderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.RecordTypeDefinition;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.expression.TypeReferenceExpression;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.UnorderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.DoubleLiteral;
import org.apache.asterix.lang.common.literal.FalseLiteral;
import org.apache.asterix.lang.common.literal.FloatLiteral;
import org.apache.asterix.lang.common.literal.LongIntegerLiteral;
import org.apache.asterix.lang.common.literal.MissingLiteral;
import org.apache.asterix.lang.common.literal.NullLiteral;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.literal.TrueLiteral;
import org.apache.asterix.lang.common.parser.ScopeChecker;
import org.apache.asterix.lang.common.statement.CompactStatement;
import org.apache.asterix.lang.common.statement.ConnectFeedStatement;
import org.apache.asterix.lang.common.statement.CreateDataverseStatement;
import org.apache.asterix.lang.common.statement.CreateFeedPolicyStatement;
import org.apache.asterix.lang.common.statement.CreateFeedStatement;
import org.apache.asterix.lang.common.statement.CreateFunctionStatement;
import org.apache.asterix.lang.common.statement.CreateIndexStatement;
import org.apache.asterix.lang.common.statement.CreatePrimaryFeedStatement;
import org.apache.asterix.lang.common.statement.CreateSecondaryFeedStatement;
import org.apache.asterix.lang.common.statement.DatasetDecl;
import org.apache.asterix.lang.common.statement.DataverseDecl;
import org.apache.asterix.lang.common.statement.DataverseDropStatement;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.DisconnectFeedStatement;
import org.apache.asterix.lang.common.statement.DropDatasetStatement;
import org.apache.asterix.lang.common.statement.ExternalDetailsDecl;
import org.apache.asterix.lang.common.statement.FeedDropStatement;
import org.apache.asterix.lang.common.statement.FeedPolicyDropStatement;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.FunctionDropStatement;
import org.apache.asterix.lang.common.statement.IndexDropStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.InternalDetailsDecl;
import org.apache.asterix.lang.common.statement.LoadStatement;
import org.apache.asterix.lang.common.statement.NodeGroupDropStatement;
import org.apache.asterix.lang.common.statement.NodegroupDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.statement.RefreshExternalDatasetStatement;
import org.apache.asterix.lang.common.statement.RunStatement;
import org.apache.asterix.lang.common.statement.SetStatement;
import org.apache.asterix.lang.common.statement.TypeDecl;
import org.apache.asterix.lang.common.statement.TypeDropStatement;
import org.apache.asterix.lang.common.statement.UpdateStatement;
import org.apache.asterix.lang.common.statement.UpsertStatement;
import org.apache.asterix.lang.common.statement.WriteStatement;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.optype.JoinType;
import org.apache.asterix.lang.sqlpp.optype.SetOpType;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.ExpressionToVariableUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.metadata.utils.MetadataConstants;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.IndexedNLJoinExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;

class SQLPPParser extends ScopeChecker implements IParser, SQLPPParserConstants {

    // optimizer hints
    private static final String AUTO_HINT = "auto";
    private static final String BROADCAST_JOIN_HINT = "bcast";
    private static final String COMPOSE_VAL_FILES_HINT = "compose-val-files";
    private static final String DATE_BETWEEN_YEARS_HINT = "date-between-years";
    private static final String DATETIME_ADD_RAND_HOURS_HINT = "datetime-add-rand-hours";
    private static final String DATETIME_BETWEEN_YEARS_HINT = "datetime-between-years";
    private static final String HASH_GROUP_BY_HINT = "hash";
    private static final String INDEXED_NESTED_LOOP_JOIN_HINT = "indexnl";
    private static final String INMEMORY_HINT = "inmem";
    private static final String INSERT_RAND_INT_HINT = "insert-rand-int";
    private static final String INTERVAL_HINT = "interval";
    private static final String LIST_HINT = "list";
    private static final String LIST_VAL_FILE_HINT = "list-val-file";
    private static final String RANGE_HINT = "range";
    private static final String SKIP_SECONDARY_INDEX_SEARCH_HINT = "skip-index";
    private static final String VAL_FILE_HINT = "val-files";
    private static final String VAL_FILE_SAME_INDEX_HINT = "val-file-same-idx";

    private static final String GEN_FIELDS_HINT = "gen-fields";

    // data generator hints
    private static final String DGEN_HINT = "dgen";

    // error configuration
    protected static final boolean REPORT_EXPECTED_TOKENS = false;

    private static class IndexParams {
      public IndexType type;
      public int gramLength;

      public IndexParams(IndexType type, int gramLength) {
        this.type = type;
        this.gramLength = gramLength;
      }
    };

    private static class FunctionName {
       public String dataverse = null;
       public String library = null;
       public String function = null;
       public String hint = null;
    }

    private static String getHint(Token t) {
        if (t.specialToken == null) {
            return null;
        }
        String s = t.specialToken.image;
        int n = s.length();
        if (n < 2) {
            return null;
        }
        return s.substring(1).trim();
    }

    private static IRecordFieldDataGen parseFieldDataGen(String hint) throws ParseException {
      IRecordFieldDataGen rfdg = null;
      String splits[] = hint.split(" +");
      if (splits[0].equals(VAL_FILE_HINT)) {
        File[] valFiles = new File[splits.length - 1];
        for (int k=1; k<splits.length; k++) {
          valFiles[k-1] = new File(splits[k]);
        }
        rfdg = new FieldValFileDataGen(valFiles);
      } else if (splits[0].equals(VAL_FILE_SAME_INDEX_HINT)) {
        rfdg = new FieldValFileSameIndexDataGen(new File(splits[1]), splits[2]);
      } else if (splits[0].equals(LIST_VAL_FILE_HINT)) {
        rfdg = new ListValFileDataGen(new File(splits[1]), Integer.parseInt(splits[2]), Integer.parseInt(splits[3]));
      } else if (splits[0].equals(LIST_HINT)) {
        rfdg = new ListDataGen(Integer.parseInt(splits[1]), Integer.parseInt(splits[2]));
      } else if (splits[0].equals(INTERVAL_HINT)) {
        FieldIntervalDataGen.ValueType vt;
        if (splits[1].equals("int")) {
          vt = FieldIntervalDataGen.ValueType.INT;
        } else if (splits[1].equals("long")) {
          vt = FieldIntervalDataGen.ValueType.LONG;
        } else if (splits[1].equals("float")) {
          vt = FieldIntervalDataGen.ValueType.FLOAT;
        } else if (splits[1].equals("double")) {
          vt = FieldIntervalDataGen.ValueType.DOUBLE;
        } else {
          throw new ParseException("Unknown type for interval data gen: " + splits[1]);
        }
        rfdg = new FieldIntervalDataGen(vt, splits[2], splits[3]);
      } else if (splits[0].equals(INSERT_RAND_INT_HINT)) {
        rfdg = new InsertRandIntDataGen(splits[1], splits[2]);
      } else if (splits[0].equals(DATE_BETWEEN_YEARS_HINT)) {
        rfdg = new DateBetweenYearsDataGen(Integer.parseInt(splits[1]), Integer.parseInt(splits[2]));
      } else if (splits[0].equals(DATETIME_BETWEEN_YEARS_HINT)) {
        rfdg = new DatetimeBetweenYearsDataGen(Integer.parseInt(splits[1]), Integer.parseInt(splits[2]));
      } else if (splits[0].equals(DATETIME_ADD_RAND_HOURS_HINT)) {
        rfdg = new DatetimeAddRandHoursDataGen(Integer.parseInt(splits[1]), Integer.parseInt(splits[2]), splits[3]);
      } else if (splits[0].equals(AUTO_HINT)) {
        rfdg = new AutoDataGen(splits[1]);
      }
      return rfdg;
    }

    public SQLPPParser(String s) {
        this(new StringReader(s));
        super.setInput(s);
    }

    public static void main(String args[]) throws ParseException, TokenMgrError, IOException, FileNotFoundException, CompilationException {
        File file = new File(args[0]);
        Reader fis = new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF-8"));
        SQLPPParser parser = new SQLPPParser(fis);
        List<Statement> st = parser.parse();
        //st.accept(new SQLPPPrintVisitor(), 0);
    }

    public List<Statement> parse() throws CompilationException {
        try {
            return Statement();
        } catch (Error e) {
            // this is here as the JavaCharStream that's below the lexer somtimes throws Errors that are not handled
            // by the ANTLR-generated lexer or parser (e.g it does this for invalid backslash u + 4 hex digits escapes)
            throw new CompilationException(new ParseException(e.getMessage()));
        } catch (ParseException e) {
            throw new CompilationException("Syntax error: " + getMessage(e));
        }
    }

    protected String getMessage(ParseException pe) {
        Token currentToken = pe.currentToken;
        if (currentToken == null) {
            return pe.getMessage();
        }
        int[][] expectedTokenSequences = pe.expectedTokenSequences;
        String[] tokenImage = pe.tokenImage;
        String sep = REPORT_EXPECTED_TOKENS ? eol : " ";
        StringBuilder expected = REPORT_EXPECTED_TOKENS ? new StringBuilder() : null;
        int maxSize = appendExpected(expected, expectedTokenSequences, tokenImage);
        Token tok = currentToken.next;
        int line = tok.beginLine;
        String message = "In line " + line + " >>" + getLine(line) + "<<" + sep + "Encountered ";
        for (int i = 0; i < maxSize; i++) {
            if (i != 0) {
                message += " ";
            }
            if (tok.kind == 0) {
                message += fixQuotes(tokenImage[0]);
                break;
            }
            final String fixedTokenImage = tokenImage[tok.kind];
            if (! tok.image.equalsIgnoreCase(stripQuotes(fixedTokenImage))) {
                message += fixQuotes(fixedTokenImage) + " ";
            }
            message += quot + addEscapes(tok.image) + quot;
            tok = tok.next;
        }
        message += " at column " + currentToken.next.beginColumn + "." + sep;
        if (REPORT_EXPECTED_TOKENS) {
            if (expectedTokenSequences.length == 1) {
                message += "Was expecting:" + sep + "    ";
            } else {
                message += "Was expecting one of:" + sep + "    ";
            }
            message += expected.toString();
        }
        return message;
    }

  final public List<Statement> Statement() throws ParseException, ParseException {
  scopeStack.push(RootScopeFactory.createRootScope(this));
  List<Statement> decls = new ArrayList<Statement>();
  Statement stmt = null;
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANY:
      case CASE:
      case CREATE:
      case COMPACT:
      case CONNECT:
      case DECLARE:
      case DELETE:
      case DISCONNECT:
      case DROP:
      case EXPLAIN:
      case EVERY:
      case EXISTS:
      case FROM:
      case INSERT:
      case LETTING:
      case LET:
      case LOAD:
      case NOT:
      case REFRESH:
      case RUN:
      case SELECT:
      case SET:
      case SOME:
      case UPDATE:
      case UPSERT:
      case USE:
      case WITH:
      case WRITE:
      case MINUS:
      case PLUS:
      case LEFTPAREN:
      case LEFTBRACKET:
      case LEFTBRACE:
      case LEFTDBLBRACE:
      case INTEGER_LITERAL:
      case MISSING:
      case NULL:
      case TRUE:
      case FALSE:
      case DOUBLE_LITERAL:
      case FLOAT_LITERAL:
      case QUOTED_STRING:
      case STRING_LITERAL:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      stmt = SingleStatement();
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[1] = jj_gen;
          break label_2;
        }
        jj_consume_token(SEMICOLON);
      }
      decls.add(stmt);
    }
    jj_consume_token(0);
    {if (true) return decls;}
    throw new Error("Missing return statement in function");
  }

  final public Statement SingleStatement() throws ParseException, ParseException {
  Statement stmt = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USE:
      stmt = DataverseDeclaration();
      break;
    case DECLARE:
      stmt = FunctionDeclaration();
      break;
    case CREATE:
      stmt = CreateStatement();
      break;
    case LOAD:
      stmt = LoadStatement();
      break;
    case DROP:
      stmt = DropStatement();
      break;
    case WRITE:
      stmt = WriteStatement();
      break;
    case SET:
      stmt = SetStatement();
      break;
    case INSERT:
      stmt = InsertStatement();
      break;
    case DELETE:
      stmt = DeleteStatement();
      break;
    case UPDATE:
      stmt = UpdateStatement();
      break;
    case UPSERT:
      stmt = UpsertStatement();
      break;
    case CONNECT:
    case DISCONNECT:
      stmt = ConnectionStatement();
      break;
    case COMPACT:
      stmt = CompactStatement();
      break;
    case EXPLAIN:
      stmt = ExplainStatement();
      break;
    case ANY:
    case CASE:
    case EVERY:
    case EXISTS:
    case FROM:
    case LETTING:
    case LET:
    case NOT:
    case SELECT:
    case SOME:
    case WITH:
    case MINUS:
    case PLUS:
    case LEFTPAREN:
    case LEFTBRACKET:
    case LEFTBRACE:
    case LEFTDBLBRACE:
    case INTEGER_LITERAL:
    case MISSING:
    case NULL:
    case TRUE:
    case FALSE:
    case DOUBLE_LITERAL:
    case FLOAT_LITERAL:
    case QUOTED_STRING:
    case STRING_LITERAL:
    case IDENTIFIER:
      stmt = Query(false);
      jj_consume_token(SEMICOLON);
      break;
    case REFRESH:
      stmt = RefreshExternalDatasetStatement();
      break;
    case RUN:
      stmt = RunStatement();
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final public DataverseDecl DataverseDeclaration() throws ParseException, ParseException {
  String dvName = null;
    jj_consume_token(USE);
    dvName = Identifier();
      defaultDataverse = dvName;
      {if (true) return new DataverseDecl(new Identifier(dvName));}
    throw new Error("Missing return statement in function");
  }

  final public Statement CreateStatement() throws ParseException, ParseException {
  String hint = null;
  boolean dgen = false;
  Statement stmt = null;
    jj_consume_token(CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TYPE:
      hint = getHint(token);
      if (hint != null && hint.startsWith(DGEN_HINT)) {
        dgen = true;
      }
      stmt = TypeSpecification(hint, dgen);
      break;
    case NODEGROUP:
      stmt = NodegroupSpecification();
      break;
    case DATASET:
    case COLLECTION:
    case EXTERNAL:
    case INTERNAL:
    case TEMPORARY:
      stmt = DatasetSpecification();
      break;
    case INDEX:
      stmt = IndexSpecification();
      break;
    case DATAVERSE:
      stmt = DataverseSpecification();
      break;
    case FUNCTION:
      stmt = FunctionSpecification();
      break;
    case FEED:
    case PRIMARY:
    case SECONDARY:
      stmt = FeedSpecification();
      break;
    case INGESTION:
      stmt = FeedPolicySpecification();
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final public TypeDecl TypeSpecification(String hint, boolean dgen) throws ParseException, ParseException {
  Pair<Identifier,Identifier> nameComponents = null;
  boolean ifNotExists = false;
  TypeExpression typeExpr = null;
    jj_consume_token(TYPE);
    nameComponents = TypeName();
    ifNotExists = IfNotExists();
    jj_consume_token(AS);
    typeExpr = RecordTypeDef();
      long numValues = -1;
      String filename = null;
      if (dgen) {
        String splits[] = hint.split(" +");
        if (splits.length != 3) {
          {if (true) throw new ParseException("Expecting /*+ dgen <filename> <numberOfItems> */");}
        }
        filename = splits[1];
        numValues = Long.parseLong(splits[2]);
      }
      TypeDataGen tddg = new TypeDataGen(dgen, filename, numValues);
      {if (true) return new TypeDecl(nameComponents.first, nameComponents.second, typeExpr, tddg, ifNotExists);}
    throw new Error("Missing return statement in function");
  }

  final public NodegroupDecl NodegroupSpecification() throws ParseException, ParseException {
  String name = null;
  String tmp = null;
  boolean ifNotExists = false;
  List<Identifier>ncNames = null;
    jj_consume_token(NODEGROUP);
    name = Identifier();
    ifNotExists = IfNotExists();
    jj_consume_token(ON);
    tmp = Identifier();
      ncNames = new ArrayList<Identifier>();
      ncNames.add(new Identifier(tmp));
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
      tmp = Identifier();
      ncNames.add(new Identifier(tmp));
    }
      {if (true) return new NodegroupDecl(new Identifier(name), ncNames, ifNotExists);}
    throw new Error("Missing return statement in function");
  }

  final public DatasetDecl DatasetSpecification() throws ParseException, ParseException {
  Pair<Identifier,Identifier> nameComponents = null;
  boolean ifNotExists = false;
  Pair<Identifier,Identifier> typeComponents = null;
  String adapterName = null;
  Map<String,String> properties = null;
  Map<String,String> compactionPolicyProperties = null;
  FunctionSignature appliedFunction = null;
  Pair<List<Integer>, List<List<String>>> primaryKeyFields = null;
  String nodeGroupName = null;
  Map<String,String> hints = new HashMap<String,String>();
  DatasetDecl dsetDecl = null;
  boolean autogenerated = false;
  String compactionPolicy = null;
  boolean temp = false;
  Pair<Integer, List<String>> filterField = null;
  Pair<Identifier,Identifier> metaTypeComponents = new Pair<Identifier, Identifier>(null, null);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTERNAL:
      jj_consume_token(EXTERNAL);
      Dataset();
      nameComponents = QualifiedName();
      jj_consume_token(LEFTPAREN);
      typeComponents = TypeName();
      jj_consume_token(RIGHTPAREN);
      ifNotExists = IfNotExists();
      jj_consume_token(USING);
      adapterName = AdapterName();
      properties = Configuration();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ON:
        jj_consume_token(ON);
        nodeGroupName = Identifier();
        break;
      default:
        jj_la1[5] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HINTS:
        jj_consume_token(HINTS);
        hints = Properties();
        break;
      default:
        jj_la1[6] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case USING:
        jj_consume_token(USING);
        jj_consume_token(COMPACTION);
        jj_consume_token(POLICY);
        compactionPolicy = CompactionPolicy();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LEFTPAREN:
          compactionPolicyProperties = Configuration();
          break;
        default:
          jj_la1[7] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[8] = jj_gen;
        ;
      }
        ExternalDetailsDecl edd = new ExternalDetailsDecl();
        edd.setAdapter(adapterName);
        edd.setProperties(properties);
        dsetDecl = new DatasetDecl(nameComponents.first,
                                   nameComponents.second,
                                   typeComponents.first,
                                   typeComponents.second,
                                   metaTypeComponents.first,
                                   metaTypeComponents.second,
                                   nodeGroupName != null? new Identifier(nodeGroupName): null,
                                   compactionPolicy,
                                   compactionPolicyProperties,
                                   hints,
                                   DatasetType.EXTERNAL,
                                   edd,
                                   ifNotExists);
      break;
    case DATASET:
    case COLLECTION:
    case INTERNAL:
    case TEMPORARY:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTERNAL:
      case TEMPORARY:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTERNAL:
          jj_consume_token(INTERNAL);
          break;
        case TEMPORARY:
          jj_consume_token(TEMPORARY);
                                  temp = true;
          break;
        default:
          jj_la1[9] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[10] = jj_gen;
        ;
      }
      Dataset();
      nameComponents = QualifiedName();
      jj_consume_token(LEFTPAREN);
      typeComponents = TypeName();
      jj_consume_token(RIGHTPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
          String name;
        jj_consume_token(WITH);
        name = Identifier();
            if(!name.toLowerCase().equals("meta")){
                {if (true) throw new ParseException("We can only support one additional associated field called \u005c"meta\u005c".");}
            }
        jj_consume_token(LEFTPAREN);
        metaTypeComponents = TypeName();
        jj_consume_token(RIGHTPAREN);
        break;
      default:
        jj_la1[11] = jj_gen;
        ;
      }
      ifNotExists = IfNotExists();
      primaryKeyFields = PrimaryKey();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AUTOGENERATED:
        jj_consume_token(AUTOGENERATED);
                       autogenerated = true;
        break;
      default:
        jj_la1[12] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ON:
        jj_consume_token(ON);
        nodeGroupName = Identifier();
        break;
      default:
        jj_la1[13] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HINTS:
        jj_consume_token(HINTS);
        hints = Properties();
        break;
      default:
        jj_la1[14] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case USING:
        jj_consume_token(USING);
        jj_consume_token(COMPACTION);
        jj_consume_token(POLICY);
        compactionPolicy = CompactionPolicy();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LEFTPAREN:
          compactionPolicyProperties = Configuration();
          break;
        default:
          jj_la1[15] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[16] = jj_gen;
        ;
      }
      if (jj_2_1(2)) {
        jj_consume_token(WITH);
        jj_consume_token(FILTER);
        jj_consume_token(ON);
        filterField = NestedField();
      } else {
        ;
      }
        if(filterField!=null && filterField.first!=0){
          {if (true) throw new ParseException("A filter field can only be a field in the main record of the dataset.");}
        }
        InternalDetailsDecl idd = new InternalDetailsDecl(primaryKeyFields.second,
                                                          primaryKeyFields.first,
                                                          autogenerated,
                                                          filterField == null? null : filterField.second,
                                                          temp);
        dsetDecl = new DatasetDecl(nameComponents.first,
                                   nameComponents.second,
                                   typeComponents.first,
                                   typeComponents.second,
                                   metaTypeComponents.first,
                                   metaTypeComponents.second,
                                   nodeGroupName != null ? new Identifier(nodeGroupName) : null,
                                   compactionPolicy,
                                   compactionPolicyProperties,
                                   hints,
                                   DatasetType.INTERNAL,
                                   idd,
                                   ifNotExists);
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return dsetDecl;}
    throw new Error("Missing return statement in function");
  }

  final public RefreshExternalDatasetStatement RefreshExternalDatasetStatement() throws ParseException, ParseException {
  RefreshExternalDatasetStatement redss = new RefreshExternalDatasetStatement();
  Pair<Identifier,Identifier> nameComponents = null;
  String datasetName = null;
    jj_consume_token(REFRESH);
    jj_consume_token(EXTERNAL);
    Dataset();
    nameComponents = QualifiedName();
    redss.setDataverseName(nameComponents.first);
    redss.setDatasetName(nameComponents.second);
    {if (true) return redss;}
    throw new Error("Missing return statement in function");
  }

  final public RunStatement RunStatement() throws ParseException, ParseException {
  String system = null;
  String tmp;
  ArrayList<String> parameters = new  ArrayList<String>();
  Pair<Identifier,Identifier> nameComponentsFrom = null;
  Pair<Identifier,Identifier> nameComponentsTo = null;
    jj_consume_token(RUN);
    system = Identifier();
    jj_consume_token(LEFTPAREN);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case QUOTED_STRING:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[18] = jj_gen;
        break label_4;
      }
      tmp = Identifier();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[19] = jj_gen;
        ;
      }
      parameters.add(tmp);
    }
    jj_consume_token(RIGHTPAREN);
    jj_consume_token(FROM);
    Dataset();
    nameComponentsFrom = QualifiedName();
    jj_consume_token(TO);
    Dataset();
    nameComponentsTo = QualifiedName();
      {if (true) return new RunStatement(system, parameters, nameComponentsFrom.first, nameComponentsFrom.second, nameComponentsTo.first, nameComponentsTo.second);}
    throw new Error("Missing return statement in function");
  }

  final public CreateIndexStatement IndexSpecification() throws ParseException, ParseException {
  CreateIndexStatement cis = new CreateIndexStatement();
  String indexName = null;
  boolean ifNotExists = false;
  Pair<Identifier,Identifier> nameComponents = null;
  Pair<Integer, Pair<List<String>, TypeExpression>> fieldPair = null;
  IndexParams indexType = null;
  boolean enforced = false;
    jj_consume_token(INDEX);
    indexName = Identifier();
    ifNotExists = IfNotExists();
    jj_consume_token(ON);
    nameComponents = QualifiedName();
    jj_consume_token(LEFTPAREN);
    fieldPair = OpenField();
      cis.addFieldExprPair(fieldPair.second);
      cis.addFieldIndexIndicator(fieldPair.first);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[20] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
      fieldPair = OpenField();
      cis.addFieldExprPair(fieldPair.second);
      cis.addFieldIndexIndicator(fieldPair.first);
    }
    jj_consume_token(RIGHTPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TYPE:
      jj_consume_token(TYPE);
      indexType = IndexType();
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENFORCED:
      jj_consume_token(ENFORCED);
                                                                     enforced = true;
      break;
    default:
      jj_la1[22] = jj_gen;
      ;
    }
      cis.setIndexName(new Identifier(indexName));
      cis.setIfNotExists(ifNotExists);
      cis.setDataverseName(nameComponents.first);
      cis.setDatasetName(nameComponents.second);
      if (indexType != null) {
        cis.setIndexType(indexType.type);
        cis.setGramLength(indexType.gramLength);
      }
      cis.setEnforced(enforced);
      {if (true) return cis;}
    throw new Error("Missing return statement in function");
  }

  final public String CompactionPolicy() throws ParseException, ParseException {
  String compactionPolicy = null;
    compactionPolicy = Identifier();
      {if (true) return compactionPolicy;}
    throw new Error("Missing return statement in function");
  }

  final public String FilterField() throws ParseException, ParseException {
  String filterField = null;
    filterField = Identifier();
      {if (true) return filterField;}
    throw new Error("Missing return statement in function");
  }

  final public IndexParams IndexType() throws ParseException, ParseException {
  IndexType type = null;
  int gramLength = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BTREE:
      jj_consume_token(BTREE);
      type = IndexType.BTREE;
      break;
    case RTREE:
      jj_consume_token(RTREE);
      type = IndexType.RTREE;
      break;
    case KEYWORD:
      jj_consume_token(KEYWORD);
      type = IndexType.LENGTH_PARTITIONED_WORD_INVIX;
      break;
    case FULLTEXT:
      jj_consume_token(FULLTEXT);
      type = IndexType.SINGLE_PARTITION_WORD_INVIX;
      break;
    case NGRAM:
      jj_consume_token(NGRAM);
      jj_consume_token(LEFTPAREN);
      jj_consume_token(INTEGER_LITERAL);
      type = IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
      gramLength = Integer.valueOf(token.image);
      jj_consume_token(RIGHTPAREN);
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return new IndexParams(type, gramLength);}
    throw new Error("Missing return statement in function");
  }

  final public CreateDataverseStatement DataverseSpecification() throws ParseException, ParseException {
  String dvName = null;
  boolean ifNotExists = false;
    jj_consume_token(DATAVERSE);
    dvName = Identifier();
    ifNotExists = IfNotExists();
      {if (true) return new CreateDataverseStatement(new Identifier(dvName), null, ifNotExists);}
    throw new Error("Missing return statement in function");
  }

  final public CreateFunctionStatement FunctionSpecification() throws ParseException, ParseException {
  FunctionSignature signature;
  boolean ifNotExists = false;
  List<VarIdentifier> paramList = new ArrayList<VarIdentifier>();
  String functionBody;
  VarIdentifier var = null;
  Expression functionBodyExpr;
  Token beginPos;
  Token endPos;
  FunctionName fctName = null;

  createNewScope();
    jj_consume_token(FUNCTION);
    fctName = FunctionName();
    ifNotExists = IfNotExists();
    paramList = ParameterList();
    jj_consume_token(LEFTBRACE);
     beginPos = token;
    functionBodyExpr = Expression();
    jj_consume_token(RIGHTBRACE);
      endPos = token;
      functionBody = extractFragment(beginPos.beginLine, beginPos.beginColumn, endPos.beginLine, endPos.beginColumn);
      // TODO use fctName.library
      signature = new FunctionSignature(fctName.dataverse, fctName.function, paramList.size());
      getCurrentScope().addFunctionDescriptor(signature, false);
      removeCurrentScope();
      {if (true) return new CreateFunctionStatement(signature, paramList, functionBody, ifNotExists);}
    throw new Error("Missing return statement in function");
  }

  final public CreateFeedStatement FeedSpecification() throws ParseException, ParseException {
  Pair<Identifier,Identifier> nameComponents = null;
  boolean ifNotExists = false;
  String adapterName = null;
  Map<String,String> properties = null;
  FunctionSignature appliedFunction = null;
  CreateFeedStatement cfs = null;
  Pair<Identifier,Identifier> sourceNameComponents = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SECONDARY:
      jj_consume_token(SECONDARY);
      jj_consume_token(FEED);
      nameComponents = QualifiedName();
      ifNotExists = IfNotExists();
      jj_consume_token(FROM);
      jj_consume_token(FEED);
      sourceNameComponents = QualifiedName();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case APPLY:
        appliedFunction = ApplyFunction();
        break;
      default:
        jj_la1[24] = jj_gen;
        ;
      }
        cfs = new CreateSecondaryFeedStatement(nameComponents,
                                   sourceNameComponents, appliedFunction, ifNotExists);
      break;
    case FEED:
    case PRIMARY:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRIMARY:
        jj_consume_token(PRIMARY);
        break;
      default:
        jj_la1[25] = jj_gen;
        ;
      }
      jj_consume_token(FEED);
      nameComponents = QualifiedName();
      ifNotExists = IfNotExists();
      jj_consume_token(USING);
      adapterName = AdapterName();
      properties = Configuration();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case APPLY:
        appliedFunction = ApplyFunction();
        break;
      default:
        jj_la1[26] = jj_gen;
        ;
      }
        cfs = new CreatePrimaryFeedStatement(nameComponents,
                                    adapterName, properties, appliedFunction, ifNotExists);
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return cfs;}
    throw new Error("Missing return statement in function");
  }

  final public CreateFeedPolicyStatement FeedPolicySpecification() throws ParseException, ParseException {
  String policyName = null;
  String basePolicyName = null;
  String sourcePolicyFile = null;
  String definition = null;
  boolean ifNotExists = false;
  Map<String,String> properties = null;
  CreateFeedPolicyStatement cfps = null;
    jj_consume_token(INGESTION);
    jj_consume_token(POLICY);
    policyName = Identifier();
    ifNotExists = IfNotExists();
    jj_consume_token(FROM);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case POLICY:
      jj_consume_token(POLICY);
      basePolicyName = Identifier();
      properties = Configuration();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEFINITION:
        jj_consume_token(DEFINITION);
        definition = ConstantString();
        break;
      default:
        jj_la1[28] = jj_gen;
        ;
      }
        cfps = new CreateFeedPolicyStatement(policyName,
                                   basePolicyName, properties, definition, ifNotExists);
      break;
    case PATH:
      jj_consume_token(PATH);
      sourcePolicyFile = ConstantString();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEFINITION:
        jj_consume_token(DEFINITION);
        definition = ConstantString();
        break;
      default:
        jj_la1[29] = jj_gen;
        ;
      }
        cfps = new CreateFeedPolicyStatement(policyName, sourcePolicyFile, definition, ifNotExists);
      break;
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return cfps;}
    throw new Error("Missing return statement in function");
  }

  final public List<VarIdentifier> ParameterList() throws ParseException, ParseException {
  List<VarIdentifier> paramList = new ArrayList<VarIdentifier>();
  VarIdentifier var = null;
    jj_consume_token(LEFTPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      var = SqlppVariableUtil.toInternalVariableIdentifier(token.image);
      paramList.add(var);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[31] = jj_gen;
          break label_6;
        }
        jj_consume_token(COMMA);
        jj_consume_token(IDENTIFIER);
      var = SqlppVariableUtil.toInternalVariableIdentifier(token.image);
      paramList.add(var);
      }
      break;
    default:
      jj_la1[32] = jj_gen;
      ;
    }
    jj_consume_token(RIGHTPAREN);
      {if (true) return paramList;}
    throw new Error("Missing return statement in function");
  }

  final public boolean IfNotExists() throws ParseException, ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
      {if (true) return true;}
      break;
    default:
      jj_la1[33] = jj_gen;
      ;
    }
      {if (true) return false;}
    throw new Error("Missing return statement in function");
  }

  final public FunctionSignature ApplyFunction() throws ParseException, ParseException {
  FunctionName functioName = null;
  FunctionSignature funcSig = null;
    jj_consume_token(APPLY);
    jj_consume_token(FUNCTION);
    functioName = FunctionName();
       String fqFunctionName = functioName.library == null ? functioName.function : functioName.library + "#" + functioName.function;
       {if (true) return new FunctionSignature(functioName.dataverse, fqFunctionName, 1);}
    throw new Error("Missing return statement in function");
  }

  final public String GetPolicy() throws ParseException, ParseException {
  String policy = null;
    jj_consume_token(USING);
    jj_consume_token(POLICY);
    policy = Identifier();
     {if (true) return policy;}
    throw new Error("Missing return statement in function");
  }

  final public FunctionSignature FunctionSignature() throws ParseException, ParseException {
  FunctionName fctName = null;
  int arity = 0;
    fctName = FunctionName();
    jj_consume_token(ATT);
    jj_consume_token(INTEGER_LITERAL);
      arity = new Integer(token.image);
      if (arity < 0 && arity != FunctionIdentifier.VARARGS) {
        {if (true) throw new ParseException(" invalid arity:" + arity);}
      }

      // TODO use fctName.library
      String fqFunctionName = fctName.library == null ? fctName.function : fctName.library + "#" + fctName.function;
      {if (true) return new FunctionSignature(fctName.dataverse, fqFunctionName, arity);}
    throw new Error("Missing return statement in function");
  }

  final public Pair<List<Integer>, List<List<String>>> PrimaryKey() throws ParseException, ParseException {
  Pair<Integer, List<String>> tmp = null;
  List<Integer> keyFieldSourceIndicators = new ArrayList<Integer>();
  List<List<String>> primaryKeyFields = new ArrayList<List<String>>();
    jj_consume_token(PRIMARY);
    jj_consume_token(KEY);
    tmp = NestedField();
      keyFieldSourceIndicators.add(tmp.first);
      primaryKeyFields.add(tmp.second);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[34] = jj_gen;
        break label_7;
      }
      jj_consume_token(COMMA);
      tmp = NestedField();
      keyFieldSourceIndicators.add(tmp.first);
      primaryKeyFields.add(tmp.second);
    }
      {if (true) return new Pair<List<Integer>, List<List<String>>> (keyFieldSourceIndicators, primaryKeyFields);}
    throw new Error("Missing return statement in function");
  }

  final public Statement DropStatement() throws ParseException, ParseException {
  String id = null;
  Pair<Identifier,Identifier> pairId = null;
  Triple<Identifier,Identifier,Identifier> tripleId = null;
  FunctionSignature funcSig = null;
  boolean ifExists = false;
  Statement stmt = null;
    jj_consume_token(DROP);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATASET:
    case COLLECTION:
      Dataset();
      pairId = QualifiedName();
      ifExists = IfExists();
        stmt = new DropDatasetStatement(pairId.first, pairId.second, ifExists);
      break;
    case INDEX:
      jj_consume_token(INDEX);
      tripleId = DoubleQualifiedName();
      ifExists = IfExists();
        stmt = new IndexDropStatement(tripleId.first, tripleId.second, tripleId.third, ifExists);
      break;
    case NODEGROUP:
      jj_consume_token(NODEGROUP);
      id = Identifier();
      ifExists = IfExists();
        stmt = new NodeGroupDropStatement(new Identifier(id), ifExists);
      break;
    case TYPE:
      jj_consume_token(TYPE);
      pairId = TypeName();
      ifExists = IfExists();
        stmt = new TypeDropStatement(pairId.first, pairId.second, ifExists);
      break;
    case DATAVERSE:
      jj_consume_token(DATAVERSE);
      id = Identifier();
      ifExists = IfExists();
        stmt = new DataverseDropStatement(new Identifier(id), ifExists);
      break;
    case FUNCTION:
      jj_consume_token(FUNCTION);
      funcSig = FunctionSignature();
      ifExists = IfExists();
        stmt = new FunctionDropStatement(funcSig, ifExists);
      break;
    case FEED:
      jj_consume_token(FEED);
      pairId = QualifiedName();
      ifExists = IfExists();
        stmt = new FeedDropStatement(pairId.first, pairId.second, ifExists);
      break;
    case INGESTION:
      jj_consume_token(INGESTION);
      jj_consume_token(POLICY);
      pairId = QualifiedName();
      ifExists = IfExists();
        stmt = new FeedPolicyDropStatement(pairId.first, pairId.second, ifExists);
      break;
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final public boolean IfExists() throws ParseException, ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
      {if (true) return true;}
      break;
    default:
      jj_la1[36] = jj_gen;
      ;
    }
      {if (true) return false;}
    throw new Error("Missing return statement in function");
  }

  final public InsertStatement InsertStatement() throws ParseException, ParseException {
  Pair<Identifier,Identifier> nameComponents = null;
  VariableExpr var = null;
  Query query = null;
  Expression returnExpression = null;
    jj_consume_token(INSERT);
    jj_consume_token(INTO);
    nameComponents = QualifiedName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      var = Variable();
      break;
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    query = Query(false);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RETURNING:
      jj_consume_token(RETURNING);
      returnExpression = Expression();
      break;
    default:
      jj_la1[38] = jj_gen;
      ;
    }
      if (returnExpression != null && var == null) {
         var = ExpressionToVariableUtil.getGeneratedVariable(query.getBody(), true);
      }
      query.setTopLevel(true);
      {if (true) return new InsertStatement(nameComponents.first, nameComponents.second, query, getVarCounter(), var,
                                 returnExpression);}
    throw new Error("Missing return statement in function");
  }

  final public UpsertStatement UpsertStatement() throws ParseException, ParseException {
  Pair<Identifier,Identifier> nameComponents = null;
  VariableExpr var = null;
  Query query = null;
  Expression returnExpression = null;
    jj_consume_token(UPSERT);
    jj_consume_token(INTO);
    nameComponents = QualifiedName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      var = Variable();
      break;
    default:
      jj_la1[39] = jj_gen;
      ;
    }
    query = Query(false);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RETURNING:
      jj_consume_token(RETURNING);
      returnExpression = Expression();
      break;
    default:
      jj_la1[40] = jj_gen;
      ;
    }
      if (returnExpression != null && var == null) {
         var = ExpressionToVariableUtil.getGeneratedVariable(query.getBody(), true);
      }
      query.setTopLevel(true);
      {if (true) return new UpsertStatement(nameComponents.first, nameComponents.second, query, getVarCounter(), var,
                                 returnExpression);}
    throw new Error("Missing return statement in function");
  }

  final public DeleteStatement DeleteStatement() throws ParseException, ParseException {
  VariableExpr varExpr = null;
  Expression condition = null;
  Pair<Identifier, Identifier> nameComponents;
  // This is related to the new metadata lock management
  setDataverses(new ArrayList<String>());
  setDatasets(new ArrayList<String>());
    jj_consume_token(DELETE);
    jj_consume_token(FROM);
    nameComponents = QualifiedName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
    case QUOTED_STRING:
    case IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[41] = jj_gen;
        ;
      }
      varExpr = Variable();
      break;
    default:
      jj_la1[42] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      jj_consume_token(WHERE);
      condition = Expression();
      break;
    default:
      jj_la1[43] = jj_gen;
      ;
    }
      // First we get the dataverses and datasets that we want to lock
      List<String> dataverses = getDataverses();
      List<String> datasets = getDatasets();
      // we remove the pointer to the dataverses and datasets
      setDataverses(null);
      setDatasets(null);

      if(varExpr == null){
        varExpr = new VariableExpr();
        VarIdentifier var = SqlppVariableUtil.toInternalVariableIdentifier(nameComponents.second.getValue());
        varExpr.setVar(var);
      }
      {if (true) return new DeleteStatement(varExpr, nameComponents.first, nameComponents.second,
          condition, getVarCounter(), dataverses, datasets);}
    throw new Error("Missing return statement in function");
  }

  final public UpdateStatement UpdateStatement() throws ParseException, ParseException {
  VariableExpr vars;
  Expression target;
  Expression condition;
  UpdateClause uc;
  List<UpdateClause> ucs = new ArrayList<UpdateClause>();
    jj_consume_token(UPDATE);
    vars = Variable();
    jj_consume_token(IN);
    target = Expression();
    jj_consume_token(WHERE);
    condition = Expression();
    jj_consume_token(LEFTPAREN);
    uc = UpdateClause();
      ucs.add(uc);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[44] = jj_gen;
        break label_8;
      }
      jj_consume_token(COMMA);
      uc = UpdateClause();
      ucs.add(uc);
    }
    jj_consume_token(RIGHTPAREN);
      {if (true) return new UpdateStatement(vars, target, condition, ucs);}
    throw new Error("Missing return statement in function");
  }

  final public UpdateClause UpdateClause() throws ParseException, ParseException {
  Expression target = null;
  Expression value = null ;
  InsertStatement is = null;
  DeleteStatement ds = null;
  UpdateStatement us = null;
  Expression condition = null;
  UpdateClause ifbranch = null;
  UpdateClause elsebranch = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SET:
      jj_consume_token(SET);
      target = Expression();
      jj_consume_token(EQ);
      value = Expression();
      break;
    case INSERT:
      is = InsertStatement();
      break;
    case DELETE:
      ds = DeleteStatement();
      break;
    case UPDATE:
      us = UpdateStatement();
      break;
    case IF:
      jj_consume_token(IF);
      jj_consume_token(LEFTPAREN);
      condition = Expression();
      jj_consume_token(RIGHTPAREN);
      jj_consume_token(THEN);
      ifbranch = UpdateClause();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE:
        jj_consume_token(ELSE);
        elsebranch = UpdateClause();
        break;
      default:
        jj_la1[45] = jj_gen;
        ;
      }
       {if (true) return new UpdateClause(target, value, is, ds, us, condition, ifbranch, elsebranch);}
      break;
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Statement SetStatement() throws ParseException, ParseException {
  String pn = null;
  String pv = null;
    jj_consume_token(SET);
    pn = Identifier();
    pv = ConstantString();
      {if (true) return new SetStatement(pn, pv);}
    throw new Error("Missing return statement in function");
  }

  final public Statement WriteStatement() throws ParseException, ParseException {
  String nodeName = null;
  String fileName = null;
  Query query;
  String writerClass = null;
  Pair<Identifier,Identifier> nameComponents = null;
    jj_consume_token(WRITE);
    jj_consume_token(OUTPUT);
    jj_consume_token(TO);
    nodeName = Identifier();
    jj_consume_token(COLON);
    fileName = ConstantString();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USING:
      jj_consume_token(USING);
      writerClass = ConstantString();
      break;
    default:
      jj_la1[47] = jj_gen;
      ;
    }
      {if (true) return new WriteStatement(new Identifier(nodeName), fileName, writerClass);}
    throw new Error("Missing return statement in function");
  }

  final public LoadStatement LoadStatement() throws ParseException, ParseException {
  Identifier dataverseName = null;
  Identifier datasetName = null;
  boolean alreadySorted = false;
  String adapterName;
  Map<String,String> properties;
  Pair<Identifier,Identifier> nameComponents = null;
    jj_consume_token(LOAD);
    Dataset();
    nameComponents = QualifiedName();
      dataverseName = nameComponents.first;
      datasetName = nameComponents.second;
    jj_consume_token(USING);
    adapterName = AdapterName();
    properties = Configuration();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRESORTED:
      jj_consume_token(PRESORTED);
      alreadySorted = true;
      break;
    default:
      jj_la1[48] = jj_gen;
      ;
    }
      {if (true) return new LoadStatement(dataverseName, datasetName, adapterName, properties, alreadySorted);}
    throw new Error("Missing return statement in function");
  }

  final public String AdapterName() throws ParseException, ParseException {
  String adapterName = null;
    adapterName = Identifier();
      {if (true) return adapterName;}
    throw new Error("Missing return statement in function");
  }

  final public Statement CompactStatement() throws ParseException, ParseException {
  Pair<Identifier,Identifier> nameComponents = null;
  Statement stmt = null;
    jj_consume_token(COMPACT);
    Dataset();
    nameComponents = QualifiedName();
      stmt = new CompactStatement(nameComponents.first, nameComponents.second);
      {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final public Statement ConnectionStatement() throws ParseException, ParseException {
  Pair<Identifier,Identifier> feedNameComponents = null;
  Pair<Identifier,Identifier> datasetNameComponents = null;

  Map<String,String> configuration = null;
  Statement stmt = null;
  String policy = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONNECT:
      jj_consume_token(CONNECT);
      stmt = ConnectStatement();
      break;
    case DISCONNECT:
      jj_consume_token(DISCONNECT);
      stmt = DisconnectStatement();
      break;
    default:
      jj_la1[49] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final public Statement DisconnectStatement() throws ParseException, ParseException {
  Pair<Identifier,Identifier> feedNameComponents = null;
  Pair<Identifier,Identifier> datasetNameComponents = null;

  Map<String,String> configuration = null;
  Statement stmt = null;
  String policy = null;
    jj_consume_token(FEED);
    feedNameComponents = QualifiedName();
    jj_consume_token(FROM);
    Dataset();
    datasetNameComponents = QualifiedName();
        stmt = new DisconnectFeedStatement(feedNameComponents, datasetNameComponents);
    {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final public Statement ConnectStatement() throws ParseException, ParseException {
  Pair<Identifier,Identifier> feedNameComponents = null;
  Pair<Identifier,Identifier> datasetNameComponents = null;

  Map<String,String> configuration = null;
  Statement stmt = null;
  String policy = null;
    jj_consume_token(FEED);
    feedNameComponents = QualifiedName();
    jj_consume_token(TO);
    Dataset();
    datasetNameComponents = QualifiedName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USING:
      policy = GetPolicy();
      break;
    default:
      jj_la1[50] = jj_gen;
      ;
    }
        stmt = new ConnectFeedStatement(feedNameComponents, datasetNameComponents, policy, getVarCounter());
    {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final public Map<String,String> Configuration() throws ParseException, ParseException {
    Map<String,String> configuration = new LinkedHashMap<String,String>();
    Pair<String, String> keyValuePair = null;
    jj_consume_token(LEFTPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEFTPAREN:
      keyValuePair = KeyValuePair();
      configuration.put(keyValuePair.first, keyValuePair.second);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[51] = jj_gen;
          break label_9;
        }
        jj_consume_token(COMMA);
        keyValuePair = KeyValuePair();
      configuration.put(keyValuePair.first, keyValuePair.second);
      }
      break;
    default:
      jj_la1[52] = jj_gen;
      ;
    }
    jj_consume_token(RIGHTPAREN);
      {if (true) return configuration;}
    throw new Error("Missing return statement in function");
  }

  final public Pair<String, String> KeyValuePair() throws ParseException, ParseException {
  String key;
  String value;
    jj_consume_token(LEFTPAREN);
    key = ConstantString();
    jj_consume_token(EQ);
    value = ConstantString();
    jj_consume_token(RIGHTPAREN);
      {if (true) return new Pair<String, String>(key, value);}
    throw new Error("Missing return statement in function");
  }

  final public Map<String,String> Properties() throws ParseException, ParseException {
  Map<String,String> properties = new HashMap<String,String>();
  Pair<String, String> property;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEFTPAREN:
      jj_consume_token(LEFTPAREN);
      property = Property();
      properties.put(property.first, property.second);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[53] = jj_gen;
          break label_10;
        }
        jj_consume_token(COMMA);
        property = Property();
      properties.put(property.first, property.second);
      }
      jj_consume_token(RIGHTPAREN);
      break;
    default:
      jj_la1[54] = jj_gen;
      ;
    }
      {if (true) return properties;}
    throw new Error("Missing return statement in function");
  }

  final public Pair<String, String> Property() throws ParseException, ParseException {
  String key = null;
  String value = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
    case IDENTIFIER:
      key = Identifier();
      break;
    case STRING_LITERAL:
      key = StringLiteral();
      break;
    default:
      jj_la1[55] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(EQ);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
    case STRING_LITERAL:
      value = ConstantString();
      break;
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      try {
        value = "" + Long.valueOf(token.image);
      } catch (NumberFormatException nfe) {
        {if (true) throw new ParseException("inapproriate value: " + token.image);}
      }
      break;
    default:
      jj_la1[56] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return new Pair<String, String>(key.toUpperCase(), value);}
    throw new Error("Missing return statement in function");
  }

  final public TypeExpression IndexedTypeExpr() throws ParseException, ParseException {
  TypeExpression typeExpr = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
    case IDENTIFIER:
      typeExpr = TypeReference();
      break;
    case LEFTBRACKET:
      typeExpr = OrderedListTypeDef();
      break;
    case LEFTDBLBRACE:
      typeExpr = UnorderedListTypeDef();
      break;
    default:
      jj_la1[57] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return typeExpr;}
    throw new Error("Missing return statement in function");
  }

  final public TypeExpression TypeExpr() throws ParseException, ParseException {
  TypeExpression typeExpr = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLOSED:
    case OPEN:
    case LEFTBRACE:
      typeExpr = RecordTypeDef();
      break;
    case QUOTED_STRING:
    case IDENTIFIER:
      typeExpr = TypeReference();
      break;
    case LEFTBRACKET:
      typeExpr = OrderedListTypeDef();
      break;
    case LEFTDBLBRACE:
      typeExpr = UnorderedListTypeDef();
      break;
    default:
      jj_la1[58] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return typeExpr;}
    throw new Error("Missing return statement in function");
  }

  final public RecordTypeDefinition RecordTypeDef() throws ParseException, ParseException {
  RecordTypeDefinition recType = new RecordTypeDefinition();
  RecordTypeDefinition.RecordKind recordKind = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLOSED:
    case OPEN:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CLOSED:
        jj_consume_token(CLOSED);
               recordKind = RecordTypeDefinition.RecordKind.CLOSED;
        break;
      case OPEN:
        jj_consume_token(OPEN);
               recordKind = RecordTypeDefinition.RecordKind.OPEN;
        break;
      default:
        jj_la1[59] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[60] = jj_gen;
      ;
    }
    jj_consume_token(LEFTBRACE);
      String hint = getHint(token);
      if (hint != null) {
        String splits[] = hint.split(" +");
        if (splits[0].equals(GEN_FIELDS_HINT)) {
          if (splits.length != 5) {
            {if (true) throw new ParseException("Expecting: /*+ gen-fields <type> <min> <max> <prefix>*/");}
          }
          if (!splits[1].equals("int")) {
            {if (true) throw new ParseException("The only supported type for gen-fields is int.");}
          }
          UndeclaredFieldsDataGen ufdg = new UndeclaredFieldsDataGen(UndeclaredFieldsDataGen.Type.INT,
             Integer.parseInt(splits[2]), Integer.parseInt(splits[3]), splits[4]);
          recType.setUndeclaredFieldsDataGen(ufdg);
        }
      }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
    case IDENTIFIER:
      RecordField(recType);
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[61] = jj_gen;
          break label_11;
        }
        jj_consume_token(COMMA);
        RecordField(recType);
      }
      break;
    default:
      jj_la1[62] = jj_gen;
      ;
    }
    jj_consume_token(RIGHTBRACE);
      if (recordKind == null) {
        recordKind = RecordTypeDefinition.RecordKind.OPEN;
      }
      recType.setRecordKind(recordKind);
      {if (true) return recType;}
    throw new Error("Missing return statement in function");
  }

  final public void RecordField(RecordTypeDefinition recType) throws ParseException, ParseException {
  String fieldName;
  TypeExpression type = null;
  boolean nullable = false;
    fieldName = Identifier();
      String hint = getHint(token);
      IRecordFieldDataGen rfdg = hint != null ? parseFieldDataGen(hint) : null;
    jj_consume_token(COLON);
    type = TypeExpr();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUES:
      jj_consume_token(QUES);
                                       nullable = true;
      break;
    default:
      jj_la1[63] = jj_gen;
      ;
    }
      recType.addField(fieldName, type, nullable, rfdg);
  }

  final public TypeReferenceExpression TypeReference() throws ParseException, ParseException {
  Pair<Identifier,Identifier> id = null;
    id = QualifiedName();
     if (id.first == null && id.second.getValue().equalsIgnoreCase("int")) {
        id.second.setValue("int64");
     }

     {if (true) return new TypeReferenceExpression(id);}
    throw new Error("Missing return statement in function");
  }

  final public OrderedListTypeDefinition OrderedListTypeDef() throws ParseException, ParseException {
  TypeExpression type = null;
    jj_consume_token(LEFTBRACKET);
    type = TypeExpr();
    jj_consume_token(RIGHTBRACKET);
    {if (true) return new OrderedListTypeDefinition(type);}
    throw new Error("Missing return statement in function");
  }

  final public UnorderedListTypeDefinition UnorderedListTypeDef() throws ParseException, ParseException {
  TypeExpression type = null;
    jj_consume_token(LEFTDBLBRACE);
    type = TypeExpr();
    jj_consume_token(RIGHTDBLBRACE);
    {if (true) return new UnorderedListTypeDefinition(type);}
    throw new Error("Missing return statement in function");
  }

  final public FunctionName FunctionName() throws ParseException, ParseException {
  String first = null;
  String second = null;
  String third = null;
  boolean secondAfterDot = false;
    first = Identifier();
    FunctionName result = new FunctionName();
    result.hint = getHint(token);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOT:
    case SHARP:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        jj_consume_token(DOT);
        second = Identifier();
      secondAfterDot = true;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SHARP:
          jj_consume_token(SHARP);
          third = Identifier();
          break;
        default:
          jj_la1[64] = jj_gen;
          ;
        }
        break;
      case SHARP:
        jj_consume_token(SHARP);
        second = Identifier();
        break;
      default:
        jj_la1[65] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[66] = jj_gen;
      ;
    }
      if (second == null) {
        result.dataverse = defaultDataverse;
        result.library = null;
        result.function = first;
      } else if (third == null) {
        if (secondAfterDot) {
          result.dataverse = first;
          result.library   = null;
          result.function = second;
        } else {
          result.dataverse = defaultDataverse;
          result.library   = first;
          result.function = second;
        }
      } else {
        result.dataverse = first;
        result.library   = second;
        result.function  = third;
      }

      if (result.function.equalsIgnoreCase("int")) {
            result.function = "int64";
      }
      {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public Pair<Identifier,Identifier> TypeName() throws ParseException, ParseException {
  Pair<Identifier,Identifier> name = null;
    name = QualifiedName();
      if (name.first == null) {
        name.first = new Identifier(defaultDataverse);
      }
      {if (true) return name;}
    throw new Error("Missing return statement in function");
  }

  final public String Identifier() throws ParseException, ParseException {
  String lit = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      {if (true) return token.image;}
      break;
    case QUOTED_STRING:
      lit = QuotedString();
      {if (true) return lit;}
      break;
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void Dataset() throws ParseException, ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATASET:
      jj_consume_token(DATASET);
      break;
    case COLLECTION:
      jj_consume_token(COLLECTION);
      break;
    default:
      jj_la1[68] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Pair<Integer, Pair<List<String>, TypeExpression>> OpenField() throws ParseException, ParseException {
  TypeExpression fieldType = null;
  Pair<Integer, List<String>> fieldList = null;
    fieldList = NestedField();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      jj_consume_token(COLON);
      fieldType = IndexedTypeExpr();
      jj_consume_token(QUES);
      break;
    default:
      jj_la1[69] = jj_gen;
      ;
    }
    {if (true) return new Pair<Integer, Pair<List<String>, TypeExpression>>
          (fieldList.first, new Pair<List<String>, TypeExpression>(fieldList.second, fieldType));}
    throw new Error("Missing return statement in function");
  }

  final public Pair<Integer, List<String>> NestedField() throws ParseException, ParseException {
  List<String> exprList = new ArrayList<String>();
  String lit = null;
  int source = 0;
    lit = Identifier();
    boolean meetParens = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEFTPAREN:
      jj_consume_token(LEFTPAREN);
      jj_consume_token(RIGHTPAREN);
        if(!lit.toLowerCase().equals("meta")){
            {if (true) throw new ParseException("The string before () has to be \u005c"meta\u005c".");}
        }
        meetParens = true;
        source = 1;
      break;
    default:
      jj_la1[70] = jj_gen;
      ;
    }
    if(!meetParens){
        exprList.add(lit);
    }
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        ;
        break;
      default:
        jj_la1[71] = jj_gen;
        break label_12;
      }
      jj_consume_token(DOT);
      lit = Identifier();
      exprList.add(lit);
    }
    {if (true) return new Pair<Integer, List<String>>(source, exprList);}
    throw new Error("Missing return statement in function");
  }

  final public String ConstantString() throws ParseException, ParseException {
  String value = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
      value = QuotedString();
      break;
    case STRING_LITERAL:
      value = StringLiteral();
      break;
    default:
      jj_la1[72] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

  final public String QuotedString() throws ParseException, ParseException {
    jj_consume_token(QUOTED_STRING);
      {if (true) return removeQuotesAndEscapes(token.image);}
    throw new Error("Missing return statement in function");
  }

  final public String StringLiteral() throws ParseException, ParseException {
    jj_consume_token(STRING_LITERAL);
      {if (true) return removeQuotesAndEscapes(token.image);}
    throw new Error("Missing return statement in function");
  }

  final public Pair<Identifier,Identifier> QualifiedName() throws ParseException, ParseException {
  String first = null;
  String second = null;
    first = Identifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOT:
      jj_consume_token(DOT);
      second = Identifier();
      break;
    default:
      jj_la1[73] = jj_gen;
      ;
    }
    Identifier id1 = null;
    Identifier id2 = null;
    if (second == null) {
      id2 = new Identifier(first);
    } else
    {
      id1 = new Identifier(first);
      id2 = new Identifier(second);
    }
    {if (true) return new Pair<Identifier,Identifier>(id1, id2);}
    throw new Error("Missing return statement in function");
  }

  final public Triple<Identifier,Identifier,Identifier> DoubleQualifiedName() throws ParseException, ParseException {
  String first = null;
  String second = null;
  String third = null;
    first = Identifier();
    jj_consume_token(DOT);
    second = Identifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOT:
      jj_consume_token(DOT);
      third = Identifier();
      break;
    default:
      jj_la1[74] = jj_gen;
      ;
    }
    Identifier id1 = null;
    Identifier id2 = null;
    Identifier id3 = null;
    if (third == null) {
      id2 = new Identifier(first);
      id3 = new Identifier(second);
    } else {
      id1 = new Identifier(first);
      id2 = new Identifier(second);
      id3 = new Identifier(third);
    }
    {if (true) return new Triple<Identifier,Identifier,Identifier>(id1, id2, id3);}
    throw new Error("Missing return statement in function");
  }

  final public FunctionDecl FunctionDeclaration() throws ParseException, ParseException {
  FunctionDecl funcDecl;
  FunctionSignature signature;
  String functionName;
  List<VarIdentifier> paramList = new ArrayList<VarIdentifier>();
  Expression funcBody;
  createNewScope();
    jj_consume_token(DECLARE);
    jj_consume_token(FUNCTION);
    functionName = Identifier();
    paramList = ParameterList();
    jj_consume_token(LEFTBRACE);
    funcBody = Expression();
    jj_consume_token(RIGHTBRACE);
      signature = new FunctionSignature(defaultDataverse, functionName, paramList.size());
      getCurrentScope().addFunctionDescriptor(signature, false);
      funcDecl = new FunctionDecl(signature, paramList, funcBody);
      removeCurrentScope();
      {if (true) return funcDecl;}
    throw new Error("Missing return statement in function");
  }

  final public Query ExplainStatement() throws ParseException, ParseException {
  Query query;
    jj_consume_token(EXPLAIN);
    query = Query(true);
    {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

  final public Query Query(boolean explain) throws ParseException, ParseException {
  Query query = new Query(explain);
  // we set the pointers to the dataverses and datasets lists to fill them with entities to be locked
  setDataverses(query.getDataverses());
  setDatasets(query.getDatasets());
  Expression expr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ANY:
    case CASE:
    case EVERY:
    case EXISTS:
    case NOT:
    case SOME:
    case MINUS:
    case PLUS:
    case LEFTPAREN:
    case LEFTBRACKET:
    case LEFTBRACE:
    case LEFTDBLBRACE:
    case INTEGER_LITERAL:
    case MISSING:
    case NULL:
    case TRUE:
    case FALSE:
    case DOUBLE_LITERAL:
    case FLOAT_LITERAL:
    case QUOTED_STRING:
    case STRING_LITERAL:
    case IDENTIFIER:
      expr = Expression();
      break;
    case FROM:
    case LETTING:
    case LET:
    case SELECT:
    case WITH:
      expr = SelectExpression(false);
      break;
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    query.setBody(expr);
    // we remove the pointers to the locked entities before we return the query object
    setDataverses(null);
    setDatasets(null);
    {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

  final public Expression Expression() throws ParseException {
  Expression expr = null;
  Expression exprP = null;
    if (jj_2_2(2)) {
      expr = OperatorExpr();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CASE:
        expr = CaseExpr();
        break;
      case ANY:
      case EVERY:
      case SOME:
        expr = QuantifiedExpression();
        break;
      default:
        jj_la1[76] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
      {if (true) return (exprP==null) ? expr : exprP;}
    throw new Error("Missing return statement in function");
  }

  final public Expression OperatorExpr() throws ParseException, ParseException {
  OperatorExpr op = null;
  Expression operand = null;
    operand = AndExpr();
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[77] = jj_gen;
        break label_13;
      }
      jj_consume_token(OR);
        if (op == null) {
          op = new OperatorExpr();
          op.addOperand(operand);
        op.setCurrentop(true);
        }
        try{
            op.addOperator(token.image.toLowerCase());
        } catch (Exception e){
            {if (true) throw new ParseException(e.getMessage());}
        }
      operand = AndExpr();
      op.addOperand(operand);
    }
      {if (true) return op==null? operand: op;}
    throw new Error("Missing return statement in function");
  }

  final public Expression AndExpr() throws ParseException, ParseException {
  OperatorExpr op = null;
  Expression operand = null;
    operand = NotExpr();
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[78] = jj_gen;
        break label_14;
      }
      jj_consume_token(AND);
        if (op == null) {
          op = new OperatorExpr();
          op.addOperand(operand);
          op.setCurrentop(true);
        }
        try{
           op.addOperator(token.image.toLowerCase());
        } catch (CompilationException e){
           {if (true) throw new ParseException(e.getMessage());}
        }
      operand = NotExpr();
      op.addOperand(operand);
    }
      {if (true) return op==null? operand: op;}
    throw new Error("Missing return statement in function");
  }

  final public Expression NotExpr() throws ParseException, ParseException {
   Expression inputExpr;
   boolean not = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
           not = true;
      break;
    default:
      jj_la1[79] = jj_gen;
      ;
    }
    inputExpr = RelExpr();
    if(not){
        FunctionSignature signature = new FunctionSignature(null, "not", 1);
        {if (true) return new CallExpr(signature, new ArrayList<Expression>(Collections.singletonList(inputExpr)));}
    } else {
        {if (true) return inputExpr;}
    }
    throw new Error("Missing return statement in function");
  }

  final public Expression RelExpr() throws ParseException, ParseException {
  boolean not = false;
  OperatorExpr op = null;
  Expression operand = null;
  boolean broadcast = false;
  IExpressionAnnotation annotation = null;
    operand = BetweenExpr();
    if (jj_2_3(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LT:
        jj_consume_token(LT);
        break;
      case GT:
        jj_consume_token(GT);
        break;
      case LE:
        jj_consume_token(LE);
        break;
      case GE:
        jj_consume_token(GE);
        break;
      case EQ:
        jj_consume_token(EQ);
        break;
      case NE:
        jj_consume_token(NE);
        break;
      case LG:
        jj_consume_token(LG);
        break;
      case SIMILAR:
        jj_consume_token(SIMILAR);
        break;
      case IN:
      case LIKE:
      case NOT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NOT:
          jj_consume_token(NOT);
                                                                                         not = true;
          break;
        default:
          jj_la1[80] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LIKE:
          jj_consume_token(LIKE);
          break;
        case IN:
          jj_consume_token(IN);
          break;
        default:
          jj_la1[81] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[82] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          String mhint = getHint(token);
          if (mhint != null) {
            if (mhint.equals(INDEXED_NESTED_LOOP_JOIN_HINT)) {
                annotation = IndexedNLJoinExpressionAnnotation.INSTANCE;
            } else if (mhint.equals(SKIP_SECONDARY_INDEX_SEARCH_HINT)) {
                annotation = SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE;
            } else if (mhint.equals(BROADCAST_JOIN_HINT)) {
                broadcast = true;
            }
          }

          String operator = token.image.toLowerCase();
          if (operator.equals("<>")){
              operator = "!=";
          }
          if (not) {
            operator = "not_" + operator;
          }
          if (op == null) {
            op = new OperatorExpr();
            op.addOperand(operand, false); // broadcast is always for the right branch
            op.setCurrentop(true);
          }
          try{
            op.addOperator(operator);
          } catch (CompilationException e){
            {if (true) throw new ParseException(e.getMessage());}
          }
      operand = BetweenExpr();
         op.addOperand(operand, broadcast);
    } else {
      ;
    }
       if (annotation != null) {
         op.addHint(annotation);
       }
       {if (true) return op==null? operand: op;}
    throw new Error("Missing return statement in function");
  }

  final public Expression BetweenExpr() throws ParseException, ParseException {
  boolean not = false;
  OperatorExpr op = null;
  Expression operand = null;
  IExpressionAnnotation annotation = null;
    operand = IsExpr();
    if (jj_2_4(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
               not = true;
        break;
      default:
        jj_la1[83] = jj_gen;
        ;
      }
      jj_consume_token(BETWEEN);
          String mhint = getHint(token);
          if (mhint != null) {
            if (mhint.equals(INDEXED_NESTED_LOOP_JOIN_HINT)) {
                annotation = IndexedNLJoinExpressionAnnotation.INSTANCE;
            } else if (mhint.equals(SKIP_SECONDARY_INDEX_SEARCH_HINT)) {
                annotation = SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE;
            }
          }
          String operator = token.image.toLowerCase();
          if(not){
            operator = "not_" + operator;
          }
          if (op == null) {
            op = new OperatorExpr();
            op.addOperand(operand);
            op.setCurrentop(true);
          }
          try{
            op.addOperator(operator);
          } catch (CompilationException e){
            {if (true) throw new ParseException(e.getMessage());}
          }
      operand = IsExpr();
         op.addOperand(operand);
      jj_consume_token(AND);
      operand = IsExpr();
         op.addOperand(operand);
    } else {
      ;
    }
       if (annotation != null) {
         op.addHint(annotation);
       }
       {if (true) return op==null? operand: op;}
    throw new Error("Missing return statement in function");
  }

  final public Expression IsExpr() throws ParseException, ParseException {
    Expression expr = null;
    Expression operand = null;
    boolean not = false;
    operand = ConcatExpr();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IS:
      jj_consume_token(IS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                    not = true;
        break;
      default:
        jj_la1[84] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NULL:
        jj_consume_token(NULL);
        break;
      case MISSING:
        jj_consume_token(MISSING);
        break;
      case UNKOWN:
        jj_consume_token(UNKOWN);
        break;
      default:
        jj_la1[85] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        String functionName = "is-" + token.image.toLowerCase();
        FunctionSignature signature = new FunctionSignature(null, functionName, 1);
        expr = new CallExpr(signature, new ArrayList<Expression>(Collections.singletonList(operand)));
        if(not) {
           FunctionSignature notSignature = new FunctionSignature(null, "not", 1);
           expr = new CallExpr(notSignature, new ArrayList<Expression>(Collections.singletonList(expr)));
        }
      break;
    default:
      jj_la1[86] = jj_gen;
      ;
    }
        {if (true) return expr = expr==null? operand : expr;}
    throw new Error("Missing return statement in function");
  }

  final public Expression ConcatExpr() throws ParseException, ParseException {
  OperatorExpr op = null;
  Expression operand = null;
    operand = AddExpr();
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONCAT:
        ;
        break;
      default:
        jj_la1[87] = jj_gen;
        break label_15;
      }
      jj_consume_token(CONCAT);
        if (op == null) {
          op = new OperatorExpr();
          op.addOperand(operand);
          op.setCurrentop(true);
        }
        try{
            ((OperatorExpr)op).addOperator(token.image);
        } catch (Exception e){
            {if (true) throw new ParseException(e.getMessage());}
        }
      operand = AddExpr();
      op.addOperand(operand);
    }
       {if (true) return op==null? operand: op;}
    throw new Error("Missing return statement in function");
  }

  final public Expression AddExpr() throws ParseException, ParseException {
  OperatorExpr op = null;
  Expression operand = null;
    operand = MultExpr();
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
      case PLUS:
        ;
        break;
      default:
        jj_la1[88] = jj_gen;
        break label_16;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        break;
      default:
        jj_la1[89] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        if (op == null) {
          op = new OperatorExpr();
        op.addOperand(operand);
        op.setCurrentop(true);
        }
        try{
            ((OperatorExpr)op).addOperator(token.image);
        } catch (Exception e){
            {if (true) throw new ParseException(e.getMessage());}
        }
      operand = MultExpr();
      op.addOperand(operand);
    }
       {if (true) return op==null? operand: op;}
    throw new Error("Missing return statement in function");
  }

  final public Expression MultExpr() throws ParseException, ParseException {
  OperatorExpr op = null;
  Expression operand = null;
    operand = ExponentExpr();
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIV:
      case IDIV:
      case MOD:
      case MUL:
        ;
        break;
      default:
        jj_la1[90] = jj_gen;
        break label_17;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MUL:
        jj_consume_token(MUL);
        break;
      case DIV:
        jj_consume_token(DIV);
        break;
      case MOD:
        jj_consume_token(MOD);
        break;
      case IDIV:
        jj_consume_token(IDIV);
        break;
      default:
        jj_la1[91] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        if (op == null) {
          op = new OperatorExpr();
          op.addOperand(operand);
          op.setCurrentop(true);
        }
        try{
            op.addOperator(token.image);
        } catch (Exception e){
            {if (true) throw new ParseException(e.getMessage());}
        }
      operand = ExponentExpr();
       op.addOperand(operand);
    }
       {if (true) return op==null?operand:op;}
    throw new Error("Missing return statement in function");
  }

  final public Expression ExponentExpr() throws ParseException, ParseException {
  OperatorExpr op = null;
  Expression operand = null;
    operand = UnaryExpr();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CARET:
      jj_consume_token(CARET);
        if (op == null) {
          op = new OperatorExpr();
          op.addOperand(operand);
          op.setCurrentop(true);
        }
        try{
            op.addOperator(token.image);
        } catch (Exception e){
            {if (true) throw new ParseException(e.getMessage());}
        }
      operand = UnaryExpr();
       op.addOperand(operand);
      break;
    default:
      jj_la1[92] = jj_gen;
      ;
    }
       {if (true) return op==null?operand:op;}
    throw new Error("Missing return statement in function");
  }

  final public Expression UnaryExpr() throws ParseException, ParseException {
    boolean not = false;
    UnaryExpr uexpr = null;
    Expression expr = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXISTS:
    case NOT:
    case MINUS:
    case PLUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        break;
      case EXISTS:
      case NOT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NOT:
          jj_consume_token(NOT);
                                   not = true;
          break;
        default:
          jj_la1[93] = jj_gen;
          ;
        }
        jj_consume_token(EXISTS);
        break;
      default:
        jj_la1[94] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        String exprType = token.image.toLowerCase();
        if(not){
           exprType = "not_" + exprType;
        }
        uexpr = new UnaryExpr();
        try{
            uexpr.setExprType(exprType);
        } catch (CompilationException e){
            {if (true) throw new ParseException(e.getMessage());}
        }
      break;
    default:
      jj_la1[95] = jj_gen;
      ;
    }
    expr = ValueExpr();
       if(uexpr==null){
            {if (true) return expr;}
       }
       uexpr.setExpr(expr);
       {if (true) return uexpr;}
    throw new Error("Missing return statement in function");
  }

  final public Expression ValueExpr() throws ParseException, ParseException {
  Expression expr = null;
  Identifier ident = null;
  AbstractAccessor fa = null;
  Expression indexExpr = null;
    expr = PrimaryExpr();
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LEFTBRACKET:
      case DOT:
        ;
        break;
      default:
        jj_la1[96] = jj_gen;
        break label_18;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        ident = Field();
      fa = (fa == null ? new FieldAccessor(expr, ident)
                       : new FieldAccessor(fa, ident));
        break;
      case LEFTBRACKET:
        indexExpr = Index();
      fa = (fa == null ? new IndexAccessor(expr, indexExpr)
                       : new IndexAccessor(fa, indexExpr));
        break;
      default:
        jj_la1[97] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
      {if (true) return fa == null ? expr : fa;}
    throw new Error("Missing return statement in function");
  }

  final public Identifier Field() throws ParseException, ParseException {
  String ident = null;
    jj_consume_token(DOT);
    ident = Identifier();
      {if (true) return new Identifier(ident);}
    throw new Error("Missing return statement in function");
  }

  final public Expression Index() throws ParseException, ParseException {
    Expression expr = null;
    jj_consume_token(LEFTBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ANY:
    case CASE:
    case EVERY:
    case EXISTS:
    case NOT:
    case SOME:
    case MINUS:
    case PLUS:
    case LEFTPAREN:
    case LEFTBRACKET:
    case LEFTBRACE:
    case LEFTDBLBRACE:
    case INTEGER_LITERAL:
    case MISSING:
    case NULL:
    case TRUE:
    case FALSE:
    case DOUBLE_LITERAL:
    case FLOAT_LITERAL:
    case QUOTED_STRING:
    case STRING_LITERAL:
    case IDENTIFIER:
      expr = Expression();
        if(expr.getKind() == Expression.Kind.LITERAL_EXPRESSION)
        {
            Literal lit = ((LiteralExpr)expr).getValue();
            if(lit.getLiteralType() != Literal.Type.INTEGER &&
               lit.getLiteralType() != Literal.Type.LONG) {
                {if (true) throw new ParseException("Index should be an INTEGER");}
            }
        }
      break;
    case QUES:
      jj_consume_token(QUES);
      break;
    default:
      jj_la1[98] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RIGHTBRACKET);
      {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public Expression PrimaryExpr() throws ParseException, ParseException {
  Expression expr = null;
    if (jj_2_5(4)) {
      expr = FunctionCallExpr();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case MISSING:
      case NULL:
      case TRUE:
      case FALSE:
      case DOUBLE_LITERAL:
      case FLOAT_LITERAL:
      case STRING_LITERAL:
        expr = Literal();
        break;
      case QUOTED_STRING:
      case IDENTIFIER:
        expr = VariableRef();
        break;
      case LEFTBRACKET:
      case LEFTDBLBRACE:
        expr = ListConstructor();
        break;
      case LEFTBRACE:
        expr = RecordConstructor();
        break;
      case LEFTPAREN:
        expr = ParenthesizedExpression();
        break;
      default:
        jj_la1[99] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
      {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public Expression Literal() throws ParseException, ParseException {
  LiteralExpr lit = new LiteralExpr();
  String str = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      str = StringLiteral();
      lit.setValue(new StringLiteral(str));
      break;
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
        try {
            lit.setValue(new LongIntegerLiteral(Long.valueOf(token.image)));
        } catch (NumberFormatException e) {
            {if (true) throw new ParseException("Could not parse numeric literal \u005c"" + token.image +'"');}
        }
      break;
    case FLOAT_LITERAL:
      jj_consume_token(FLOAT_LITERAL);
        try {
            lit.setValue(new FloatLiteral(Float.valueOf(token.image)));
        } catch (NumberFormatException e) {
            {if (true) throw new ParseException("Could not parse numeric literal \u005c"" + token.image +'"');}
        }
      break;
    case DOUBLE_LITERAL:
      jj_consume_token(DOUBLE_LITERAL);
        try {
            lit.setValue(new DoubleLiteral(Double.valueOf(token.image)));
        } catch (NumberFormatException e) {
            {if (true) throw new ParseException("Could not parse numeric literal \u005c"" + token.image +'"');}
        }
      break;
    case MISSING:
      jj_consume_token(MISSING);
      lit.setValue(MissingLiteral.INSTANCE);
      break;
    case NULL:
      jj_consume_token(NULL);
      lit.setValue(NullLiteral.INSTANCE);
      break;
    case TRUE:
      jj_consume_token(TRUE);
      lit.setValue(TrueLiteral.INSTANCE);
      break;
    case FALSE:
      jj_consume_token(FALSE);
      lit.setValue(FalseLiteral.INSTANCE);
      break;
    default:
      jj_la1[100] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return lit;}
    throw new Error("Missing return statement in function");
  }

  final public VariableExpr VariableRef() throws ParseException, ParseException {
    VariableExpr varExp = new VariableExpr();
    VarIdentifier var = new VarIdentifier();
      String id = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
                    id = token.image;
      break;
    case QUOTED_STRING:
      id = QuotedString();
      break;
    default:
      jj_la1[101] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     id = SqlppVariableUtil.toInternalVariableName(id); // Prefix user-defined variables with "$"
     Identifier ident = lookupSymbol(id);
     if (isInForbiddenScopes(id)) {
       {if (true) throw new ParseException("Inside limit clauses, it is disallowed to reference a variable having the same name as any variable bound in the same scope as the limit clause.");}
     }
     if(ident != null) { // exist such ident
       varExp.setVar((VarIdentifier)ident);
     } else {
       varExp.setVar(var);
       varExp.setIsNewVar(false);
       var.setValue(id);
     }
     {if (true) return varExp;}
    throw new Error("Missing return statement in function");
  }

  final public VariableExpr Variable() throws ParseException, ParseException {
    VariableExpr varExp = new VariableExpr();
    VarIdentifier var = new VarIdentifier();
      String id = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
                    id = token.image;
      break;
    case QUOTED_STRING:
      id = QuotedString();
      break;
    default:
      jj_la1[102] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     id = SqlppVariableUtil.toInternalVariableName(id); // prefix user-defined variables with "$".
     Identifier ident = lookupSymbol(id);
     if(ident != null) { // exist such ident
       varExp.setIsNewVar(false);
     }
     varExp.setVar(var);
     var.setValue(id);
     {if (true) return varExp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression ListConstructor() throws ParseException, ParseException {
    Expression expr = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEFTBRACKET:
      expr = OrderedListConstructor();
      break;
    case LEFTDBLBRACE:
      expr = UnorderedListConstructor();
      break;
    default:
      jj_la1[103] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public ListConstructor OrderedListConstructor() throws ParseException, ParseException {
      ListConstructor expr = new ListConstructor();
      List<Expression> exprList = null;
      expr.setType(ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR);
    jj_consume_token(LEFTBRACKET);
    exprList = ExpressionList();
    jj_consume_token(RIGHTBRACKET);
      expr.setExprList(exprList);
      {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public ListConstructor UnorderedListConstructor() throws ParseException, ParseException {
      ListConstructor expr = new ListConstructor();
      List<Expression> exprList = null;
      expr.setType(ListConstructor.Type.UNORDERED_LIST_CONSTRUCTOR);
    jj_consume_token(LEFTDBLBRACE);
    exprList = ExpressionList();
    jj_consume_token(RIGHTDBLBRACE);
      expr.setExprList(exprList);
      {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public List<Expression> ExpressionList() throws ParseException, ParseException {
      Expression expr = null;
      List<Expression> list = null;
      List<Expression> exprList = new ArrayList<Expression>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ANY:
    case CASE:
    case EVERY:
    case EXISTS:
    case NOT:
    case SOME:
    case MINUS:
    case PLUS:
    case LEFTPAREN:
    case LEFTBRACKET:
    case LEFTBRACE:
    case LEFTDBLBRACE:
    case INTEGER_LITERAL:
    case MISSING:
    case NULL:
    case TRUE:
    case FALSE:
    case DOUBLE_LITERAL:
    case FLOAT_LITERAL:
    case QUOTED_STRING:
    case STRING_LITERAL:
    case IDENTIFIER:
      expr = Expression();
                            exprList.add(expr);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        list = ExpressionList();
                                                      exprList.addAll(list);
        break;
      default:
        jj_la1[104] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[105] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      Comma();
      break;
    default:
      jj_la1[106] = jj_gen;
      ;
    }
        {if (true) return exprList;}
    throw new Error("Missing return statement in function");
  }

  final public void Comma() throws ParseException {
    jj_consume_token(COMMA);
  }

  final public RecordConstructor RecordConstructor() throws ParseException, ParseException {
      RecordConstructor expr = new RecordConstructor();
      FieldBinding tmp = null;
      List<FieldBinding> fbList = new ArrayList<FieldBinding>();
    jj_consume_token(LEFTBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ANY:
    case CASE:
    case EVERY:
    case EXISTS:
    case NOT:
    case SOME:
    case MINUS:
    case PLUS:
    case LEFTPAREN:
    case LEFTBRACKET:
    case LEFTBRACE:
    case LEFTDBLBRACE:
    case INTEGER_LITERAL:
    case MISSING:
    case NULL:
    case TRUE:
    case FALSE:
    case DOUBLE_LITERAL:
    case FLOAT_LITERAL:
    case QUOTED_STRING:
    case STRING_LITERAL:
    case IDENTIFIER:
      tmp = FieldBinding();
      fbList.add(tmp);
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[107] = jj_gen;
          break label_19;
        }
        jj_consume_token(COMMA);
        tmp = FieldBinding();
                                    fbList.add(tmp);
      }
      break;
    default:
      jj_la1[108] = jj_gen;
      ;
    }
    jj_consume_token(RIGHTBRACE);
      expr.setFbList(fbList);
      {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public FieldBinding FieldBinding() throws ParseException, ParseException {
    FieldBinding fb = new FieldBinding();
    Expression left, right;
    left = Expression();
    jj_consume_token(COLON);
    right = Expression();
      fb.setLeftExpr(left);
      fb.setRightExpr(right);
      {if (true) return fb;}
    throw new Error("Missing return statement in function");
  }

  final public Expression FunctionCallExpr() throws ParseException, ParseException {
  CallExpr callExpr;
  List<Expression> argList = new ArrayList<Expression>();
  Expression tmp = null;
  int arity = 0;
  FunctionName funcName = null;
  String hint = null;
  boolean star = false;
    funcName = FunctionName();
      hint = funcName.hint;
    jj_consume_token(LEFTPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ANY:
    case CASE:
    case EVERY:
    case EXISTS:
    case NOT:
    case SOME:
    case MINUS:
    case MUL:
    case PLUS:
    case LEFTPAREN:
    case LEFTBRACKET:
    case LEFTBRACE:
    case LEFTDBLBRACE:
    case INTEGER_LITERAL:
    case MISSING:
    case NULL:
    case TRUE:
    case FALSE:
    case DOUBLE_LITERAL:
    case FLOAT_LITERAL:
    case QUOTED_STRING:
    case STRING_LITERAL:
    case IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANY:
      case CASE:
      case EVERY:
      case EXISTS:
      case NOT:
      case SOME:
      case MINUS:
      case PLUS:
      case LEFTPAREN:
      case LEFTBRACKET:
      case LEFTBRACE:
      case LEFTDBLBRACE:
      case INTEGER_LITERAL:
      case MISSING:
      case NULL:
      case TRUE:
      case FALSE:
      case DOUBLE_LITERAL:
      case FLOAT_LITERAL:
      case QUOTED_STRING:
      case STRING_LITERAL:
      case IDENTIFIER:
        tmp = Expression();
        break;
      case MUL:
        jj_consume_token(MUL);
                                               star = true;
        break;
      default:
        jj_la1[109] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if(star){
        if(!funcName.function.toLowerCase().equals("count")){
           {if (true) throw new ParseException("The parameter * can only be used in COUNT().");}
        }
        argList.add(new LiteralExpr(new LongIntegerLiteral(1L)));
      } else {
         argList.add(tmp);
      }
      arity ++;
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[110] = jj_gen;
          break label_20;
        }
        jj_consume_token(COMMA);
        tmp = Expression();
      argList.add(tmp);
      arity++;
      }
      break;
    default:
      jj_la1[111] = jj_gen;
      ;
    }
    jj_consume_token(RIGHTPAREN);
      // TODO use funcName.library
      String fqFunctionName = funcName.library == null ? funcName.function : funcName.library + "#" + funcName.function;
      FunctionSignature signature
        = lookupFunctionSignature(funcName.dataverse, fqFunctionName, arity);
      if (signature == null) {
        signature = new FunctionSignature(funcName.dataverse, fqFunctionName, arity);
      }
      callExpr = new CallExpr(signature,argList);
      if (hint != null) {
        if (hint.startsWith(INDEXED_NESTED_LOOP_JOIN_HINT)) {
          callExpr.addHint(IndexedNLJoinExpressionAnnotation.INSTANCE);
        } else if (hint.startsWith(SKIP_SECONDARY_INDEX_SEARCH_HINT)) {
          callExpr.addHint(SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE);
        }
      }
      {if (true) return callExpr;}
    throw new Error("Missing return statement in function");
  }

  final public Expression ParenthesizedExpression() throws ParseException, ParseException {
  Expression expr;
    if (jj_2_6(2)) {
      jj_consume_token(LEFTPAREN);
      expr = Expression();
      jj_consume_token(RIGHTPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LEFTPAREN:
        expr = Subquery();
        break;
      default:
        jj_la1[112] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
      {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public Expression CaseExpr() throws ParseException, ParseException {
   Expression conditionExpr = new LiteralExpr(TrueLiteral.INSTANCE);
   List<Expression> whenExprs = new ArrayList<Expression>();
   List<Expression> thenExprs = new ArrayList<Expression>();
   Expression elseExpr = null;

   Expression whenExpr = null;
   Expression thenExpr = null;
    jj_consume_token(CASE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ANY:
    case CASE:
    case EVERY:
    case EXISTS:
    case NOT:
    case SOME:
    case MINUS:
    case PLUS:
    case LEFTPAREN:
    case LEFTBRACKET:
    case LEFTBRACE:
    case LEFTDBLBRACE:
    case INTEGER_LITERAL:
    case MISSING:
    case NULL:
    case TRUE:
    case FALSE:
    case DOUBLE_LITERAL:
    case FLOAT_LITERAL:
    case QUOTED_STRING:
    case STRING_LITERAL:
    case IDENTIFIER:
      conditionExpr = Expression();
      break;
    default:
      jj_la1[113] = jj_gen;
      ;
    }
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        ;
        break;
      default:
        jj_la1[114] = jj_gen;
        break label_21;
      }
      jj_consume_token(WHEN);
      whenExpr = Expression();
        whenExprs.add(whenExpr);
      jj_consume_token(THEN);
      thenExpr = Expression();
        thenExprs.add(thenExpr);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
      elseExpr = Expression();
      break;
    default:
      jj_la1[115] = jj_gen;
      ;
    }
    jj_consume_token(END);
     {if (true) return new CaseExpression(conditionExpr, whenExprs, thenExprs, elseExpr);}
    throw new Error("Missing return statement in function");
  }

  final public SelectExpression SelectExpression(boolean subquery) throws ParseException, ParseException {
  List<LetClause> letClauses = new ArrayList<LetClause>();
  SelectSetOperation selectSetOperation;
  OrderbyClause orderbyClause = null;
  LimitClause limitClause = null;
  createNewScope();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LETTING:
    case LET:
    case WITH:
      letClauses = LetClause();
      break;
    default:
      jj_la1[116] = jj_gen;
      ;
    }
    selectSetOperation = SelectSetOperation();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderbyClause = OrderbyClause();

      break;
    default:
      jj_la1[117] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIMIT:
      limitClause = LimitClause();

      break;
    default:
      jj_la1[118] = jj_gen;
      ;
    }
      {if (true) return new SelectExpression(letClauses, selectSetOperation, orderbyClause, limitClause, subquery);}
    throw new Error("Missing return statement in function");
  }

  final public SelectSetOperation SelectSetOperation() throws ParseException, ParseException {
  SetOperationInput setOperationInputLeft;
  List<SetOperationRight> setOperationRights = new ArrayList<SetOperationRight>();
      SelectBlock selectBlockLeft = null;
      SelectExpression subqueryLeft = null;
      Expression expr = null;
    selectBlockLeft = SelectBlock();
     setOperationInputLeft = new SetOperationInput(selectBlockLeft, subqueryLeft);
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXCEPT:
      case INTERSECT:
      case UNION:
        ;
        break;
      default:
        jj_la1[119] = jj_gen;
        break label_22;
      }
      SetOpType opType = SetOpType.UNION;
      boolean setSemantics = true;
      SelectBlock selectBlockRight = null;
      SelectExpression subqueryRight = null;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNION:
        jj_consume_token(UNION);
              opType = SetOpType.UNION;
        break;
      case INTERSECT:
        jj_consume_token(INTERSECT);
                                                       opType = SetOpType.INTERSECT;
        break;
      case EXCEPT:
        jj_consume_token(EXCEPT);
                                                                                                 opType = SetOpType.EXCEPT;
        break;
      default:
        jj_la1[120] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
                                                                                                                                      setSemantics = false;
        break;
      default:
        jj_la1[121] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
      case SELECT:
        selectBlockRight = SelectBlock();
        break;
      case LEFTPAREN:
        subqueryRight = Subquery();
        break;
      default:
        jj_la1[122] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        setOperationRights.add(new SetOperationRight(opType, setSemantics, new SetOperationInput(selectBlockRight, subqueryRight)));
    }
    {if (true) return new SelectSetOperation(setOperationInputLeft, setOperationRights);}
    throw new Error("Missing return statement in function");
  }

  final public SelectExpression Subquery() throws ParseException, ParseException {
   SelectExpression selectExpr = null;
    jj_consume_token(LEFTPAREN);
    selectExpr = SelectExpression(true);

    jj_consume_token(RIGHTPAREN);
    {if (true) return selectExpr;}
    throw new Error("Missing return statement in function");
  }

  final public SelectBlock SelectBlock() throws ParseException, ParseException {
  SelectClause selectClause = null;
  FromClause fromClause = null;
  List<LetClause> fromLetClauses = null;
  WhereClause whereClause = null;
  GroupbyClause groupbyClause = null;
  List<LetClause> gbyLetClauses = null;
  HavingClause havingClause = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
      selectClause = SelectClause();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        fromClause = FromClause();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LETTING:
        case LET:
        case WITH:
          fromLetClauses = LetClause();
          break;
        default:
          jj_la1[123] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[124] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHERE:
        whereClause = WhereClause();
        break;
      default:
        jj_la1[125] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GROUP:
        groupbyClause = GroupbyClause();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LETTING:
        case LET:
        case WITH:
          gbyLetClauses = LetClause();
          break;
        default:
          jj_la1[126] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case HAVING:
          havingClause = HavingClause();
          break;
        default:
          jj_la1[127] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[128] = jj_gen;
        ;
      }
      break;
    case FROM:
      fromClause = FromClause();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LETTING:
      case LET:
      case WITH:
        fromLetClauses = LetClause();
        break;
      default:
        jj_la1[129] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHERE:
        whereClause = WhereClause();
        break;
      default:
        jj_la1[130] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GROUP:
        groupbyClause = GroupbyClause();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LETTING:
        case LET:
        case WITH:
          gbyLetClauses = LetClause();
          break;
        default:
          jj_la1[131] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case HAVING:
          havingClause = HavingClause();
          break;
        default:
          jj_la1[132] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[133] = jj_gen;
        ;
      }
      selectClause = SelectClause();
      break;
    default:
      jj_la1[134] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return new SelectBlock(selectClause, fromClause, fromLetClauses, whereClause, groupbyClause, gbyLetClauses, havingClause);}
    throw new Error("Missing return statement in function");
  }

  final public SelectClause SelectClause() throws ParseException, ParseException {
  SelectRegular selectRegular = null;
  SelectElement selectElement = null;
  boolean distinct = false;
    jj_consume_token(SELECT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
    case DISTINCT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
        break;
      case DISTINCT:
        jj_consume_token(DISTINCT);
                              distinct = true;
        break;
      default:
        jj_la1[135] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[136] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ANY:
    case CASE:
    case ELEMENT:
    case EVERY:
    case EXISTS:
    case NOT:
    case RAW:
    case SOME:
    case VALUE:
    case MINUS:
    case MUL:
    case PLUS:
    case LEFTPAREN:
    case LEFTBRACKET:
    case LEFTBRACE:
    case LEFTDBLBRACE:
    case INTEGER_LITERAL:
    case MISSING:
    case NULL:
    case TRUE:
    case FALSE:
    case DOUBLE_LITERAL:
    case FLOAT_LITERAL:
    case QUOTED_STRING:
    case STRING_LITERAL:
    case IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANY:
      case CASE:
      case EVERY:
      case EXISTS:
      case NOT:
      case SOME:
      case MINUS:
      case MUL:
      case PLUS:
      case LEFTPAREN:
      case LEFTBRACKET:
      case LEFTBRACE:
      case LEFTDBLBRACE:
      case INTEGER_LITERAL:
      case MISSING:
      case NULL:
      case TRUE:
      case FALSE:
      case DOUBLE_LITERAL:
      case FLOAT_LITERAL:
      case QUOTED_STRING:
      case STRING_LITERAL:
      case IDENTIFIER:
        selectRegular = SelectRegular();
        break;
      case ELEMENT:
      case RAW:
      case VALUE:
        selectElement = SelectElement();
        break;
      default:
        jj_la1[137] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[138] = jj_gen;
      ;
    }
    if(selectRegular == null && selectElement == null){
        Projection projection = new Projection(null, null, true, false);
        List<Projection> projections = new ArrayList<Projection>();
        projections.add(projection);
        selectRegular = new SelectRegular(projections);
    }
    {if (true) return new SelectClause(selectElement, selectRegular, distinct);}
    throw new Error("Missing return statement in function");
  }

  final public SelectRegular SelectRegular() throws ParseException, ParseException {
  List<Projection> projections = new ArrayList<Projection>();
      Projection projection = null;
    projection = Projection();
                               projections.add(projection);
    label_23:
    while (true) {
      if (jj_2_7(2)) {
        ;
      } else {
        break label_23;
      }
      jj_consume_token(COMMA);
      projection = Projection();
                                  projections.add(projection);
    }
    {if (true) return new SelectRegular(projections);}
    throw new Error("Missing return statement in function");
  }

  final public SelectElement SelectElement() throws ParseException, ParseException {
  Expression expr = null;
  String name = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RAW:
      jj_consume_token(RAW);
      break;
    case ELEMENT:
      jj_consume_token(ELEMENT);
      break;
    case VALUE:
      jj_consume_token(VALUE);
      break;
    default:
      jj_la1[139] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    expr = Expression();
    {if (true) return new SelectElement(expr);}
    throw new Error("Missing return statement in function");
  }

  final public Projection Projection() throws ParseException, ParseException {
  Expression expr = null;
  Identifier identifier = null;
  String name = null;
  boolean star = false;
  boolean exprStar = false;
    if (jj_2_8(2)) {
      expr = Expression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
      case QUOTED_STRING:
      case IDENTIFIER:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AS:
          jj_consume_token(AS);
          break;
        default:
          jj_la1[140] = jj_gen;
          ;
        }
        name = Identifier();
        break;
      default:
        jj_la1[141] = jj_gen;
        ;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANY:
      case CASE:
      case EVERY:
      case EXISTS:
      case NOT:
      case SOME:
      case MINUS:
      case PLUS:
      case LEFTPAREN:
      case LEFTBRACKET:
      case LEFTBRACE:
      case LEFTDBLBRACE:
      case INTEGER_LITERAL:
      case MISSING:
      case NULL:
      case TRUE:
      case FALSE:
      case DOUBLE_LITERAL:
      case FLOAT_LITERAL:
      case QUOTED_STRING:
      case STRING_LITERAL:
      case IDENTIFIER:
        expr = Expression();
        jj_consume_token(DOT);
        jj_consume_token(MUL);
                                       exprStar = true;
        break;
      case MUL:
        jj_consume_token(MUL);
             star = true;
        break;
      default:
        jj_la1[142] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    if(!star && name == null){
       String generatedColumnIdentifier = ExpressionToVariableUtil.getGeneratedIdentifier(expr, false);
       if(generatedColumnIdentifier != null){
            name = SqlppVariableUtil.toUserDefinedName(generatedColumnIdentifier);
       }
    }
    {if (true) return new Projection(expr, name, star, exprStar);}
    throw new Error("Missing return statement in function");
  }

  final public FromClause FromClause() throws ParseException, ParseException {
  List<FromTerm> fromTerms = new ArrayList<FromTerm>();
  extendCurrentScope();
    FromTerm fromTerm = null;
    jj_consume_token(FROM);
    fromTerm = FromTerm();
                                   fromTerms.add(fromTerm);
    label_24:
    while (true) {
      if (jj_2_9(2)) {
        ;
      } else {
        break label_24;
      }
      jj_consume_token(COMMA);
      fromTerm = FromTerm();
                                                  fromTerms.add(fromTerm);
    }
    {if (true) return new FromClause(fromTerms);}
    throw new Error("Missing return statement in function");
  }

  final public FromTerm FromTerm() throws ParseException, ParseException {
  Expression leftExpr = null;
  VariableExpr leftVar = null;
  VariableExpr posVar = null;
  List<AbstractBinaryCorrelateClause> correlateClauses = new ArrayList<AbstractBinaryCorrelateClause>();
    leftExpr = Expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
    case QUOTED_STRING:
    case IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[143] = jj_gen;
        ;
      }
      leftVar = Variable();
      break;
    default:
      jj_la1[144] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AT:
      jj_consume_token(AT);
      posVar = Variable();
      break;
    default:
      jj_la1[145] = jj_gen;
      ;
    }
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CORRELATE:
      case FLATTEN:
      case INNER:
      case JOIN:
      case LEFT:
      case UNNEST:
        ;
        break;
      default:
        jj_la1[146] = jj_gen;
        break label_25;
      }
      JoinType joinType = JoinType.INNER;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INNER:
      case LEFT:
        joinType = JoinType();
        break;
      default:
        jj_la1[147] = jj_gen;
        ;
      }
       AbstractBinaryCorrelateClause correlateClause = null;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case JOIN:
        correlateClause = JoinClause(joinType);
        break;
      case CORRELATE:
      case FLATTEN:
      case UNNEST:
        correlateClause = UnnestClause(joinType);
        break;
      default:
        jj_la1[148] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        correlateClauses.add(correlateClause);
    }
    if(leftVar==null){
        leftVar = ExpressionToVariableUtil.getGeneratedVariable(leftExpr, true);
    }
    {if (true) return new FromTerm(leftExpr, leftVar, posVar, correlateClauses);}
    throw new Error("Missing return statement in function");
  }

  final public JoinClause JoinClause(JoinType joinType) throws ParseException, ParseException {
    Expression rightExpr = null;
    VariableExpr rightVar = null;
    VariableExpr posVar = null;
    Expression conditionExpr = null;
    jj_consume_token(JOIN);
    rightExpr = Expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
    case QUOTED_STRING:
    case IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[149] = jj_gen;
        ;
      }
      rightVar = Variable();
      break;
    default:
      jj_la1[150] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AT:
      jj_consume_token(AT);
      posVar = Variable();
      break;
    default:
      jj_la1[151] = jj_gen;
      ;
    }
    jj_consume_token(ON);
    conditionExpr = Expression();
    if(rightVar==null){
        rightVar = ExpressionToVariableUtil.getGeneratedVariable(rightExpr, true);
    }
    {if (true) return new JoinClause(joinType, rightExpr, rightVar, posVar, conditionExpr);}
    throw new Error("Missing return statement in function");
  }

  final public UnnestClause UnnestClause(JoinType joinType) throws ParseException, ParseException {
    Expression rightExpr;
    VariableExpr rightVar;
    VariableExpr posVar = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNNEST:
      jj_consume_token(UNNEST);
      break;
    case CORRELATE:
      jj_consume_token(CORRELATE);
      break;
    case FLATTEN:
      jj_consume_token(FLATTEN);
      break;
    default:
      jj_la1[152] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    rightExpr = Expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      break;
    default:
      jj_la1[153] = jj_gen;
      ;
    }
    rightVar = Variable();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AT:
      jj_consume_token(AT);
      posVar = Variable();
      break;
    default:
      jj_la1[154] = jj_gen;
      ;
    }
    if(rightVar==null){
        rightVar = ExpressionToVariableUtil.getGeneratedVariable(rightExpr, true);
    }
    {if (true) return new UnnestClause(joinType, rightExpr, rightVar, posVar);}
    throw new Error("Missing return statement in function");
  }

  final public JoinType JoinType() throws ParseException, ParseException {
   JoinType joinType = JoinType.INNER;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INNER:
      jj_consume_token(INNER);
      break;
    case LEFT:
      jj_consume_token(LEFT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OUTER:
        jj_consume_token(OUTER);
        break;
      default:
        jj_la1[155] = jj_gen;
        ;
      }
                                 joinType = JoinType.LEFTOUTER;
      break;
    default:
      jj_la1[156] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
       {if (true) return joinType;}
    throw new Error("Missing return statement in function");
  }

  final public List<LetClause> LetClause() throws ParseException, ParseException {
    List<LetClause> letList = new ArrayList<LetClause>();
    LetClause letClause;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LETTING:
    case LET:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LET:
        jj_consume_token(LET);
        break;
      case LETTING:
        jj_consume_token(LETTING);
        break;
      default:
        jj_la1[157] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      letClause = LetElement();
                                                  letList.add(letClause);
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[158] = jj_gen;
          break label_26;
        }
        jj_consume_token(COMMA);
        letClause = LetElement();
                                                                                                                             letList.add(letClause);
      }
      break;
    case WITH:
      jj_consume_token(WITH);
      letClause = WithElement();
                                        letList.add(letClause);
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[159] = jj_gen;
          break label_27;
        }
        jj_consume_token(COMMA);
        letClause = WithElement();
                                                                                                                    letList.add(letClause);
      }
      break;
    default:
      jj_la1[160] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return letList;}
    throw new Error("Missing return statement in function");
  }

  final public WhereClause WhereClause() throws ParseException, ParseException {
  WhereClause wc = new WhereClause();
  Expression whereExpr;
    jj_consume_token(WHERE);
    whereExpr = Expression();
      wc.setWhereExpr(whereExpr);
      {if (true) return wc;}
    throw new Error("Missing return statement in function");
  }

  final public OrderbyClause OrderbyClause() throws ParseException, ParseException {
    OrderbyClause oc = new OrderbyClause();
    Expression orderbyExpr;
    List<Expression> orderbyList = new ArrayList<Expression>();
    List<OrderbyClause.OrderModifier> modifierList = new ArrayList<OrderbyClause.OrderModifier >();
    int numOfOrderby = 0;
    jj_consume_token(ORDER);
        String hint = getHint(token);
        if (hint != null) {
          if (hint.startsWith(INMEMORY_HINT)) {
            String splits[] = hint.split(" +");
            int numFrames = Integer.parseInt(splits[1]);
            int numTuples = Integer.parseInt(splits[2]);
            oc.setNumFrames(numFrames);
            oc.setNumTuples(numTuples);
          }
        }
    jj_consume_token(BY);
    orderbyExpr = Expression();
      orderbyList.add(orderbyExpr);
      OrderbyClause.OrderModifier modif = OrderbyClause.OrderModifier.ASC;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASC:
    case DESC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASC:
        jj_consume_token(ASC);
               modif = OrderbyClause.OrderModifier.ASC;
        break;
      case DESC:
        jj_consume_token(DESC);
                modif = OrderbyClause.OrderModifier.DESC;
        break;
      default:
        jj_la1[161] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[162] = jj_gen;
      ;
    }
      modifierList.add(modif);
    label_28:
    while (true) {
      if (jj_2_10(2)) {
        ;
      } else {
        break label_28;
      }
      jj_consume_token(COMMA);
      orderbyExpr = Expression();
      orderbyList.add(orderbyExpr);
      modif = OrderbyClause.OrderModifier.ASC;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASC:
      case DESC:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ASC:
          jj_consume_token(ASC);
               modif = OrderbyClause.OrderModifier.ASC;
          break;
        case DESC:
          jj_consume_token(DESC);
                modif = OrderbyClause.OrderModifier.DESC;
          break;
        default:
          jj_la1[163] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[164] = jj_gen;
        ;
      }
      modifierList.add(modif);
    }
      oc.setModifierList(modifierList);
      oc.setOrderbyList(orderbyList);
      {if (true) return oc;}
    throw new Error("Missing return statement in function");
  }

  final public GroupbyClause GroupbyClause() throws ParseException, ParseException {
    GroupbyClause gbc = new GroupbyClause();
    List<GbyVariableExpressionPair> vePairList = new ArrayList<GbyVariableExpressionPair>();
    VariableExpr var = null;
    Expression expr = null;
    VariableExpr decorVar = null;
    Expression decorExpr = null;

    VariableExpr groupVar = null;
    List<Pair<Expression, Identifier>> groupFieldList = new ArrayList<Pair<Expression, Identifier>>();
        Scope newScope = extendCurrentScopeNoPush(true);
        // extendCurrentScope(true);

    jj_consume_token(GROUP);
         String hint = getHint(token);
         if (hint != null && hint.equals(HASH_GROUP_BY_HINT)) {
           gbc.setHashGroupByHint(true);
         }
    jj_consume_token(BY);
    expr = Expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
    case QUOTED_STRING:
    case IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[165] = jj_gen;
        ;
      }
      var = Variable();
      break;
    default:
      jj_la1[166] = jj_gen;
      ;
    }
            if(var==null){
                var = ExpressionToVariableUtil.getGeneratedVariable(expr, false);
            }
            GbyVariableExpressionPair pair1 = new GbyVariableExpressionPair(var, expr);
            vePairList.add(pair1);
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[167] = jj_gen;
        break label_29;
      }
      jj_consume_token(COMMA);
            var = null;
      expr = Expression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
      case QUOTED_STRING:
      case IDENTIFIER:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AS:
          jj_consume_token(AS);
          break;
        default:
          jj_la1[168] = jj_gen;
          ;
        }
        var = Variable();
        break;
      default:
        jj_la1[169] = jj_gen;
        ;
      }
             if(var==null){
                var = ExpressionToVariableUtil.getGeneratedVariable(expr, false);
             }
             GbyVariableExpressionPair pair2 = new GbyVariableExpressionPair(var, expr);
             vePairList.add(pair2);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GROUP:
      jj_consume_token(GROUP);
      jj_consume_token(AS);
      groupVar = Variable();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LEFTPAREN:
            VariableExpr fieldVarExpr = null;
            String fieldIdentifierStr = null;
        jj_consume_token(LEFTPAREN);
        fieldVarExpr = VariableRef();
        jj_consume_token(AS);
        fieldIdentifierStr = Identifier();
                   groupFieldList.add(new Pair<Expression, Identifier>(fieldVarExpr, new Identifier(fieldIdentifierStr)));
        label_30:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[170] = jj_gen;
            break label_30;
          }
          jj_consume_token(COMMA);
          fieldVarExpr = VariableRef();
          jj_consume_token(AS);
          fieldIdentifierStr = Identifier();
                   groupFieldList.add(new Pair<Expression, Identifier>(fieldVarExpr, new Identifier(fieldIdentifierStr)));
        }
        jj_consume_token(RIGHTPAREN);
        break;
      default:
        jj_la1[171] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[172] = jj_gen;
      ;
    }
      gbc.setGbyPairList(vePairList);
      gbc.setDecorPairList(new ArrayList<GbyVariableExpressionPair>());
      gbc.setWithVarMap(new HashMap<Expression, VariableExpr>());
      gbc.setGroupVar(groupVar);
      gbc.setGroupFieldList(groupFieldList);
      replaceCurrentScope(newScope);
      {if (true) return gbc;}
    throw new Error("Missing return statement in function");
  }

  final public HavingClause HavingClause() throws ParseException, ParseException {
   Expression filterExpr = null;
    jj_consume_token(HAVING);
    filterExpr = Expression();
       {if (true) return new HavingClause(filterExpr);}
    throw new Error("Missing return statement in function");
  }

  final public LimitClause LimitClause() throws ParseException, ParseException {
    LimitClause lc = new LimitClause();
    Expression expr;
    pushForbiddenScope(getCurrentScope());
    jj_consume_token(LIMIT);
    expr = Expression();
                                     lc.setLimitExpr(expr);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OFFSET:
      jj_consume_token(OFFSET);
      expr = Expression();
                                    lc.setOffset(expr);
      break;
    default:
      jj_la1[173] = jj_gen;
      ;
    }
    popForbiddenScope();
    {if (true) return lc;}
    throw new Error("Missing return statement in function");
  }

  final public QuantifiedExpression QuantifiedExpression() throws ParseException, ParseException {
  QuantifiedExpression qc = new QuantifiedExpression();
  List<QuantifiedPair> quantifiedList = new ArrayList<QuantifiedPair>();
  Expression satisfiesExpr;
  VariableExpr var;
  Expression inExpr;
  QuantifiedPair pair;
    createNewScope();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ANY:
    case SOME:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANY:
        jj_consume_token(ANY);
        break;
      case SOME:
        jj_consume_token(SOME);
        break;
      default:
        jj_la1[174] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                              qc.setQuantifier(QuantifiedExpression.Quantifier.SOME);
      break;
    case EVERY:
      jj_consume_token(EVERY);
                      qc.setQuantifier(QuantifiedExpression.Quantifier.EVERY);
      break;
    default:
      jj_la1[175] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    var = Variable();
    jj_consume_token(IN);
    inExpr = Expression();
      pair = new QuantifiedPair(var, inExpr);
      quantifiedList.add(pair);
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[176] = jj_gen;
        break label_31;
      }
      jj_consume_token(COMMA);
      var = Variable();
      jj_consume_token(IN);
      inExpr = Expression();
      pair = new QuantifiedPair(var, inExpr);
      quantifiedList.add(pair);
    }
    jj_consume_token(SATISFIES);
    satisfiesExpr = Expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case END:
      jj_consume_token(END);
      break;
    default:
      jj_la1[177] = jj_gen;
      ;
    }
       qc.setSatisfiesExpr(satisfiesExpr);
       qc.setQuantifiedList(quantifiedList);
       removeCurrentScope();
       {if (true) return qc;}
    throw new Error("Missing return statement in function");
  }

  final public LetClause LetElement() throws ParseException, ParseException {
    LetClause lc = new LetClause();
    VariableExpr varExp;
    Expression beExp;
    extendCurrentScope();
    varExp = Variable();
    jj_consume_token(EQ);
    beExp = Expression();
      lc.setVarExpr(varExp);
      lc.setBindingExpr(beExp);
      {if (true) return lc;}
    throw new Error("Missing return statement in function");
  }

  final public LetClause WithElement() throws ParseException, ParseException {
    LetClause lc = new LetClause();
    VariableExpr varExp;
    Expression beExp;
    extendCurrentScope();
    varExp = Variable();
    jj_consume_token(AS);
    beExp = Expression();
      lc.setVarExpr(varExp);
      lc.setBindingExpr(beExp);
      {if (true) return lc;}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_3R_80() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_82()) jj_scanpos = xsp;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_63() {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_113() {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3_4() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_35()) jj_scanpos = xsp;
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_3R_36()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_scan_token(LEFTPAREN)) return true;
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_99() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) return true;
    }
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_52() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    }
    return false;
  }

  private boolean jj_3_7() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_3R_36()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_96() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) return true;
    }
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_scan_token(MUL)) return true;
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_scan_token(CARET)) return true;
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_scan_token(SHARP)) return true;
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_3R_80()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_100()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_scan_token(WITH)) return true;
    if (jj_scan_token(FILTER)) return true;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_106() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_47() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_59()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_136() {
    if (jj_scan_token(SELECT)) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_scan_token(MISSING)) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_scan_token(EVERY)) return true;
    return false;
  }

  private boolean jj_3R_69() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) return true;
    }
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_scan_token(DOUBLE_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_94() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_133() {
    if (jj_scan_token(WITH)) return true;
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_scan_token(SHARP)) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_3R_76()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_94()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_37() {
    if (jj_3R_46()) return true;
    if (jj_scan_token(LEFTPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_47()) jj_scanpos = xsp;
    if (jj_scan_token(RIGHTPAREN)) return true;
    return false;
  }

  private boolean jj_3R_61() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) return true;
    }
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_132() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) return true;
    }
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_scan_token(FLOAT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_56() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) return true;
    }
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_52()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_77()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_130() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) return true;
    }
    return false;
  }

  private boolean jj_3_3() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(130)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(133)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_3R_33()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_135() {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_3R_52()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_56()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_3R_34()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_3()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_95() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_101()) {
    jj_scanpos = xsp;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_124() {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_123() {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_87() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) return true;
    }
    return false;
  }

  private boolean jj_3R_131() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) return true;
    }
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_53() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_64()) jj_scanpos = xsp;
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_55() {
    if (jj_3R_66()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_87()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_scan_token(LEFTBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_123()) jj_scanpos = xsp;
    if (jj_scan_token(RIGHTBRACE)) return true;
    return false;
  }

  private boolean jj_3R_86() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_114() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_117() {
    if (jj_scan_token(LEFTPAREN)) return true;
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_127() {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  private boolean jj_3R_125() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_127()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(123)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_scan_token(AND)) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_scan_token(CONCAT)) return true;
    return false;
  }

  private boolean jj_3R_122() {
    if (jj_scan_token(LEFTBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_112() {
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_3R_53()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_54()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_3R_55()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_84()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_scan_token(LEFTDBLBRACE)) return true;
    if (jj_3R_125()) return true;
    if (jj_scan_token(RIGHTDBLBRACE)) return true;
    return false;
  }

  private boolean jj_3R_121() {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_41() {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_120() {
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3R_115() {
    if (jj_scan_token(LEFTBRACKET)) return true;
    if (jj_3R_125()) return true;
    if (jj_scan_token(RIGHTBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_scan_token(IS)) return true;
    return false;
  }

  private boolean jj_3R_36() {
    if (jj_3R_45()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_81()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_41()) return true;
    return false;
  }

  private boolean jj_3R_128() {
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_126() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_128()) jj_scanpos = xsp;
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_119() {
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_118() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_119()) {
    jj_scanpos = xsp;
    if (jj_3R_120()) return true;
    }
    return false;
  }

  private boolean jj_3R_40() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(5)) jj_scanpos = xsp;
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_137() {
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_43() {
    if (jj_scan_token(OR)) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_3R_86()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_118()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_111() {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_32() {
    if (jj_3R_42()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_43()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_97() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) return true;
    }
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_85() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_88()) jj_scanpos = xsp;
    if (jj_scan_token(EXISTS)) return true;
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_scan_token(ELSE)) return true;
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_51() {
    if (jj_scan_token(MUL)) return true;
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_3R_61()) return true;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_scan_token(WHEN)) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_38()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_40()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3R_39() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_scan_token(CASE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_71()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_72()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_73()) jj_scanpos = xsp;
    if (jj_scan_token(END)) return true;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_74() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) return true;
    }
    return false;
  }

  private boolean jj_3R_33() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_44()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) return true;
    }
    return false;
  }

  private boolean jj_3R_38() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_82() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) {
    jj_scanpos = xsp;
    if (jj_3R_85()) return true;
    }
    }
    return false;
  }

  /** Generated Token Manager. */
  public SQLPPParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[178];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
      jj_la1_init_5();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x55435008,0x0,0x55435008,0x380000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x180000,0x0,0x0,0x0,0x0,0x0,0x400,0x10,0x0,0x10,0x0,0x800000,0x800000,0x0,0x0,0x0,0x0,0x0,0x380000,0x0,0x20,0x0,0x20,0x0,0x20,0x20,0x0,0x0,0x80000000,0x1000000,0x0,0x0,0x4020000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x2000,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x180000,0x0,0x0,0x0,0x0,0x0,0x0,0x1008,0x1008,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1008,0x0,0x0,0x0,0x0,0x0,0x0,0x1008,0x0,0x0,0x1008,0x1008,0x0,0x1008,0x0,0x1008,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000002,0x8000002,0x20001008,0x20001008,0x20000000,0x20,0x20,0x1008,0x20,0x20,0x80,0x40000,0x0,0x40000,0x20,0x20,0x80,0x40000,0x20,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x2000040,0x2000040,0x2000040,0x2000040,0x20,0x20,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x80800414,0x0,0x80800414,0x1302060,0x0,0x0,0x10000,0x0,0x0,0x1000000,0x1000000,0x0,0x0,0x0,0x10000,0x0,0x0,0x1000020,0x0,0x0,0x0,0x0,0x1,0x10001000,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x302040,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x820000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000414,0x4,0x0,0x0,0x0,0x0,0x80000,0x80000,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x14,0x0,0x0,0x0,0x0,0x0,0x0,0x14,0x0,0x0,0x14,0x14,0x0,0x14,0x0,0x14,0x0,0x0,0x80000000,0x0,0x0,0x2000008,0x2000008,0x0,0x400,0x80000000,0x400,0x0,0x80000000,0x8000,0x4000,0x80000000,0x0,0x80000000,0x8000,0x4000,0x400,0x0,0x0,0x14,0x14,0x0,0x0,0x0,0x14,0x0,0x0,0x0,0x48400100,0x40400000,0x8000100,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x40400000,0x80000000,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x4,0x0,0x2,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x1c880049,0x0,0x1c880049,0xa2020010,0x0,0x100,0x0,0x0,0x0,0x20000000,0x20000000,0x0,0x0,0x100,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x80000000,0x0,0x400020,0x0,0x20000,0x0,0x2020000,0x0,0x0,0xc000,0x0,0x0,0x0,0x0,0x80000010,0x0,0x0,0x200000,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x200,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x14000041,0x10000000,0x400,0x0,0x40,0x40,0x2,0x42,0x40,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x40,0x40,0x0,0x0,0x10000040,0x0,0x0,0x0,0x0,0x0,0x0,0x10000040,0x0,0x0,0x10000040,0x10000040,0x0,0x10000040,0x0,0x10000040,0x0,0x0,0x1,0x800,0x4,0x0,0x0,0x0,0x4000000,0x1,0x0,0x0,0x1,0x0,0x0,0x1,0x0,0x1,0x0,0x0,0x4000000,0x0,0x0,0x10040040,0x10040040,0x40000,0x0,0x0,0x10000040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x1,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x10000000,0x10000000,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0xb21870,0x40000000,0xb21870,0x0,0x8000000,0x0,0x0,0x200000,0x80,0x0,0x0,0x800,0x0,0x0,0x0,0x200000,0x80,0x0,0x0,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x8000000,0x0,0x10,0x80,0x0,0x0,0x80,0x8000000,0x200000,0x8000000,0x200000,0x0,0x0,0x800000,0x800000,0x0,0x0,0x8000000,0x0,0x20000000,0x80000000,0x90000000,0x90000000,0x0,0x0,0x4000000,0x200000,0x10000000,0x0,0x10000000,0x10000000,0xb20800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x4000,0x120000,0x120000,0xd8000,0xd8000,0x2000,0x0,0x120000,0x120000,0x10800000,0x10800000,0x20b20000,0xa00000,0x0,0x0,0x0,0x800000,0x8000000,0xb20000,0x8000000,0x8000000,0xb20000,0xba0000,0x8000000,0xba0000,0x200000,0xb20000,0x200,0x0,0x800,0x0,0x0,0x2,0x2,0x0,0x200000,0x800,0x0,0x400,0x800,0x0,0x0,0x800,0x400,0x800,0x0,0x0,0x0,0x0,0x0,0xba0100,0xba0100,0x100,0x0,0x0,0xba0000,0x0,0x0,0x0,0x8,0x0,0x8,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x8000000,0x200000,0x0,0x0,0x0,0x0,0x8000000,0x0,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x18df500,0x0,0x18df500,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1800000,0x1801000,0x800400,0x800500,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x1800000,0x0,0x0,0x18df500,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0x0,0x0,0x6000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18df500,0x18df500,0x10df000,0x800000,0x800000,0x400,0x0,0x18df500,0x0,0x0,0x18df500,0x18df500,0x0,0x18df500,0x0,0x18df500,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18df500,0x18df500,0x0,0x0,0x800000,0x18df500,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_5() {
      jj_la1_5 = new int[] {0x4,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x4,0x4,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x0,0x4,0x4,0x0,0x0,0x4,0x0,0x0,0x4,0x4,0x0,0x4,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x0,0x0,0x4,0x4,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[10];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public SQLPPParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public SQLPPParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new SQLPPParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 178; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 178; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public SQLPPParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new SQLPPParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 178; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 178; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public SQLPPParser(SQLPPParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 178; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(SQLPPParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 178; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[178];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 178; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 178; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 10; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
