/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class Query
implements IReturningStatement {
    private final boolean explain;
    private boolean topLevel = true;
    private Expression body;
    private List<VarIdentifier> externalVars;
    private int varCounter;

    public Query(boolean explain) {
        this.explain = explain;
    }

    public Query(boolean explain, boolean topLevel, Expression body, int varCounter) {
        this(explain, topLevel, body, varCounter, null);
    }

    public Query(boolean explain, boolean topLevel, Expression body, int varCounter, List<VarIdentifier> externalVars) {
        this.explain = explain;
        this.topLevel = topLevel;
        this.body = body;
        this.varCounter = varCounter;
        this.externalVars = externalVars;
    }

    @Override
    public Expression getBody() {
        return this.body;
    }

    @Override
    public void setBody(Expression body) {
        this.body = body;
    }

    @Override
    public int getVarCounter() {
        return this.varCounter;
    }

    @Override
    public void setVarCounter(int varCounter) {
        this.varCounter = varCounter;
    }

    @Override
    public List<Expression> getDirectlyEnclosedExpressions() {
        return Collections.singletonList(this.body);
    }

    public void setTopLevel(boolean topLevel) {
        this.topLevel = topLevel;
    }

    @Override
    public boolean isTopLevel() {
        return this.topLevel;
    }

    @Override
    public List<VarIdentifier> getExternalVars() {
        return this.externalVars;
    }

    @Override
    public void setExternalVars(List<VarIdentifier> externalVars) {
        this.externalVars = externalVars;
    }

    public boolean isExplain() {
        return this.explain;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.QUERY;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.topLevel, this.explain, this.varCounter);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Query)) {
            return false;
        }
        Query target = (Query)object;
        return this.explain == target.explain && Objects.equals(this.body, target.body) && this.topLevel == target.topLevel && this.varCounter == target.varCounter;
    }

    @Override
    public byte getCategory() {
        return 1;
    }

    public String toString() {
        return this.body.toString();
    }
}

