/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.statement.IDatasetDetailsDecl;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.util.ExpressionUtils;
import org.apache.asterix.lang.common.util.MergePolicyUtils;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.object.base.AdmObjectNode;
import org.apache.asterix.object.base.AdmStringNode;
import org.apache.asterix.object.base.IAdmNode;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class DatasetDecl
implements Statement {
    protected static final String[] WITH_OBJECT_FIELDS = new String[]{"merge-policy"};
    protected static final Set<String> WITH_OBJECT_FIELDS_SET = new HashSet<String>(Arrays.asList(WITH_OBJECT_FIELDS));
    protected final Identifier name;
    protected final Identifier dataverse;
    protected final Identifier itemTypeDataverse;
    protected final Identifier itemTypeName;
    protected final Identifier metaItemTypeDataverse;
    protected final Identifier metaItemTypeName;
    protected final Identifier nodegroupName;
    protected final DatasetConfig.DatasetType datasetType;
    protected final IDatasetDetailsDecl datasetDetailsDecl;
    protected final Map<String, String> hints;
    private final AdmObjectNode withObjectNode;
    protected final boolean ifNotExists;

    public DatasetDecl(Identifier dataverse, Identifier name, Identifier itemTypeDataverse, Identifier itemTypeName, Identifier metaItemTypeDataverse, Identifier metaItemTypeName, Identifier nodeGroupName, Map<String, String> hints, DatasetConfig.DatasetType datasetType, IDatasetDetailsDecl idd, RecordConstructor withRecord, boolean ifNotExists) throws CompilationException {
        this.dataverse = dataverse;
        this.name = name;
        this.itemTypeName = itemTypeName;
        this.itemTypeDataverse = itemTypeDataverse.getValue() == null ? dataverse : itemTypeDataverse;
        this.metaItemTypeName = metaItemTypeName;
        this.metaItemTypeDataverse = metaItemTypeDataverse == null || metaItemTypeDataverse.getValue() == null ? dataverse : metaItemTypeDataverse;
        this.nodegroupName = nodeGroupName;
        this.hints = hints;
        try {
            this.withObjectNode = withRecord == null ? null : ExpressionUtils.toNode(withRecord);
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (AlgebricksException e) {
            throw new CompilationException((Throwable)e);
        }
        this.ifNotExists = ifNotExists;
        this.datasetType = datasetType;
        this.datasetDetailsDecl = idd;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public DatasetConfig.DatasetType getDatasetType() {
        return this.datasetType;
    }

    public Identifier getName() {
        return this.name;
    }

    public Identifier getItemTypeName() {
        return this.itemTypeName;
    }

    public Identifier getItemTypeDataverse() {
        return this.itemTypeDataverse;
    }

    public String getQualifiedTypeName() {
        if (this.itemTypeDataverse == this.dataverse) {
            return this.itemTypeName.getValue();
        }
        return this.itemTypeDataverse.getValue() + "." + this.itemTypeName.getValue();
    }

    public Identifier getMetaName() {
        return this.name;
    }

    public Identifier getMetaItemTypeName() {
        return this.metaItemTypeName == null ? new Identifier() : this.metaItemTypeName;
    }

    public Identifier getMetaItemTypeDataverse() {
        return this.metaItemTypeDataverse == null ? new Identifier() : this.metaItemTypeDataverse;
    }

    public String getQualifiedMetaTypeName() {
        if (this.metaItemTypeDataverse == this.dataverse) {
            return this.metaItemTypeName.getValue();
        }
        return this.metaItemTypeDataverse.getValue() + "." + this.metaItemTypeName.getValue();
    }

    public Identifier getNodegroupName() {
        return this.nodegroupName;
    }

    public String getCompactionPolicy() throws CompilationException {
        AdmObjectNode mergePolicy = this.getMergePolicyObject();
        if (mergePolicy == null) {
            return null;
        }
        IAdmNode mergePolicyName = mergePolicy.get("name");
        if (mergePolicyName == null) {
            throw new CompilationException(1061, new Serializable[]{"merge-policy", "name"});
        }
        if (mergePolicyName.getType() != ATypeTag.STRING) {
            throw new CompilationException(1060, new Serializable[]{"merge-policy.name", ATypeTag.STRING});
        }
        return ((AdmStringNode)mergePolicyName).get();
    }

    private static AdmObjectNode validateWithObject(AdmObjectNode withObject) throws CompilationException {
        if (withObject == null) {
            return null;
        }
        for (String name : withObject.getFieldNames()) {
            if (WITH_OBJECT_FIELDS_SET.contains(name)) continue;
            throw new CompilationException(1059, new Serializable[]{name});
        }
        return withObject;
    }

    private AdmObjectNode getMergePolicyObject() throws CompilationException {
        if (this.withObjectNode == null) {
            return null;
        }
        IAdmNode mergePolicy = DatasetDecl.validateWithObject(this.withObjectNode).get("merge-policy");
        if (mergePolicy == null) {
            return null;
        }
        if (!mergePolicy.isObject()) {
            throw new CompilationException(1060, new Serializable[]{"merge-policy", ATypeTag.OBJECT});
        }
        return (AdmObjectNode)mergePolicy;
    }

    public Map<String, String> getCompactionPolicyProperties() throws CompilationException {
        AdmObjectNode mergePolicy = this.getMergePolicyObject();
        if (mergePolicy == null) {
            return null;
        }
        IAdmNode mergePolicyParameters = mergePolicy.get("parameters");
        if (mergePolicyParameters == null) {
            return null;
        }
        if (mergePolicyParameters.getType() != ATypeTag.OBJECT) {
            throw new CompilationException(1060, new Serializable[]{"merge-policy.parameters", ATypeTag.OBJECT});
        }
        return MergePolicyUtils.toProperties((AdmObjectNode)mergePolicyParameters);
    }

    public Map<String, String> getHints() {
        return this.hints;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.DATASET_DECL;
    }

    public IDatasetDetailsDecl getDatasetDetailsDecl() {
        return this.datasetDetailsDecl;
    }

    public Identifier getDataverse() {
        return this.dataverse;
    }

    @Override
    public byte getCategory() {
        return 4;
    }

    public AdmObjectNode getWithObjectNode() {
        return this.withObjectNode;
    }
}

