/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.IndexedTypeExpression;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class CreateIndexStatement
implements Statement {
    private Identifier indexName;
    private Identifier dataverseName;
    private Identifier datasetName;
    private List<Pair<List<String>, IndexedTypeExpression>> fieldExprs = new ArrayList<Pair<List<String>, IndexedTypeExpression>>();
    private List<Integer> fieldIndexIndicators = new ArrayList<Integer>();
    private DatasetConfig.IndexType indexType = DatasetConfig.IndexType.BTREE;
    private boolean enforced;
    private boolean ifNotExists;
    private int gramLength = -1;

    public void setGramLength(int gramLength) {
        this.gramLength = gramLength;
    }

    public int getGramLength() {
        return this.gramLength;
    }

    public Identifier getIndexName() {
        return this.indexName;
    }

    public void setIndexName(Identifier indexName) {
        this.indexName = indexName;
    }

    public Identifier getDataverseName() {
        return this.dataverseName;
    }

    public void setDataverseName(Identifier dataverseName) {
        this.dataverseName = dataverseName;
    }

    public Identifier getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(Identifier datasetName) {
        this.datasetName = datasetName;
    }

    public List<Pair<List<String>, IndexedTypeExpression>> getFieldExprs() {
        return this.fieldExprs;
    }

    public void addFieldExprPair(Pair<List<String>, IndexedTypeExpression> fp) {
        this.fieldExprs.add(fp);
    }

    public List<Integer> getFieldSourceIndicators() {
        return this.fieldIndexIndicators;
    }

    public void addFieldIndexIndicator(Integer index) {
        this.fieldIndexIndicators.add(index);
    }

    public DatasetConfig.IndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexType(DatasetConfig.IndexType indexType) {
        this.indexType = indexType;
    }

    public boolean isEnforced() {
        return this.enforced;
    }

    public void setEnforced(boolean isEnforced) {
        this.enforced = isEnforced;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.CREATE_INDEX;
    }

    public boolean hasMetaField() {
        if (this.fieldIndexIndicators != null) {
            for (Integer indicator : this.fieldIndexIndicators) {
                if (indicator == 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public byte getCategory() {
        return 4;
    }
}

