/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class DisconnectFeedStatement
implements Statement {
    private final Identifier dataverseName;
    private final Identifier feedName;
    private final Identifier datasetName;

    public DisconnectFeedStatement(Identifier dataverseName, Identifier feedName, Identifier datasetName) {
        this.feedName = feedName;
        this.datasetName = datasetName;
        this.dataverseName = dataverseName;
    }

    public DisconnectFeedStatement(Pair<Identifier, Identifier> feedNameComponent, Pair<Identifier, Identifier> datasetNameComponent) {
        if (feedNameComponent.first != null && datasetNameComponent.first != null && !((Identifier)feedNameComponent.first).getValue().equals(((Identifier)datasetNameComponent.first).getValue())) {
            throw new IllegalArgumentException("Dataverse for source feed and target dataset do not match");
        }
        this.dataverseName = feedNameComponent.first != null ? (Identifier)feedNameComponent.first : (datasetNameComponent.first != null ? (Identifier)datasetNameComponent.first : null);
        this.datasetName = (Identifier)datasetNameComponent.second;
        this.feedName = (Identifier)feedNameComponent.second;
    }

    public Identifier getDataverseName() {
        return this.dataverseName;
    }

    public Identifier getFeedName() {
        return this.feedName;
    }

    public Identifier getDatasetName() {
        return this.datasetName;
    }

    @Override
    public byte getKind() {
        return 27;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public String toString() {
        return "disconnect feed " + this.feedName + " from " + this.datasetName;
    }

    @Override
    public byte getCategory() {
        return 2;
    }
}

