/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.statement.IDatasetDetailsDecl;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class DatasetDecl
implements Statement {
    protected final Identifier name;
    protected final Identifier dataverse;
    protected final Identifier itemTypeDataverse;
    protected final Identifier itemTypeName;
    protected final Identifier nodegroupName;
    protected final String compactionPolicy;
    protected final Map<String, String> compactionPolicyProperties;
    protected final DatasetConfig.DatasetType datasetType;
    protected final IDatasetDetailsDecl datasetDetailsDecl;
    protected final Map<String, String> hints;
    protected final boolean ifNotExists;
    protected final Identifier metaItemTypeDataverse;
    protected final Identifier metaItemTypeName;

    public DatasetDecl(Identifier dataverse, Identifier name, Identifier itemTypeDataverse, Identifier itemTypeName, Identifier metaItemTypeDataverse, Identifier metaItemTypeName, Identifier nodeGroupName, String compactionPolicy, Map<String, String> compactionPolicyProperties, Map<String, String> hints, DatasetConfig.DatasetType datasetType, IDatasetDetailsDecl idd, boolean ifNotExists) {
        this.dataverse = dataverse;
        this.name = name;
        this.itemTypeName = itemTypeName;
        this.itemTypeDataverse = itemTypeDataverse.getValue() == null ? dataverse : itemTypeDataverse;
        this.metaItemTypeName = metaItemTypeName;
        this.metaItemTypeDataverse = metaItemTypeDataverse == null || metaItemTypeDataverse.getValue() == null ? dataverse : metaItemTypeDataverse;
        this.nodegroupName = nodeGroupName;
        this.compactionPolicy = compactionPolicy;
        this.compactionPolicyProperties = compactionPolicyProperties;
        this.hints = hints;
        this.ifNotExists = ifNotExists;
        this.datasetType = datasetType;
        this.datasetDetailsDecl = idd;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public DatasetConfig.DatasetType getDatasetType() {
        return this.datasetType;
    }

    public Identifier getName() {
        return this.name;
    }

    public Identifier getItemTypeName() {
        return this.itemTypeName;
    }

    public Identifier getItemTypeDataverse() {
        return this.itemTypeDataverse;
    }

    public String getQualifiedTypeName() {
        if (this.itemTypeDataverse == this.dataverse) {
            return this.itemTypeName.getValue();
        }
        return this.itemTypeDataverse.getValue() + "." + this.itemTypeName.getValue();
    }

    public Identifier getMetaName() {
        return this.name;
    }

    public Identifier getMetaItemTypeName() {
        return this.metaItemTypeName == null ? new Identifier() : this.metaItemTypeName;
    }

    public Identifier getMetaItemTypeDataverse() {
        return this.metaItemTypeDataverse == null ? new Identifier() : this.metaItemTypeDataverse;
    }

    public String getQualifiedMetaTypeName() {
        if (this.metaItemTypeDataverse == this.dataverse) {
            return this.metaItemTypeName.getValue();
        }
        return this.metaItemTypeDataverse.getValue() + "." + this.metaItemTypeName.getValue();
    }

    public Identifier getNodegroupName() {
        return this.nodegroupName;
    }

    public String getCompactionPolicy() {
        return this.compactionPolicy;
    }

    public Map<String, String> getCompactionPolicyProperties() {
        return this.compactionPolicyProperties;
    }

    public Map<String, String> getHints() {
        return this.hints;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public byte getKind() {
        return 0;
    }

    public IDatasetDetailsDecl getDatasetDetailsDecl() {
        return this.datasetDetailsDecl;
    }

    public Identifier getDataverse() {
        return this.dataverse;
    }

    @Override
    public byte getCategory() {
        return 4;
    }
}

