/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class CreateFunctionStatement
implements Statement {
    private final FunctionSignature signature;
    private final String functionBody;
    private final boolean ifNotExists;
    private final List<String> paramList;

    public FunctionSignature getaAterixFunction() {
        return this.signature;
    }

    public String getFunctionBody() {
        return this.functionBody;
    }

    public CreateFunctionStatement(FunctionSignature signature, List<VarIdentifier> parameterList, String functionBody, boolean ifNotExists) {
        this.signature = signature;
        this.functionBody = functionBody;
        this.ifNotExists = ifNotExists;
        this.paramList = new ArrayList<String>();
        for (VarIdentifier varId : parameterList) {
            this.paramList.add(varId.getValue());
        }
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public byte getKind() {
        return 30;
    }

    public List<String> getParamList() {
        return this.paramList;
    }

    public FunctionSignature getSignature() {
        return this.signature;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public byte getCategory() {
        return 4;
    }
}

