/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractExpression;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.commons.lang3.ObjectUtils;

public class OperatorExpr
extends AbstractExpression {
    private List<Expression> exprList;
    private List<OperatorType> opList;
    private List<Integer> exprBroadcastIdx;
    private boolean currentop = false;

    public OperatorExpr() {
        this.exprList = new ArrayList<Expression>();
        this.exprBroadcastIdx = new ArrayList<Integer>();
        this.opList = new ArrayList<OperatorType>();
    }

    public OperatorExpr(List<Expression> exprList, List<Integer> exprBroadcastIdx, List<OperatorType> opList, boolean currentop) {
        this.exprList = exprList;
        this.exprBroadcastIdx = exprBroadcastIdx;
        this.opList = opList;
        this.currentop = currentop;
    }

    public boolean isCurrentop() {
        return this.currentop;
    }

    public void setCurrentop(boolean currentop) {
        this.currentop = currentop;
    }

    public List<Expression> getExprList() {
        return this.exprList;
    }

    public List<Integer> getExprBroadcastIdx() {
        return this.exprBroadcastIdx;
    }

    public List<OperatorType> getOpList() {
        return this.opList;
    }

    public void setExprList(List<Expression> exprList) {
        this.exprList = exprList;
    }

    public void addOperand(Expression operand) {
        this.addOperand(operand, false);
    }

    public void addOperand(Expression operand, boolean broadcast) {
        if (broadcast) {
            this.exprBroadcastIdx.add(this.exprList.size());
        }
        this.exprList.add(operand);
    }

    public static final boolean opIsComparison(OperatorType t) {
        boolean cmp = t == OperatorType.EQ || t == OperatorType.NEQ || t == OperatorType.GT;
        cmp = cmp || t == OperatorType.GE || t == OperatorType.LT || t == OperatorType.LE;
        return cmp;
    }

    public void addOperator(String strOp) throws CompilationException {
        Optional<OperatorType> op = OperatorType.fromSymbol(strOp);
        if (!op.isPresent()) {
            throw new CompilationException("Unsupported operator: " + strOp);
        }
        this.opList.add(op.get());
    }

    @Override
    public Expression.Kind getKind() {
        return Expression.Kind.OP_EXPRESSION;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public boolean isBroadcastOperand(int idx) {
        for (Integer i : this.exprBroadcastIdx) {
            if (i != idx) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.currentop, this.exprBroadcastIdx, this.exprList, this.opList});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OperatorExpr)) {
            return false;
        }
        OperatorExpr target = (OperatorExpr)object;
        return this.currentop == target.isCurrentop() && ObjectUtils.equals(this.exprBroadcastIdx, target.exprBroadcastIdx) && ObjectUtils.equals(this.exprList, target.exprList) && ObjectUtils.equals(this.opList, target.opList);
    }
}

