/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.extension.grammar;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.asterix.external.input.record.CharArrayRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="grammarix")
public class GrammarExtensionMojo
extends AbstractMojo {
    private static final String PARSER_BEGIN = "PARSER_BEGIN";
    private static final String PARSER_END = "PARSER_END";
    private static final char OPEN_BRACE = '{';
    private static final char CLOSE_BRACE = '}';
    private static final char OPEN_ANGULAR = '<';
    private static final char CLOSE_ANGULAR = '>';
    private static final char OPEN_PAREN = '(';
    private static final char CLOSE_PAREN = ')';
    private static final char SEMICOLON = ';';
    private static final List<Character> SIG_SPECIAL_CHARS = Arrays.asList(Character.valueOf('('), Character.valueOf(')'), Character.valueOf(':'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(';'), Character.valueOf('.'));
    private static final String KWCLASS = "class";
    private static final String KWIMPORT = "import";
    private static final String KWUNIMPORT = "unimport";
    private static final String KWPACKAGE = "package";
    private static final String NEWPRODUCTION = "@new";
    private static final String NEW_AT_THE_END_PRODUCTION = "@new_at_the_end";
    private static final String NEW_AT_THE_END_CLASS_DEFINITION = "@new_at_the_class_def";
    private static final String MERGEPRODUCTION = "@merge";
    private static final String OVERRIDEPRODUCTION = "@override";
    private static final String BEFORE = "before:";
    private static final String AFTER = "after:";
    private static final String REPLACE = "replace";
    private static final String WITH = "with";
    private static final String OPTION_TRUE = "true";
    private static final String OPTION_FALSE = "false";
    private static final List<String> KEYWORDS = Arrays.asList("class", "import", "package", "PARSER_BEGIN", "PARSER_END");
    private static final List<String> EXTENSIONKEYWORDS = Arrays.asList("import", "unimport", "@new", "@new_at_the_end", "@new_at_the_class_def", "@override", "@merge");
    private static final String REGEX_WS_DOT_SEMICOLON = "\\s|[.]|[;]";
    private static final String REGEX_WS_PAREN = "\\s|[(]|[)]";
    private static final String OPTIONS = "options";
    private CharArrayRecord record = new CharArrayRecord();
    private Position position = new Position();
    private Map<String, Pair<String, String>> extensibles = new HashMap<String, Pair<String, String>>();
    private Map<String, String[]> mergeElements = new HashMap<String, String[]>();
    private List<Pair<String, String>> baseFinals = new ArrayList<Pair<String, String>>();
    private List<Pair<String, String>> extensionFinals = new ArrayList<Pair<String, String>>();
    private List<Pair<String, String>> extensionFinalsAtTheEnd = new ArrayList<Pair<String, String>>();
    private List<Pair<String, String>> extensionMethodsAtTheClassDef = new ArrayList<Pair<String, String>>();
    private List<List<String>> imports = new ArrayList<List<String>>();
    private String baseClassName;
    private String baseClassDef;
    private String optionsBlock;
    private boolean read = false;
    private boolean shouldReplace = false;
    private boolean shouldApplyEachBlockChange = true;
    private String oldPhrase = null;
    private String newPhrase = null;
    @Parameter(property="grammarix.base")
    private String base;
    @Parameter(property="grammarix.gbase")
    private String gbase;
    @Parameter(property="grammarix.gextension")
    private String gextension;
    @Parameter(property="grammarix.output")
    private String output;
    @Parameter(property="grammarix.packageName")
    private String packageName;
    @Parameter(property="grammarix.parserClassName")
    private String parserClassName;
    private String lastIdentifier;
    @Parameter(property="grammarix.parserClassModifier")
    private String parserClassModifier;

    public void execute() throws MojoExecutionException {
        this.base = new File(this.base).getAbsolutePath();
        this.getLog().info((CharSequence)("Base dir: " + this.base));
        this.getLog().info((CharSequence)("Grammar-base: " + this.gbase));
        this.getLog().info((CharSequence)("Grammar-extension: " + this.gextension));
        this.getLog().info((CharSequence)("Output: " + this.output));
        this.processBase();
        this.processExtension();
        this.generateOutput();
    }

    /*
     * WARNING - void declaration
     */
    private void generateOutput() throws MojoExecutionException {
        File outputFile = this.prepareOutputFile();
        try (BufferedWriter writer = Files.newBufferedWriter(outputFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            int index;
            if (this.optionsBlock != null) {
                writer.write(OPTIONS);
                writer.write(this.optionsBlock);
            }
            writer.newLine();
            writer.write(PARSER_BEGIN);
            writer.write(40);
            writer.write(this.parserClassName);
            writer.write(41);
            writer.newLine();
            writer.newLine();
            writer.write(KWPACKAGE);
            writer.write(" ");
            writer.write(this.packageName);
            writer.write(59);
            writer.newLine();
            writer.newLine();
            ArrayList<String> importList = new ArrayList<String>();
            for (List<String> importTokens : this.imports) {
                importList.add(this.importToString(importTokens));
            }
            Collections.sort(importList);
            for (String importStatement : importList) {
                writer.write(importStatement);
                writer.newLine();
            }
            writer.newLine();
            String classDef = this.baseClassDef.replaceAll(this.baseClassName, this.parserClassName);
            if (this.parserClassModifier != null && this.parserClassModifier.length() > 0) {
                classDef = classDef.replaceFirst(KWCLASS, this.parserClassModifier + " " + KWCLASS);
            }
            if (!this.extensionMethodsAtTheClassDef.isEmpty() && (index = classDef.lastIndexOf(125)) != -1) {
                void var7_13;
                String string = "";
                for (Pair<String, String> element : this.extensionMethodsAtTheClassDef) {
                    String string5 = (String)var7_13 + this.toOutput((String)element.first);
                    string5 = string5 + "\n";
                    string5 = string5 + (String)element.second;
                    string5 = string5 + "\n";
                }
                classDef = classDef.substring(0, index) + "\n" + (String)var7_13 + "\n" + classDef.substring(index);
            }
            writer.write(classDef);
            writer.newLine();
            writer.write(PARSER_END);
            writer.write(40);
            writer.write(this.parserClassName);
            writer.write(41);
            writer.newLine();
            writer.newLine();
            for (Map.Entry<String, Pair<String, String>> entry : this.extensibles.entrySet()) {
                writer.newLine();
                String signature = entry.getKey();
                if (this.mergeElements.containsKey(signature)) {
                    writer.write("// Merged Non-terminal");
                    writer.newLine();
                }
                writer.write(this.extensibleSignatureToOutput(signature));
                writer.newLine();
                if (this.mergeElements.containsKey(signature)) {
                    this.merge(writer, entry.getValue(), this.mergeElements.get(signature));
                    continue;
                }
                writer.write((String)entry.getValue().first);
                writer.newLine();
                if (entry.getValue().second == null) continue;
                writer.write((String)entry.getValue().second);
                writer.newLine();
            }
            for (Pair pair : this.extensionFinals) {
                writer.write(this.toOutput((String)pair.first));
                writer.newLine();
                writer.write((String)pair.second);
                writer.newLine();
            }
            for (Pair pair : this.baseFinals) {
                writer.write(this.toOutput((String)pair.first));
                writer.newLine();
                writer.write((String)pair.second);
                writer.newLine();
            }
            for (Pair pair : this.extensionFinalsAtTheEnd) {
                writer.write(this.toOutput((String)pair.first));
                writer.newLine();
                writer.write((String)pair.second);
                writer.newLine();
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private String extensibleSignatureToOutput(String signature) {
        StringBuilder aString = new StringBuilder();
        String[] tokens = signature.split(" ");
        aString.append(tokens[0]);
        for (int i = 1; i < tokens.length; ++i) {
            if (tokens[i - 1].charAt(tokens[i - 1].length() - 1) == ')' || !SIG_SPECIAL_CHARS.contains(Character.valueOf(tokens[i].charAt(0))) && !SIG_SPECIAL_CHARS.contains(Character.valueOf(tokens[i - 1].charAt(tokens[i - 1].length() - 1)))) {
                aString.append(" ");
            }
            aString.append(tokens[i]);
        }
        return aString.toString();
    }

    private String toOutput(String signature) {
        if (signature.indexOf(60) == 0) {
            StringBuilder aString = new StringBuilder();
            aString.append(signature.substring(0, signature.indexOf(62) + 1));
            aString.append('\n');
            aString.append(signature.substring(signature.indexOf(62) + 1));
            return aString.toString();
        }
        return signature;
    }

    private void merge(BufferedWriter writer, Pair<String, String> baseBlocks, String[] extensions) throws IOException, MojoExecutionException {
        String errorMessage = "Merged base node doesn't conform to expected mergable node structure";
        int block1Open = ((String)baseBlocks.first).indexOf(123);
        int block1Close = ((String)baseBlocks.first).lastIndexOf(125);
        writer.write(123);
        if (extensions[0] != null) {
            writer.write(extensions[0]);
        }
        writer.write(((String)baseBlocks.first).substring(block1Open + 1, block1Close));
        if (extensions[1] != null) {
            writer.write(extensions[1]);
        }
        writer.write(125);
        writer.newLine();
        writer.write(123);
        writer.newLine();
        if (extensions[2] != null) {
            writer.write(extensions[2]);
        }
        String innerBlock2String = null;
        if (baseBlocks.second != null) {
            BufferedReader blockReader = this.stringToReader((String)baseBlocks.second);
            Position blockPosition = new Position();
            blockPosition.index = 0;
            blockPosition.line = blockReader.readLine();
            while (blockPosition.line != null && (blockPosition.line.trim().length() == 0 || blockPosition.line.indexOf(123) < 0)) {
                if (blockPosition.line.trim().length() > 0) {
                    writer.write(blockPosition.line);
                    writer.newLine();
                }
                blockPosition.line = blockReader.readLine();
            }
            if (blockPosition.line == null) {
                throw new MojoExecutionException(errorMessage);
            }
            int block2Open = blockPosition.line.indexOf(123);
            blockPosition.line = blockPosition.line.substring(block2Open + 1);
            while (blockPosition.line != null && (blockPosition.line.trim().length() == 0 || blockPosition.line.indexOf(40) < 0)) {
                if (blockPosition.line.trim().length() > 0) {
                    writer.write(blockPosition.line);
                    writer.newLine();
                }
                blockPosition.line = blockReader.readLine();
            }
            if (blockPosition.line == null) {
                throw new MojoExecutionException(errorMessage);
            }
            int innerBlock1Open = blockPosition.line.indexOf(40);
            writer.write("  ");
            writer.write(40);
            blockPosition.index = innerBlock1Open;
            this.readBlock(blockReader, '(', ')', blockPosition);
            String innerBlock1String = this.record.toString();
            writer.newLine();
            writer.write("    ");
            writer.write(innerBlock1String.substring(innerBlock1String.indexOf(40) + 1, innerBlock1String.lastIndexOf(41)).trim());
            writer.newLine();
            this.record.reset();
            blockPosition.line = blockReader.readLine();
            while (blockPosition.line != null && blockPosition.line.trim().length() == 0) {
                blockPosition.line = blockReader.readLine();
            }
            int innerBlock2Open = blockPosition.line.indexOf(123);
            if (innerBlock2Open < 0) {
                throw new MojoExecutionException(errorMessage);
            }
            blockPosition.index = innerBlock2Open;
            this.readBlock(blockReader, '{', '}', blockPosition);
            innerBlock2String = this.record.toString();
            this.record.reset();
        }
        if (extensions[3] != null) {
            writer.write(extensions[3]);
        }
        writer.newLine();
        writer.write("  ");
        writer.write(41);
        writer.newLine();
        writer.write("  ");
        writer.write(123);
        if (extensions[4] != null) {
            writer.write(extensions[4]);
        }
        if (innerBlock2String != null) {
            writer.newLine();
            writer.write("  ");
            writer.write(innerBlock2String.substring(innerBlock2String.indexOf(123) + 1, innerBlock2String.lastIndexOf(125)).trim());
            writer.newLine();
        }
        if (extensions[5] != null) {
            writer.write(extensions[5]);
        }
        writer.write("  ");
        writer.write(125);
        writer.newLine();
        writer.write(125);
        writer.newLine();
    }

    private void readBlock(BufferedReader reader, char start, char end) throws IOException, MojoExecutionException {
        this.readBlock(reader, start, end, this.position);
    }

    private void readBlock(BufferedReader reader, char start, char end, Position position) throws IOException, MojoExecutionException {
        this.record.reset();
        char[] chars = position.line.toCharArray();
        if (chars[position.index] != start) {
            throw new MojoExecutionException("attempt to read a non terminal that doesn't start with a brace. @Line: " + position.line);
        }
        boolean prevCharEscape = false;
        boolean inString = false;
        boolean hasFinished = false;
        int depth = 0;
        int bufferPosn = position.index;
        int bufferLength = chars.length;
        do {
            int appendLength;
            int startPosn = bufferPosn;
            if (bufferPosn >= bufferLength) {
                bufferPosn = 0;
                startPosn = 0;
                this.record.append("\n".toCharArray());
                position.line = reader.readLine();
                chars = position.line.toCharArray();
                bufferLength = chars.length;
            }
            while (bufferPosn < bufferLength) {
                if (inString) {
                    if (chars[bufferPosn] == '\"' && !prevCharEscape) {
                        inString = false;
                    }
                    prevCharEscape = prevCharEscape ? false : chars[bufferPosn] == '\\';
                } else if (chars[bufferPosn] == '\"') {
                    inString = true;
                } else if (chars[bufferPosn] == start) {
                    ++depth;
                } else if (chars[bufferPosn] == end && --depth == 0) {
                    hasFinished = true;
                    position.index = ++bufferPosn;
                    break;
                }
                ++bufferPosn;
            }
            if ((appendLength = bufferPosn - startPosn) <= 0) continue;
            this.record.append(chars, startPosn, appendLength);
        } while (!hasFinished);
        this.record.endRecord();
    }

    private void processBase() throws MojoExecutionException {
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(this.base, this.gbase), StandardCharsets.UTF_8);){
            StringBuilder identifier = new StringBuilder();
            while ((this.position.line = reader.readLine()) != null) {
                if (this.position.line.trim().startsWith("//")) continue;
                String[] tokens = this.position.line.split(REGEX_WS_PAREN);
                this.position.index = 0;
                int openBraceIndex = this.position.line.indexOf(123);
                int openAngularIndex = this.position.line.trim().indexOf(60);
                if (tokens.length > 0 && identifier.length() == 0 && KEYWORDS.contains(tokens[0])) {
                    this.handleSpecialToken(tokens[0], reader);
                    continue;
                }
                if (openBraceIndex >= 0 && openAngularIndex < 0) {
                    String beforeBrace = this.position.line.substring(0, openBraceIndex);
                    if (beforeBrace.trim().length() > 0) {
                        identifier.append(beforeBrace);
                    } else if (identifier.length() == 0) {
                        identifier.append(this.lastIdentifier);
                    }
                    this.position.index = openBraceIndex;
                    this.readBlock(reader, '{', '}');
                    this.addExtensibleProduction(identifier);
                    continue;
                }
                if (openAngularIndex == 0) {
                    this.position.index = this.position.line.indexOf(60);
                    this.readFinalProduction(identifier, reader);
                    this.addFinalProduction(identifier, this.baseFinals);
                    continue;
                }
                if (identifier.length() <= 0 && this.position.line.trim().length() <= 0) continue;
                identifier.append(this.position.line);
                identifier.append('\n');
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void handleSpecialToken(String token, BufferedReader reader) throws IOException, MojoExecutionException {
        switch (token) {
            case "PARSER_BEGIN": {
                this.parserBegin(reader);
                break;
            }
            case "PARSER_END": {
                this.parserEnd(reader);
                break;
            }
            case "class": {
                this.handleClassDeclaration(reader);
                break;
            }
            case "package": {
                this.skipPackageDeclaration(reader);
                break;
            }
            case "import": {
                this.handleImport(reader);
                break;
            }
        }
    }

    private void addFinalProduction(StringBuilder identifier, List<Pair<String, String>> finals) {
        String sig = this.toSignature(identifier.toString());
        finals.add((Pair<String, String>)new Pair((Object)sig, (Object)this.record.toString()));
        this.record.reset();
        identifier.setLength(0);
        this.lastIdentifier = null;
    }

    private void handleImport(BufferedReader reader) throws IOException {
        ArrayList<String> importList = new ArrayList<String>();
        String[] tokens = this.position.line.split(REGEX_WS_DOT_SEMICOLON);
        importList.addAll(Arrays.asList(tokens));
        while (this.position.line.indexOf(59) < 0) {
            this.position.line = reader.readLine();
            tokens = this.position.line.split(REGEX_WS_DOT_SEMICOLON);
            importList.addAll(Arrays.asList(tokens));
        }
        this.imports.add(importList);
    }

    private void handleUnImport(BufferedReader reader) throws IOException {
        ArrayList<String> importList = new ArrayList<String>();
        String[] tokens = this.position.line.split(REGEX_WS_DOT_SEMICOLON);
        importList.addAll(Arrays.asList(tokens));
        while (this.position.line.indexOf(59) < 0) {
            this.position.line = reader.readLine();
            tokens = this.position.line.split(REGEX_WS_DOT_SEMICOLON);
            importList.addAll(Arrays.asList(tokens));
        }
        Iterator<List<String>> it = this.imports.iterator();
        while (it.hasNext()) {
            List<String> anImport = it.next();
            if (anImport.size() != importList.size()) continue;
            boolean equals = true;
            for (int i = 1; i < anImport.size(); ++i) {
                if (anImport.get(i).equals(importList.get(i))) continue;
                equals = false;
                break;
            }
            if (!equals) continue;
            it.remove();
        }
    }

    private String importToString(List<String> importTokens) {
        return "import " + StringUtils.join(importTokens.subList(1, importTokens.size()), (char)'.') + ";";
    }

    private void skipPackageDeclaration(BufferedReader reader) throws IOException {
        while (this.position.line.indexOf(59) < 0) {
            this.position.line = reader.readLine();
        }
    }

    private void handleClassDeclaration(BufferedReader reader) throws IOException, MojoExecutionException {
        StringBuilder parserDef = new StringBuilder();
        int classPosition = this.position.line.indexOf(KWCLASS);
        int startIndex = this.position.line.indexOf(123, classPosition);
        if (startIndex < 0) {
            this.position.line = this.position.line.substring(classPosition).replace(this.baseClassName, this.parserClassName);
            while (startIndex < 0) {
                parserDef.append(this.position.line);
                parserDef.append('\n');
                this.position.line = reader.readLine();
                startIndex = this.position.line.indexOf(123);
            }
            parserDef.append(this.position.line, 0, startIndex);
        } else {
            parserDef.append(this.position.line, classPosition, startIndex);
        }
        this.position.index = startIndex;
        this.readBlock(reader, '{', '}');
        String classBody = this.record.toString();
        parserDef.append(classBody);
        parserDef.append('\n');
        this.baseClassDef = parserDef.toString();
    }

    private void parserEnd(BufferedReader reader) throws IOException {
        int endIndex = this.position.line.indexOf(41, this.position.index);
        while (endIndex < 0) {
            this.position.line = reader.readLine();
            endIndex = this.position.line.indexOf(41);
        }
        this.position.index = endIndex;
    }

    private void parserBegin(BufferedReader reader) throws IOException {
        StringBuilder aStringBuilder = new StringBuilder();
        int startIndex = this.position.line.indexOf(40, this.position.index);
        while (startIndex < 0) {
            this.position.line = reader.readLine();
            startIndex = this.position.line.indexOf(40);
        }
        int endIndex = this.position.line.indexOf(41, startIndex);
        if (endIndex < 0) {
            this.position.line = this.position.line.substring(startIndex + 1);
            while (endIndex < 0) {
                aStringBuilder.append(this.position.line);
                this.position.line = reader.readLine();
                endIndex = this.position.line.indexOf(41);
            }
            aStringBuilder.append(this.position.line, 0, endIndex);
        } else {
            aStringBuilder.append(this.position.line.substring(startIndex + 1, endIndex));
        }
        this.position.index = endIndex;
        this.baseClassName = aStringBuilder.toString().trim();
    }

    private void readFinalProduction(StringBuilder identifier, BufferedReader reader) throws IOException, MojoExecutionException {
        int blockStart = this.position.line.indexOf(123);
        if (blockStart < 0) {
            this.position.line = this.position.line.substring(this.position.index);
            while (blockStart < 0) {
                identifier.append(this.position.line);
                identifier.append('\n');
                this.position.line = reader.readLine();
                blockStart = this.position.line.indexOf(123);
            }
            identifier.append(this.position.line.substring(0, blockStart));
        } else {
            identifier.append(this.position.line.substring(this.position.index, blockStart));
        }
        this.position.index = blockStart;
        this.readBlock(reader, '{', '}');
    }

    private void addExtensibleProduction(StringBuilder identifier) {
        if (identifier.toString().trim().equals(OPTIONS)) {
            this.optionsBlock = this.record.toString();
        } else {
            String sig = this.toSignature(identifier.toString());
            Pair pair = this.extensibles.get(sig);
            if (pair == null) {
                pair = new Pair((Object)this.record.toString(), null);
                this.extensibles.put(sig, (Pair<String, String>)pair);
            } else {
                pair.second = this.record.toString();
            }
            this.lastIdentifier = identifier.toString();
        }
        this.record.reset();
        identifier.setLength(0);
    }

    private void processExtension() throws MojoExecutionException {
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(this.base, this.gextension), StandardCharsets.UTF_8);){
            StringBuilder identifier = new StringBuilder();
            String nextOperation = OVERRIDEPRODUCTION;
            while (this.read || (this.position.line = reader.readLine()) != null) {
                this.read = false;
                if (this.position.line.trim().startsWith("//")) continue;
                String[] tokens = this.position.line.split(REGEX_WS_PAREN);
                this.position.index = 0;
                int openBraceIndex = this.position.line.indexOf(123);
                int openAngularIndex = this.position.line.trim().indexOf(60);
                if (tokens.length > 0 && identifier.length() == 0 && EXTENSIONKEYWORDS.contains(tokens[0])) {
                    switch (tokens[0]) {
                        case "import": {
                            this.handleImport(reader);
                            break;
                        }
                        case "unimport": {
                            this.handleUnImport(reader);
                            break;
                        }
                        case "@new": {
                            nextOperation = NEWPRODUCTION;
                            break;
                        }
                        case "@new_at_the_end": {
                            nextOperation = NEW_AT_THE_END_PRODUCTION;
                            break;
                        }
                        case "@new_at_the_class_def": {
                            nextOperation = NEW_AT_THE_END_CLASS_DEFINITION;
                            break;
                        }
                        case "@merge": {
                            nextOperation = MERGEPRODUCTION;
                            this.shouldReplace = this.shouldReplace(tokens, this.position.line);
                            break;
                        }
                        case "@override": {
                            nextOperation = OVERRIDEPRODUCTION;
                            break;
                        }
                    }
                    continue;
                }
                if (openBraceIndex >= 0 && openAngularIndex < 0) {
                    String beforeBrace = this.position.line.substring(0, openBraceIndex);
                    if (beforeBrace.trim().length() > 0) {
                        identifier.append(beforeBrace);
                    } else if (identifier.length() == 0) {
                        identifier.append(this.lastIdentifier);
                    }
                    this.position.index = openBraceIndex;
                    switch (nextOperation) {
                        case "@new": {
                            this.handleNew(identifier, reader);
                            break;
                        }
                        case "@new_at_the_class_def": {
                            this.readFinalProduction(identifier, reader);
                            this.addFinalProduction(identifier, this.extensionMethodsAtTheClassDef);
                            break;
                        }
                        case "@override": {
                            this.handleOverride(identifier, reader);
                            break;
                        }
                        case "@merge": {
                            this.handleMerge(identifier, reader);
                            break;
                        }
                        default: {
                            throw new MojoExecutionException("Malformed extention file");
                        }
                    }
                    nextOperation = NEWPRODUCTION;
                    continue;
                }
                if (openAngularIndex == 0) {
                    if (nextOperation != NEWPRODUCTION && nextOperation != NEW_AT_THE_END_PRODUCTION) {
                        throw new MojoExecutionException("Can only add new REGEX production kind");
                    }
                    this.position.index = this.position.line.indexOf(60);
                    this.readFinalProduction(identifier, reader);
                    if (nextOperation == NEWPRODUCTION) {
                        this.addFinalProduction(identifier, this.extensionFinals);
                        continue;
                    }
                    if (nextOperation != NEW_AT_THE_END_PRODUCTION) continue;
                    this.addFinalProduction(identifier, this.extensionFinalsAtTheEnd);
                    continue;
                }
                if (identifier.length() <= 0 && this.position.line.trim().length() <= 0) continue;
                identifier.append(this.position.line);
                identifier.append('\n');
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private boolean shouldReplace(String[] tokens, String currentLine) throws MojoExecutionException {
        boolean replace = false;
        String errMessage = "Allowed syntax after @merge: <REPLACE> \"oldPhrase\" <WITH> \"newPhrase\" <TRUE|FALSE>.";
        String errMessage1 = "The old phrase should be place between two quotes. (E.g., \"old\")";
        String errMessage2 = "The new phrase should be place between two quotes. (E.g., \"new\")";
        if (tokens.length >= 6) {
            if (!tokens[1].equalsIgnoreCase(REPLACE)) {
                throw new MojoExecutionException(errMessage);
            }
            boolean withFound = false;
            for (int i = 3; i < tokens.length; ++i) {
                if (!tokens[i].equalsIgnoreCase(WITH)) continue;
                withFound = true;
                break;
            }
            if (!withFound) {
                throw new MojoExecutionException(errMessage);
            }
            if (tokens[tokens.length - 1].equalsIgnoreCase(OPTION_TRUE)) {
                this.shouldApplyEachBlockChange = true;
            } else if (tokens[tokens.length - 1].equalsIgnoreCase(OPTION_FALSE)) {
                this.shouldApplyEachBlockChange = false;
            } else {
                throw new MojoExecutionException(errMessage);
            }
            int oldStart = this.findQuotePos(currentLine, 0);
            if (oldStart < 0) {
                throw new MojoExecutionException(errMessage1);
            }
            int oldEnd = this.findQuotePos(currentLine, oldStart + 1);
            if (oldEnd < 0) {
                throw new MojoExecutionException(errMessage1);
            }
            this.oldPhrase = currentLine.substring(oldStart + 1, oldEnd);
            int newStart = this.findQuotePos(currentLine, oldEnd + 1);
            if (newStart < 0) {
                throw new MojoExecutionException(errMessage2);
            }
            int newEnd = this.findQuotePos(currentLine, newStart + 1);
            if (newEnd < 0) {
                throw new MojoExecutionException(errMessage2);
            }
            this.newPhrase = currentLine.substring(newStart + 1, newEnd);
            replace = true;
        }
        return replace;
    }

    private void handleOverride(StringBuilder identifier, BufferedReader reader) throws MojoExecutionException, IOException {
        this.readBlock(reader, '{', '}');
        Pair pair = new Pair((Object)this.record.toString(), null);
        String sig = this.toSignature(identifier.toString());
        this.extensibles.put(sig, (Pair<String, String>)pair);
        this.record.reset();
        identifier.setLength(0);
        this.read = true;
        this.position.index = 0;
        this.position.line = reader.readLine();
        while (this.position.line != null && this.position.line.trim().length() == 0) {
            this.position.line = reader.readLine();
        }
        int openBraceIndex = this.position.line.indexOf(123);
        if (openBraceIndex > -1) {
            this.read = false;
            this.position.index = openBraceIndex;
            this.readBlock(reader, '{', '}');
            pair.second = this.record.toString();
            this.record.reset();
        }
    }

    private void handleNew(StringBuilder identifier, BufferedReader reader) throws MojoExecutionException, IOException {
        String sig = this.toSignature(identifier.toString());
        if (this.extensibles.containsKey(sig)) {
            throw new MojoExecutionException(identifier.toString() + " already exists in base grammar");
        }
        this.handleOverride(identifier, reader);
    }

    private void handleMerge(StringBuilder identifier, BufferedReader reader) throws MojoExecutionException, IOException {
        String sig = this.toSignature(identifier.toString());
        if (!this.extensibles.containsKey(sig)) {
            throw new MojoExecutionException(identifier.toString() + " doesn't exist in base grammar");
        }
        if (this.shouldReplace) {
            Pair<String, String> baseMethods = this.extensibles.get(sig);
            baseMethods.first = this.stringReplaceAll((String)baseMethods.first, this.oldPhrase, this.newPhrase);
            baseMethods.second = this.stringReplaceAll((String)baseMethods.second, this.oldPhrase, this.newPhrase);
            this.shouldReplace = false;
        }
        String[] amendments = new String[6];
        if (this.shouldApplyEachBlockChange) {
            this.mergeElements.put(sig, amendments);
        } else {
            this.shouldApplyEachBlockChange = true;
        }
        identifier.setLength(0);
        this.readBlock(reader, '{', '}');
        String block = this.record.toString();
        this.extractBeforeAndAfter(block, amendments, 0, 1);
        this.record.reset();
        this.position.index = 0;
        this.position.line = reader.readLine();
        while (this.position.line != null && this.position.line.trim().length() == 0) {
            this.position.line = reader.readLine();
        }
        int openBraceIndex = this.position.line.indexOf(123);
        if (openBraceIndex <= -1) {
            throw new MojoExecutionException("merge element doesn't have a second block");
        }
        this.position.index = openBraceIndex;
        this.readBlock(reader, '{', '}');
        block = this.record.toString();
        BufferedReader blockReader = this.stringToReader(block);
        String line = blockReader.readLine();
        while (line != null && line.indexOf(123) < 0) {
            line = blockReader.readLine();
        }
        if (line == null) {
            throw new MojoExecutionException("merge element doesn't have a correct second block");
        }
        line = line.substring(line.indexOf(123) + 1);
        while (line != null && line.trim().length() == 0) {
            line = blockReader.readLine();
        }
        if (line == null) {
            throw new MojoExecutionException("merge element doesn't have a correct second block");
        }
        int openParenIndex = line.indexOf(40);
        if (openParenIndex < 0) {
            throw new MojoExecutionException("second block in merge element doesn't have a correct () block");
        }
        Position blockPosition = new Position();
        blockPosition.line = line;
        blockPosition.index = openParenIndex;
        this.readBlock(blockReader, '(', ')', blockPosition);
        this.extractBeforeAndAfter(this.record.toString(), amendments, 2, 3);
        this.record.reset();
        blockPosition.index = 0;
        blockPosition.line = blockReader.readLine();
        while (blockPosition.line != null && blockPosition.line.trim().length() == 0) {
            blockPosition.line = blockReader.readLine();
        }
        openBraceIndex = blockPosition.line.indexOf(123);
        if (openBraceIndex <= -1) {
            throw new MojoExecutionException("merge element doesn't have a second block");
        }
        blockPosition.index = openBraceIndex;
        this.readBlock(blockReader, '{', '}', blockPosition);
        this.extractBeforeAndAfter(this.record.toString(), amendments, 4, 5);
        this.record.reset();
    }

    private void extractBeforeAndAfter(String block, String[] amendments, int beforeIndex, int afterIndex) {
        int before = block.indexOf(BEFORE);
        int after = block.indexOf(AFTER);
        if (before >= 0) {
            amendments[beforeIndex] = block.substring(before + BEFORE.length(), after >= 0 ? after : block.length() - 1);
            if (amendments[beforeIndex].trim().length() == 0) {
                amendments[beforeIndex] = null;
            }
        }
        if (after >= 0) {
            amendments[afterIndex] = block.substring(after + AFTER.length(), block.length() - 1);
            if (amendments[afterIndex].trim().length() == 0) {
                amendments[afterIndex] = null;
            }
        }
    }

    private BufferedReader stringToReader(String aString) {
        ByteArrayInputStream is = new ByteArrayInputStream(aString.getBytes(StandardCharsets.UTF_8));
        return new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
    }

    private File prepareOutputFile() throws MojoExecutionException {
        File outputFile = new File(this.base, this.output);
        if (outputFile.exists() && !outputFile.delete()) {
            throw new MojoExecutionException("Unable to delete file " + this.output);
        }
        try {
            outputFile.getParentFile().mkdirs();
            if (!outputFile.createNewFile()) {
                throw new MojoExecutionException("Unable to create file " + this.output);
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to create file " + this.output, (Exception)ioe);
        }
        return outputFile;
    }

    private String toSignature(String identifier) {
        StringBuilder aString = new StringBuilder();
        char[] chars = identifier.toCharArray();
        int index = 0;
        boolean first = true;
        while (index < chars.length) {
            while (Character.isWhitespace(chars[index]) && ++index != chars.length) {
            }
            if (index == chars.length) break;
            int begin = index;
            while (!(Character.isWhitespace(chars[index]) || ++index == chars.length || SIG_SPECIAL_CHARS.contains(Character.valueOf(chars[index - 1])) || index < chars.length - 1 && SIG_SPECIAL_CHARS.contains(Character.valueOf(chars[index])))) {
            }
            if (!first) {
                aString.append(' ');
            }
            aString.append(new String(chars, begin, index - begin));
            first = false;
        }
        return aString.toString();
    }

    private String stringReplaceAll(String baseStr, String oldPhrase, String newPhrase) {
        String resultStr = baseStr;
        int index = resultStr.indexOf(oldPhrase);
        while (index < resultStr.length()) {
            if (index < 0) {
                return resultStr;
            }
            String tempStr = resultStr.substring(index, index + oldPhrase.length());
            if (tempStr.equals(oldPhrase)) {
                resultStr = resultStr.substring(0, index) + newPhrase + resultStr.substring(index + oldPhrase.length());
            }
            index = resultStr.indexOf(oldPhrase, index + 1);
        }
        return resultStr;
    }

    private int findQuotePos(String baseStr, int startingIndex) {
        return baseStr.indexOf(34, startingIndex);
    }

    class Position {
        String line;
        int index;

        Position() {
        }
    }
}

