/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin.tests.dataset;

import java.io.File;
import java.util.NoSuchElementException;

public abstract class AbstractDataset {
    public static final String FILE_PART = "part-";
    public static final String FILE_PART0 = "part-00000";
    public static final String FILE_EXPECTED = "expected.txt";
    public static final String AQL = "aql";
    public static final String PATH_RAW = "raw";
    public static final String PATH_RECORDPAIRS = "recordpairs";
    public static final String PATH_RECORDS = "records";
    public static final String PATH_RECORDSBULK = "recordsbulk";
    public static final String PATH_RIDPAIRS = "ridpairs";
    public static final String PATH_SSJOININ = "ssjoin.in";
    public static final String PATH_SSJOINOUT = "ssjoin.out";
    public static final String PATH_TOKENS = "tokens";
    public static final String DIRECTORY_ID_FORMAT = "%03d";

    public void createDirecotries(String[] paths) {
        this.createDirecotries(paths, 0);
    }

    public void createDirecotries(String[] paths, int crtCopy) {
        new File(paths[0] + this.getPathDirecotry(Directory.SSJOINOUT, 0)).mkdir();
        new File(paths[0] + this.getPathDirecotry(Directory.RECORDSBULK_R, crtCopy)).mkdir();
        new File(paths[0] + this.getPathDirecotry(Directory.RECORDSBULK_S, crtCopy)).mkdir();
        new File(paths[0] + this.getPathDirecotry(Directory.RECORDS_R, crtCopy)).mkdir();
        new File(paths[0] + this.getPathDirecotry(Directory.RECORDS_S, crtCopy)).mkdir();
        new File(paths[0] + this.getPathDirecotry(Directory.TOKENS, crtCopy)).mkdir();
        new File(paths[0] + this.getPathDirecotry(Directory.TOKENS_R, crtCopy)).mkdir();
        new File(paths[0] + this.getPathDirecotry(Directory.TOKENS_R_AQL, crtCopy)).mkdir();
    }

    public abstract String getName();

    public abstract int getNoRecords();

    public abstract String getPath();

    public String getPathDirecotry(Directory directory, int crtCopy) {
        return this.getPathDirectory(this.getPath(), directory, crtCopy);
    }

    private String getPathDirectory(Directory directory, int crtCopy, boolean expected) {
        return this.getPathDirectory(this.getName() + (expected ? ".expected" : ""), directory, crtCopy);
    }

    public String getPathDirectory(String path, Directory directory, int crtCopy) {
        path = path + '/';
        switch (directory) {
            case SSJOININ: {
                path = path + PATH_SSJOININ;
                break;
            }
            case SSJOINOUT: {
                path = path + PATH_SSJOINOUT;
                break;
            }
            case RAW_R: {
                path = path + "raw." + this.getSuffix(Relation.R);
                break;
            }
            case RAW_S: {
                path = path + "raw." + this.getSuffix(Relation.S);
                break;
            }
            case RECORDSBULK_R: {
                path = path + "recordsbulk." + this.getSuffix(Relation.R);
                break;
            }
            case RECORDSBULK_S: {
                path = path + "recordsbulk." + this.getSuffix(Relation.S);
                break;
            }
            case RECORDS_R: {
                path = path + "records." + this.getSuffix(Relation.R);
                break;
            }
            case RECORDS_S: {
                path = path + "records." + this.getSuffix(Relation.S);
                break;
            }
            case TOKENS: {
                path = path + PATH_TOKENS;
                break;
            }
            case TOKENS_R: {
                path = path + "tokens." + this.getSuffix(Relation.R);
                break;
            }
            case TOKENS_R_AQL: {
                path = path + "tokens." + this.getSuffix(Relation.R) + "." + AQL;
                break;
            }
            case RIDPAIRS: {
                path = path + PATH_RIDPAIRS;
                break;
            }
            case RECORDPAIRS: {
                path = path + PATH_RECORDPAIRS;
                break;
            }
            default: {
                throw new NoSuchElementException();
            }
        }
        return path + "-" + String.format(DIRECTORY_ID_FORMAT, crtCopy);
    }

    public String getPathExpected(Directory directory) {
        return this.getPathDirectory(directory, 0, true) + '/' + FILE_EXPECTED;
    }

    public String getPathPart(Directory directory, int crtCopy) {
        return this.getPathDirecotry(directory, crtCopy) + '/' + FILE_PART;
    }

    public String getPathPart0(Directory directory) {
        return this.getPathDirectory(directory, 0, false) + '/' + FILE_PART0;
    }

    public String getPathPart0(Directory directory, boolean expected) {
        return this.getPathDirectory(directory, 0, expected) + '/' + (expected ? FILE_EXPECTED : FILE_PART0);
    }

    public abstract String getSuffix(Relation var1);

    public abstract float getThreshold();

    public static enum Relation {
        R,
        S;

    }

    public static enum Directory {
        RAW_R,
        RAW_S,
        RECORDPAIRS,
        RECORDS_R,
        RECORDS_S,
        RECORDSBULK_R,
        RECORDSBULK_S,
        RIDPAIRS,
        SSJOININ,
        SSJOINOUT,
        TOKENS,
        TOKENS_R,
        TOKENS_R_AQL;

    }
}

