/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.staticcodegen;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.utils.CodeGenHelper;
import org.apache.asterix.runtime.evaluators.staticcodegen.EvaluatorMissingCheckVisitor;
import org.apache.asterix.runtime.evaluators.staticcodegen.EvaluatorNullCheckVisitor;
import org.apache.asterix.runtime.evaluators.staticcodegen.GatherEvaluatorCreationVisitor;
import org.apache.asterix.runtime.evaluators.staticcodegen.GatherEvaluatorFactoryCreationVisitor;
import org.apache.asterix.runtime.evaluators.staticcodegen.GatherInnerClassVisitor;
import org.apache.asterix.runtime.evaluators.staticcodegen.RenameClassVisitor;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class CodeGenUtil {
    private static final String OBJECT_CLASS_NAME = "java/lang/Object";
    public static final String DESCRIPTOR_SUPER_CLASS_NAME = "org/apache/asterix/runtime/evaluators/base/AbstractScalarFunctionDynamicDescriptor";
    private static final String EVALUATOR_FACTORY = "EvaluatorFactory";
    private static final String EVALUATOR = "Evaluator";
    private static final String INNER = "Inner";

    public static List<Pair<String, String>> generateScalarFunctionDescriptorBinary(String packagePrefix, String originalFuncDescriptorClassName, String suffixForGeneratedClass, ClassLoader classLoader, ClassByteCodeAction action) throws IOException, ClassNotFoundException {
        String internalFuncDescriptorClassName = CodeGenHelper.toInternalClassName((String)originalFuncDescriptorClassName);
        if (internalFuncDescriptorClassName.equals(DESCRIPTOR_SUPER_CLASS_NAME)) {
            return Collections.emptyList();
        }
        String targetFuncDescriptorClassName = CodeGenHelper.getGeneratedInternalClassName((String)internalFuncDescriptorClassName, (String)suffixForGeneratedClass);
        ArrayList<Pair<String, String>> nameMappings = new ArrayList<Pair<String, String>>();
        Class<?> evaluatorClass = classLoader.loadClass(CodeGenHelper.toJdkStandardName((String)internalFuncDescriptorClassName));
        nameMappings.addAll(CodeGenUtil.generateScalarFunctionDescriptorBinary(packagePrefix, evaluatorClass.getSuperclass().getName(), suffixForGeneratedClass, classLoader, action));
        nameMappings.add(Pair.of((Object)internalFuncDescriptorClassName, (Object)targetFuncDescriptorClassName));
        nameMappings.add(Pair.of((Object)CodeGenHelper.toJdkStandardName((String)internalFuncDescriptorClassName), (Object)CodeGenHelper.toJdkStandardName((String)targetFuncDescriptorClassName)));
        try (InputStream internalFuncDescriptorStream = CodeGenUtil.getResourceStream(internalFuncDescriptorClassName, classLoader);){
            ClassReader reader = new ClassReader(internalFuncDescriptorStream);
            GatherEvaluatorFactoryCreationVisitor evalFactoryCreationVisitor = new GatherEvaluatorFactoryCreationVisitor(CodeGenHelper.toInternalClassName((String)packagePrefix));
            reader.accept((ClassVisitor)evalFactoryCreationVisitor, 0);
            Set<String> evaluatorFactoryClassNames = evalFactoryCreationVisitor.getCreatedEvaluatorFactoryClassNames();
            CodeGenUtil.generateNonEvalInnerClasses(reader, evaluatorFactoryClassNames, nameMappings, suffixForGeneratedClass, classLoader, action);
            int evalFactoryCounter = 0;
            for (String evaluateFactoryClassName : evaluatorFactoryClassNames) {
                CodeGenUtil.generateEvaluatorFactoryClassBinary(packagePrefix, evaluateFactoryClassName, suffixForGeneratedClass, evalFactoryCounter++, nameMappings, classLoader, action);
            }
            ClassWriter writer = new ClassWriter(reader, 0);
            RenameClassVisitor renamingVisitor = new RenameClassVisitor((ClassVisitor)writer, nameMappings);
            reader.accept((ClassVisitor)renamingVisitor, 0);
            action.runAction(targetFuncDescriptorClassName, writer.toByteArray());
            ArrayList<Pair<String, String>> arrayList = nameMappings;
            return arrayList;
        }
    }

    static String applyMapping(List<Pair<String, String>> nameMappings, String inputStr) {
        if (inputStr == null) {
            return null;
        }
        String result = inputStr;
        for (int index = nameMappings.size() - 1; index >= 0; --index) {
            Pair<String, String> entry = nameMappings.get(index);
            if (!result.contains((CharSequence)entry.getLeft())) continue;
            return result.replace((CharSequence)entry.getLeft(), (CharSequence)entry.getRight());
        }
        return result;
    }

    private static void generateEvaluatorFactoryClassBinary(String packagePrefix, String originalEvaluatorFactoryClassName, String suffixForGeneratedClass, int factoryCounter, List<Pair<String, String>> nameMappings, ClassLoader classLoader, ClassByteCodeAction action) throws IOException, ClassNotFoundException {
        String internalEvaluatorFactoryClassName = CodeGenHelper.toInternalClassName((String)originalEvaluatorFactoryClassName);
        String targetEvaluatorFactoryClassName = CodeGenHelper.generateClassName((String)internalEvaluatorFactoryClassName, (String)(EVALUATOR_FACTORY + suffixForGeneratedClass), (int)factoryCounter);
        nameMappings.add((Pair<String, String>)Pair.of((Object)internalEvaluatorFactoryClassName, (Object)targetEvaluatorFactoryClassName));
        nameMappings.add((Pair<String, String>)Pair.of((Object)CodeGenHelper.toJdkStandardName((String)internalEvaluatorFactoryClassName), (Object)CodeGenHelper.toJdkStandardName((String)targetEvaluatorFactoryClassName)));
        try (InputStream internalEvaluatorFactoryStream = CodeGenUtil.getResourceStream(internalEvaluatorFactoryClassName, classLoader);){
            ClassReader reader = new ClassReader(internalEvaluatorFactoryStream);
            GatherEvaluatorCreationVisitor evalCreationVisitor = new GatherEvaluatorCreationVisitor(CodeGenHelper.toInternalClassName((String)packagePrefix));
            reader.accept((ClassVisitor)evalCreationVisitor, 0);
            Set<String> evaluatorClassNames = evalCreationVisitor.getCreatedEvaluatorClassNames();
            CodeGenUtil.generateNonEvalInnerClasses(reader, evaluatorClassNames, nameMappings, suffixForGeneratedClass, classLoader, action);
            int evalCounter = 0;
            for (String evaluateClassName : evaluatorClassNames) {
                CodeGenUtil.generateEvaluatorClassBinary(evaluateClassName, suffixForGeneratedClass, evalCounter++, nameMappings, classLoader, action);
            }
            ClassWriter writer = new ClassWriter(reader, 0);
            RenameClassVisitor renamingVisitor = new RenameClassVisitor((ClassVisitor)writer, nameMappings);
            reader.accept((ClassVisitor)renamingVisitor, 0);
            action.runAction(targetEvaluatorFactoryClassName, writer.toByteArray());
        }
    }

    private static void generateEvaluatorClassBinary(String originalEvaluatorClassName, String suffixForGeneratedClass, int evalCounter, List<Pair<String, String>> nameMappings, ClassLoader classLoader, ClassByteCodeAction action) throws IOException, ClassNotFoundException {
        String internalEvaluatorClassName = CodeGenHelper.toInternalClassName((String)originalEvaluatorClassName);
        if (internalEvaluatorClassName.equals(OBJECT_CLASS_NAME)) {
            return;
        }
        String targetEvaluatorClassName = CodeGenHelper.generateClassName((String)internalEvaluatorClassName, (String)(EVALUATOR + suffixForGeneratedClass), (int)evalCounter);
        Class<?> evaluatorClass = classLoader.loadClass(CodeGenHelper.toJdkStandardName((String)internalEvaluatorClassName));
        CodeGenUtil.generateEvaluatorClassBinary(evaluatorClass.getSuperclass().getName(), suffixForGeneratedClass, evalCounter, nameMappings, classLoader, action);
        nameMappings.add((Pair<String, String>)Pair.of((Object)internalEvaluatorClassName, (Object)targetEvaluatorClassName));
        nameMappings.add((Pair<String, String>)Pair.of((Object)CodeGenHelper.toJdkStandardName((String)internalEvaluatorClassName), (Object)CodeGenHelper.toJdkStandardName((String)targetEvaluatorClassName)));
        try (InputStream internalEvaluatorStream = CodeGenUtil.getResourceStream(internalEvaluatorClassName, classLoader);){
            ClassReader firstPassReader = new ClassReader(internalEvaluatorStream);
            HashSet<String> excludedNames = new HashSet<String>();
            for (Pair<String, String> entry : nameMappings) {
                excludedNames.add((String)entry.getKey());
            }
            CodeGenUtil.generateNonEvalInnerClasses(firstPassReader, excludedNames, nameMappings, suffixForGeneratedClass, classLoader, action);
            ClassWriter firstPassWriter = new ClassWriter(firstPassReader, 0);
            EvaluatorMissingCheckVisitor missingHandlingVisitor = new EvaluatorMissingCheckVisitor((ClassVisitor)firstPassWriter);
            firstPassReader.accept((ClassVisitor)missingHandlingVisitor, 0);
            ClassReader secondPassReader = new ClassReader(firstPassWriter.toByteArray());
            ClassWriter secondPassWriter = new ClassWriter(secondPassReader, 3);
            RenameClassVisitor renamingVisitor = new RenameClassVisitor((ClassVisitor)secondPassWriter, nameMappings);
            EvaluatorNullCheckVisitor nullHandlingVisitor = new EvaluatorNullCheckVisitor(renamingVisitor, missingHandlingVisitor.getLastAddedLabel());
            secondPassReader.accept((ClassVisitor)nullHandlingVisitor, 0);
            action.runAction(targetEvaluatorClassName, secondPassWriter.toByteArray());
        }
    }

    private static void generateNonEvalInnerClasses(ClassReader reader, Set<String> evalClassNames, List<Pair<String, String>> nameMappings, String suffixForGeneratedClass, ClassLoader classLoader, ClassByteCodeAction action) throws IOException {
        GatherInnerClassVisitor innerClassVisitor = new GatherInnerClassVisitor();
        reader.accept((ClassVisitor)innerClassVisitor, 0);
        Set<String> innerClassNames = innerClassVisitor.getInnerClassNames();
        innerClassNames.removeAll(evalClassNames);
        int counter = 0;
        String suffix = INNER + suffixForGeneratedClass;
        for (String innerClassName : innerClassNames) {
            String targetInnerClassName = CodeGenHelper.generateClassName((String)innerClassName, (String)suffix, (int)counter++);
            nameMappings.add((Pair<String, String>)Pair.of((Object)innerClassName, (Object)targetInnerClassName));
            nameMappings.add((Pair<String, String>)Pair.of((Object)CodeGenHelper.toJdkStandardName((String)innerClassName), (Object)CodeGenHelper.toJdkStandardName((String)targetInnerClassName)));
            InputStream innerStream = CodeGenUtil.getResourceStream(innerClassName, classLoader);
            Throwable throwable = null;
            try {
                ClassReader innerClassReader = new ClassReader(innerStream);
                ClassWriter writer = new ClassWriter(innerClassReader, 0);
                RenameClassVisitor renamingVisitor = new RenameClassVisitor((ClassVisitor)writer, nameMappings);
                innerClassReader.accept((ClassVisitor)renamingVisitor, 0);
                action.runAction(targetInnerClassName, writer.toByteArray());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (innerStream == null) continue;
                if (throwable != null) {
                    try {
                        innerStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                innerStream.close();
            }
        }
    }

    private static InputStream getResourceStream(String className, ClassLoader classLoader) {
        return classLoader.getResourceAsStream(className.replace('.', '/') + ".class");
    }

    private CodeGenUtil() {
    }

    public static interface ClassByteCodeAction {
        public void runAction(String var1, byte[] var2) throws IOException;
    }
}

