/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import org.apache.asterix.common.utils.CodeGenHelper;
import org.apache.asterix.runtime.evaluators.staticcodegen.CodeGenUtil;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;

public class EvaluatorGeneratorMojo
extends AbstractMojo {
    private String baseDir;
    MavenProject project;
    String evaluatorPackagePrefix;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.baseDir = this.project.getBuild().getDirectory() + File.separator + "classes";
        URLClassLoader classLoader = null;
        try {
            URI baseURI = new File(this.baseDir).toURI();
            classLoader = new URLClassLoader(new URL[]{baseURI.toURL()}, ((Object)((Object)this)).getClass().getClassLoader());
            String superClassName = CodeGenHelper.toJdkStandardName((String)"org/apache/asterix/runtime/evaluators/base/AbstractScalarFunctionDynamicDescriptor");
            Class<?> superClass = Class.forName(superClassName, false, classLoader);
            ConfigurationBuilder config = ConfigurationBuilder.build((Object[])new Object[]{classLoader, this.evaluatorPackagePrefix});
            String genSuffix = "Gen.class";
            config.setInputsFilter(path -> path != null && !path.endsWith(genSuffix));
            Reflections reflections = new Reflections((Configuration)config);
            Set allClasses = reflections.getSubTypesOf(superClass);
            for (Class cl : allClasses) {
                this.getLog().info((CharSequence)("Generating byte code for " + cl.getName()));
                CodeGenUtil.generateScalarFunctionDescriptorBinary(this.evaluatorPackagePrefix, cl.getName(), "Gen", classLoader, (name, bytes) -> this.writeFile(name, bytes));
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoFailureException(e.toString());
        }
        finally {
            if (classLoader != null) {
                try {
                    classLoader.close();
                }
                catch (IOException e) {
                    this.getLog().error((Throwable)e);
                }
            }
        }
    }

    private void writeFile(String name, byte[] classDefinitionBinary) throws IOException {
        File targetFile = new File(this.baseDir + File.separator + name + ".class");
        targetFile.getParentFile().mkdirs();
        targetFile.createNewFile();
        try (FileOutputStream outputStream = new FileOutputStream(targetFile);){
            outputStream.write(classDefinitionBinary, 0, classDefinitionBinary.length);
        }
    }
}

