/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.staticcodegen.CodeGenUtil;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class EvaluatorGeneratorMojo
extends AbstractMojo {
    private String baseDir;
    MavenProject project;
    String evaluatorPackagePrefix;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.baseDir = this.project.getBuild().getDirectory() + File.separator + "classes";
        try {
            Reflections reflections = new Reflections(this.evaluatorPackagePrefix, new Scanner[0]);
            Set allClasses = reflections.getSubTypesOf(AbstractScalarFunctionDynamicDescriptor.class);
            for (Class cl : allClasses) {
                this.getLog().info((CharSequence)("Generating byte code for " + cl.getName()));
                CodeGenUtil.generateScalarFunctionDescriptorBinary((String)this.evaluatorPackagePrefix, (String)cl.getName(), (String)"Gen", (ClassLoader)reflections.getClass().getClassLoader(), (name, bytes) -> this.writeFile(name, bytes));
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoFailureException(e.toString());
        }
    }

    private void writeFile(String name, byte[] classDefinitionBinary) throws IOException {
        File targetFile = new File(this.baseDir + File.separator + name + ".class");
        targetFile.getParentFile().mkdirs();
        targetFile.createNewFile();
        try (FileOutputStream outputStream = new FileOutputStream(targetFile);){
            outputStream.write(classDefinitionBinary, 0, classDefinitionBinary.length);
        }
    }
}

