/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.ioopcallbacks;

import java.util.Collections;
import junit.framework.TestCase;
import org.apache.asterix.common.ioopcallbacks.AbstractLSMIOOperationCallback;
import org.apache.asterix.common.ioopcallbacks.LSMBTreeIOOperationCallback;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.test.ioopcallbacks.TestLSMIndexOperationContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentIdGenerator;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.DiskComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentIdGenerator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public abstract class AbstractLSMIOOperationCallbackTest
extends TestCase {
    @Test
    public void testNormalSequence() throws HyracksDataException {
        ILSMIndex mockIndex = (ILSMIndex)Mockito.mock(ILSMIndex.class);
        Mockito.when((Object)mockIndex.getNumberOfAllMemoryComponents()).thenReturn((Object)2);
        Mockito.when((Object)mockIndex.getCurrentMemoryComponent()).thenReturn(Mockito.mock(AbstractLSMMemoryComponent.class));
        LSMBTreeIOOperationCallback callback = new LSMBTreeIOOperationCallback(mockIndex, (ILSMComponentIdGenerator)new LSMComponentIdGenerator(), this.mockIndexCheckpointManagerProvider());
        TestLSMIndexOperationContext firstOpCtx = new TestLSMIndexOperationContext(mockIndex);
        callback.updateLastLSN(1L);
        firstOpCtx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.FLUSH);
        callback.beforeOperation((ILSMIndexOperationContext)firstOpCtx);
        TestLSMIndexOperationContext secondOpCtx = new TestLSMIndexOperationContext(mockIndex);
        callback.updateLastLSN(2L);
        secondOpCtx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.FLUSH);
        callback.beforeOperation((ILSMIndexOperationContext)secondOpCtx);
        Assert.assertEquals((long)1L, (long)callback.getComponentLSN(Collections.emptyList()));
        ILSMDiskComponent diskComponent1 = this.mockDiskComponent();
        firstOpCtx.setNewComponent(diskComponent1);
        callback.afterOperation((ILSMIndexOperationContext)firstOpCtx);
        callback.afterFinalize((ILSMIndexOperationContext)firstOpCtx);
        Assert.assertEquals((long)2L, (long)callback.getComponentLSN(Collections.emptyList()));
        ILSMDiskComponent diskComponent2 = this.mockDiskComponent();
        secondOpCtx.setNewComponent(diskComponent2);
        callback.afterOperation((ILSMIndexOperationContext)secondOpCtx);
        callback.afterFinalize((ILSMIndexOperationContext)secondOpCtx);
    }

    @Test
    public void testOverWrittenLSN() throws HyracksDataException {
        ILSMIndex mockIndex = (ILSMIndex)Mockito.mock(ILSMIndex.class);
        Mockito.when((Object)mockIndex.getNumberOfAllMemoryComponents()).thenReturn((Object)2);
        Mockito.when((Object)mockIndex.getCurrentMemoryComponent()).thenReturn(Mockito.mock(AbstractLSMMemoryComponent.class));
        LSMBTreeIOOperationCallback callback = new LSMBTreeIOOperationCallback(mockIndex, (ILSMComponentIdGenerator)new LSMComponentIdGenerator(), this.mockIndexCheckpointManagerProvider());
        TestLSMIndexOperationContext firstOpCtx = new TestLSMIndexOperationContext(mockIndex);
        callback.updateLastLSN(1L);
        firstOpCtx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.FLUSH);
        callback.beforeOperation((ILSMIndexOperationContext)firstOpCtx);
        TestLSMIndexOperationContext secondOpCtx = new TestLSMIndexOperationContext(mockIndex);
        callback.updateLastLSN(2L);
        secondOpCtx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.FLUSH);
        callback.beforeOperation((ILSMIndexOperationContext)secondOpCtx);
        callback.updateLastLSN(3L);
        Assert.assertEquals((long)1L, (long)callback.getComponentLSN(Collections.emptyList()));
        ILSMDiskComponent diskComponent1 = this.mockDiskComponent();
        firstOpCtx.setNewComponent(diskComponent1);
        callback.afterOperation((ILSMIndexOperationContext)firstOpCtx);
        callback.afterFinalize((ILSMIndexOperationContext)firstOpCtx);
        ILSMDiskComponent diskComponent2 = this.mockDiskComponent();
        secondOpCtx.setNewComponent(diskComponent2);
        Assert.assertEquals((long)2L, (long)callback.getComponentLSN(Collections.emptyList()));
        callback.afterOperation((ILSMIndexOperationContext)secondOpCtx);
        callback.afterFinalize((ILSMIndexOperationContext)secondOpCtx);
    }

    @Test
    public void testLostLSN() throws HyracksDataException {
        ILSMIndex mockIndex = (ILSMIndex)Mockito.mock(ILSMIndex.class);
        Mockito.when((Object)mockIndex.getNumberOfAllMemoryComponents()).thenReturn((Object)2);
        Mockito.when((Object)mockIndex.getCurrentMemoryComponent()).thenReturn(Mockito.mock(AbstractLSMMemoryComponent.class));
        LSMBTreeIOOperationCallback callback = new LSMBTreeIOOperationCallback(mockIndex, (ILSMComponentIdGenerator)new LSMComponentIdGenerator(), this.mockIndexCheckpointManagerProvider());
        TestLSMIndexOperationContext firstOpCtx = new TestLSMIndexOperationContext(mockIndex);
        callback.updateLastLSN(1L);
        firstOpCtx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.FLUSH);
        callback.beforeOperation((ILSMIndexOperationContext)firstOpCtx);
        TestLSMIndexOperationContext secondOpCtx = new TestLSMIndexOperationContext(mockIndex);
        callback.updateLastLSN(2L);
        secondOpCtx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.FLUSH);
        callback.beforeOperation((ILSMIndexOperationContext)secondOpCtx);
        Assert.assertEquals((long)1L, (long)callback.getComponentLSN(Collections.emptyList()));
        firstOpCtx.setNewComponent(this.mockDiskComponent());
        callback.afterOperation((ILSMIndexOperationContext)firstOpCtx);
        callback.updateLastLSN(3L);
        callback.afterFinalize((ILSMIndexOperationContext)firstOpCtx);
        Assert.assertEquals((long)2L, (long)callback.getComponentLSN(Collections.emptyList()));
        secondOpCtx.setNewComponent(this.mockDiskComponent());
        callback.afterOperation((ILSMIndexOperationContext)secondOpCtx);
        callback.afterFinalize((ILSMIndexOperationContext)secondOpCtx);
        Assert.assertEquals((long)3L, (long)callback.getComponentLSN(Collections.emptyList()));
    }

    @Test
    public void testAllocateComponentId() throws HyracksDataException {
        LSMComponentIdGenerator idGenerator = new LSMComponentIdGenerator();
        ILSMIndex mockIndex = (ILSMIndex)Mockito.mock(ILSMIndex.class);
        Mockito.when((Object)mockIndex.getNumberOfAllMemoryComponents()).thenReturn((Object)2);
        ILSMMemoryComponent mockComponent = (ILSMMemoryComponent)Mockito.mock(AbstractLSMMemoryComponent.class);
        Mockito.when((Object)mockIndex.getCurrentMemoryComponent()).thenReturn((Object)mockComponent);
        LSMBTreeIOOperationCallback callback = new LSMBTreeIOOperationCallback(mockIndex, (ILSMComponentIdGenerator)idGenerator, this.mockIndexCheckpointManagerProvider());
        ILSMComponentId initialId = idGenerator.getId();
        idGenerator.refresh();
        callback.updateLastLSN(0L);
        callback.allocated(mockComponent);
        this.checkMemoryComponent(initialId, mockComponent);
    }

    @Test
    public void testRecycleComponentId() throws HyracksDataException {
        LSMComponentIdGenerator idGenerator = new LSMComponentIdGenerator();
        ILSMIndex mockIndex = (ILSMIndex)Mockito.mock(ILSMIndex.class);
        Mockito.when((Object)mockIndex.getNumberOfAllMemoryComponents()).thenReturn((Object)2);
        ILSMMemoryComponent mockComponent = (ILSMMemoryComponent)Mockito.mock(AbstractLSMMemoryComponent.class);
        Mockito.when((Object)mockIndex.getCurrentMemoryComponent()).thenReturn((Object)mockComponent);
        LSMBTreeIOOperationCallback callback = new LSMBTreeIOOperationCallback(mockIndex, (ILSMComponentIdGenerator)idGenerator, this.mockIndexCheckpointManagerProvider());
        ILSMComponentId id = idGenerator.getId();
        callback.allocated(mockComponent);
        this.checkMemoryComponent(id, mockComponent);
        Mockito.when((Object)mockIndex.isMemoryComponentsAllocated()).thenReturn((Object)true);
        for (int i = 0; i < 100; ++i) {
            idGenerator.refresh();
            ILSMComponentId expectedId = idGenerator.getId();
            callback.updateLastLSN(0L);
            TestLSMIndexOperationContext opCtx = new TestLSMIndexOperationContext(mockIndex);
            opCtx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.FLUSH);
            callback.beforeOperation((ILSMIndexOperationContext)opCtx);
            callback.recycled(mockComponent, true);
            opCtx.setNewComponent(this.mockDiskComponent());
            callback.afterOperation((ILSMIndexOperationContext)opCtx);
            callback.afterFinalize((ILSMIndexOperationContext)opCtx);
            this.checkMemoryComponent(expectedId, mockComponent);
        }
    }

    @Test
    public void testRecycleWithoutSwitch() throws HyracksDataException {
        LSMComponentIdGenerator idGenerator = new LSMComponentIdGenerator();
        ILSMIndex mockIndex = (ILSMIndex)Mockito.mock(ILSMIndex.class);
        Mockito.when((Object)mockIndex.getNumberOfAllMemoryComponents()).thenReturn((Object)2);
        ILSMMemoryComponent mockComponent = (ILSMMemoryComponent)Mockito.mock(AbstractLSMMemoryComponent.class);
        Mockito.when((Object)mockIndex.getCurrentMemoryComponent()).thenReturn((Object)mockComponent);
        LSMBTreeIOOperationCallback callback = new LSMBTreeIOOperationCallback(mockIndex, (ILSMComponentIdGenerator)idGenerator, this.mockIndexCheckpointManagerProvider());
        ILSMComponentId id = idGenerator.getId();
        callback.allocated(mockComponent);
        this.checkMemoryComponent(id, mockComponent);
        Mockito.when((Object)mockIndex.isMemoryComponentsAllocated()).thenReturn((Object)true);
        for (int i = 0; i < 10; ++i) {
            idGenerator.refresh();
            id = idGenerator.getId();
            callback.updateLastLSN(0L);
            TestLSMIndexOperationContext opCtx = new TestLSMIndexOperationContext(mockIndex);
            opCtx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.FLUSH);
            callback.recycled(mockComponent, false);
            callback.afterFinalize((ILSMIndexOperationContext)opCtx);
            this.checkMemoryComponent(id, mockComponent);
        }
    }

    @Test
    public void testConcurrentRecycleComponentId() throws HyracksDataException {
        LSMComponentIdGenerator idGenerator = new LSMComponentIdGenerator();
        ILSMIndex mockIndex = (ILSMIndex)Mockito.mock(ILSMIndex.class);
        ILSMMemoryComponent mockComponent = (ILSMMemoryComponent)Mockito.mock(AbstractLSMMemoryComponent.class);
        Mockito.when((Object)mockIndex.getCurrentMemoryComponent()).thenReturn((Object)mockComponent);
        Mockito.when((Object)mockIndex.getNumberOfAllMemoryComponents()).thenReturn((Object)2);
        LSMBTreeIOOperationCallback callback = new LSMBTreeIOOperationCallback(mockIndex, (ILSMComponentIdGenerator)idGenerator, this.mockIndexCheckpointManagerProvider());
        ILSMComponentId id = idGenerator.getId();
        callback.allocated(mockComponent);
        this.checkMemoryComponent(id, mockComponent);
        Mockito.when((Object)mockIndex.isMemoryComponentsAllocated()).thenReturn((Object)true);
        idGenerator.refresh();
        ILSMComponentId expectedId = idGenerator.getId();
        callback.updateLastLSN(0L);
        TestLSMIndexOperationContext firstOpCtx = new TestLSMIndexOperationContext(mockIndex);
        firstOpCtx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.FLUSH);
        callback.beforeOperation((ILSMIndexOperationContext)firstOpCtx);
        firstOpCtx.setNewComponent(this.mockDiskComponent());
        callback.afterOperation((ILSMIndexOperationContext)firstOpCtx);
        callback.afterFinalize((ILSMIndexOperationContext)firstOpCtx);
        idGenerator.refresh();
        ILSMComponentId nextId = idGenerator.getId();
        callback.recycled(mockComponent, true);
        this.checkMemoryComponent(expectedId, mockComponent);
        callback.updateLastLSN(0L);
        TestLSMIndexOperationContext secondOpCtx = new TestLSMIndexOperationContext(mockIndex);
        secondOpCtx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.FLUSH);
        callback.beforeOperation((ILSMIndexOperationContext)secondOpCtx);
        secondOpCtx.setNewComponent(this.mockDiskComponent());
        callback.afterOperation((ILSMIndexOperationContext)secondOpCtx);
        callback.afterFinalize((ILSMIndexOperationContext)secondOpCtx);
        callback.recycled(mockComponent, true);
        this.checkMemoryComponent(nextId, mockComponent);
    }

    private void checkMemoryComponent(ILSMComponentId expected, ILSMMemoryComponent memoryComponent) throws HyracksDataException {
        ArgumentCaptor idArgument = ArgumentCaptor.forClass(ILSMComponentId.class);
        ArgumentCaptor forceArgument = ArgumentCaptor.forClass(Boolean.class);
        ((ILSMMemoryComponent)Mockito.verify((Object)memoryComponent)).resetId((ILSMComponentId)idArgument.capture(), ((Boolean)forceArgument.capture()).booleanValue());
        AbstractLSMIOOperationCallbackTest.assertEquals((Object)expected, (Object)idArgument.getValue());
        AbstractLSMIOOperationCallbackTest.assertEquals((boolean)false, (boolean)((Boolean)forceArgument.getValue()));
        Mockito.reset((Object[])new ILSMMemoryComponent[]{memoryComponent});
    }

    private ILSMDiskComponent mockDiskComponent() {
        ILSMDiskComponent component = (ILSMDiskComponent)Mockito.mock(ILSMDiskComponent.class);
        Mockito.when((Object)component.getMetadata()).thenReturn(Mockito.mock(DiskComponentMetadata.class));
        return component;
    }

    protected IIndexCheckpointManagerProvider mockIndexCheckpointManagerProvider() throws HyracksDataException {
        IIndexCheckpointManagerProvider indexCheckpointManagerProvider = (IIndexCheckpointManagerProvider)Mockito.mock(IIndexCheckpointManagerProvider.class);
        IIndexCheckpointManager indexCheckpointManager = (IIndexCheckpointManager)Mockito.mock(IIndexCheckpointManager.class);
        ((IIndexCheckpointManager)Mockito.doNothing().when((Object)indexCheckpointManager)).flushed((String)Mockito.any(), Mockito.anyLong());
        ((IIndexCheckpointManagerProvider)Mockito.doReturn((Object)indexCheckpointManager).when((Object)indexCheckpointManagerProvider)).get((ResourceReference)Mockito.any());
        return indexCheckpointManagerProvider;
    }

    protected abstract AbstractLSMIOOperationCallback getIoCallback() throws HyracksDataException;
}

