/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.context;

import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.context.DatasetMemoryManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DatasetMemoryManagerTest {
    private static final StorageProperties storageProperties = (StorageProperties)Mockito.mock(StorageProperties.class);
    private static final long GLOBAL_BUDGET = 1000L;
    private static final long METADATA_DATASET_BUDGET = 200L;
    private static final long DATASET_BUDGET = 400L;

    @Test
    public void allocate() {
        DatasetMemoryManager memoryManager = new DatasetMemoryManager(storageProperties);
        Assert.assertTrue((boolean)memoryManager.allocate(1));
        boolean thrown = false;
        try {
            memoryManager.allocate(1);
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("already allocated"));
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
        Assert.assertTrue((boolean)memoryManager.allocate(400));
        long expectedBudget = 400L;
        Assert.assertEquals((long)memoryManager.getAvailable(), (long)expectedBudget);
        Assert.assertTrue((boolean)memoryManager.allocate(401));
        Assert.assertTrue((boolean)memoryManager.reserve(401));
        memoryManager.deallocate(401);
        expectedBudget = 0L;
        Assert.assertEquals((long)memoryManager.getAvailable(), (long)expectedBudget);
        Assert.assertFalse((boolean)memoryManager.allocate(402));
    }

    @Test
    public void reserve() {
        DatasetMemoryManager memoryManager = new DatasetMemoryManager(storageProperties);
        Assert.assertTrue((boolean)memoryManager.reserve(1));
        Assert.assertTrue((boolean)memoryManager.allocate(1));
        long expectedBudget = 800L;
        Assert.assertEquals((long)memoryManager.getAvailable(), (long)expectedBudget);
        boolean thrown = false;
        Assert.assertTrue((boolean)memoryManager.reserve(2));
        try {
            memoryManager.reserve(2);
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("already reserved"));
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
        memoryManager.cancelReserved(2);
        Assert.assertEquals((long)memoryManager.getAvailable(), (long)expectedBudget);
    }

    @Test
    public void deallocate() {
        DatasetMemoryManager memoryManager = new DatasetMemoryManager(storageProperties);
        Assert.assertTrue((boolean)memoryManager.reserve(200));
        Assert.assertTrue((boolean)memoryManager.allocate(200));
        memoryManager.deallocate(200);
        long expectedBudget = 600L;
        Assert.assertEquals((long)memoryManager.getAvailable(), (long)expectedBudget);
        boolean thrown = false;
        try {
            memoryManager.deallocate(1);
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("No allocated"));
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
        memoryManager.allocate(2);
        memoryManager.deallocate(2);
        thrown = false;
        try {
            memoryManager.deallocate(2);
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("No allocated"));
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
    }

    static {
        Mockito.when((Object)storageProperties.getMemoryComponentGlobalBudget()).thenReturn((Object)1000L);
        Mockito.when((Object)storageProperties.getMemoryComponentNumPages()).thenReturn((Object)8);
        Mockito.when((Object)storageProperties.getMetadataMemoryComponentNumPages()).thenReturn((Object)4);
        Mockito.when((Object)storageProperties.getMemoryComponentPageSize()).thenReturn((Object)50);
        Mockito.when((Object)storageProperties.getMemoryComponentsNum()).thenReturn((Object)2);
    }
}

