/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.server;

import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEntryImpl;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndFeedImpl;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedOutput;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;

public class RSSFeedServlet
extends AbstractServlet {
    private static final String DEFAULT_FEED_TYPE = "default.feed.type";
    private static final String FEED_TYPE = "type";
    private static final String MIME_TYPE = "application/xml; charset=UTF-8";
    private static final String COULD_NOT_GENERATE_FEED_ERROR = "Could not generate feed";
    private static final DateFormat DATE_PARSER = new SimpleDateFormat("yyyy-MM-dd");
    private String defaultFeedType;

    public RSSFeedServlet(ConcurrentMap<String, Object> ctx, String[] paths) {
        super(ctx, paths);
        this.defaultFeedType = (String)ctx.get(DEFAULT_FEED_TYPE);
        this.defaultFeedType = this.defaultFeedType != null ? this.defaultFeedType : "atom_0.3";
    }

    protected void get(IServletRequest req, IServletResponse res) throws IOException {
        try {
            SyndFeed feed = this.getFeed(req);
            String feedType = req.getParameter((CharSequence)FEED_TYPE);
            feedType = feedType != null ? feedType : this.defaultFeedType;
            feed.setFeedType(feedType);
            HttpUtil.setContentType((IServletResponse)res, (String)MIME_TYPE);
            SyndFeedOutput output = new SyndFeedOutput();
            output.output(feed, (Writer)res.writer());
        }
        catch (FeedException | ParseException ex) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.WARN, ex.getMessage(), ex);
            String msg = COULD_NOT_GENERATE_FEED_ERROR;
            res.writer().print(msg);
            res.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    protected SyndFeed getFeed(IServletRequest req) throws IOException, FeedException, ParseException {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle("Sample Feed (created with ROME)");
        feed.setLink("http://rome.dev.java.net");
        feed.setDescription("This feed has been created using ROME (Java syndication utilities");
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        SyndEntryImpl entry = new SyndEntryImpl();
        entry.setTitle("AsterixDB 0.8.7");
        entry.setLink("http://http://asterixdb.apache.org/docs/0.8.7-incubating/index.html");
        entry.setPublishedDate(DATE_PARSER.parse("2012-06-08"));
        SyndContentImpl description = new SyndContentImpl();
        description.setType("text/plain");
        description.setValue("AsterixDB 0.8.7 Release");
        entry.setDescription((SyndContent)description);
        entries.add(entry);
        entry = new SyndEntryImpl();
        entry.setTitle("Couchbase 4.1");
        entry.setLink("http://blog.couchbase.com/2015/december/introducing-couchbase-server-4.1");
        entry.setPublishedDate(DATE_PARSER.parse("2015-12-09"));
        description = new SyndContentImpl();
        description.setType("text/plain");
        description.setValue("Couchbase Server 4.1 Release. Bug fixes, minor API changes and some new features");
        entry.setDescription((SyndContent)description);
        entries.add(entry);
        entry = new SyndEntryImpl();
        entry.setTitle("ROME v0.3");
        entry.setLink("http://wiki.java.net/bin/view/Javawsxml/rome03");
        entry.setPublishedDate(DATE_PARSER.parse("2004-07-27"));
        description = new SyndContentImpl();
        description.setType("text/html");
        description.setValue("<p>Bug fixes, API changes, some new features and some Unit testing</p><p>For details check the <a href=\"https://rometools.jira.com/wiki/display/ROME/Change+Log#ChangeLog-Changesmadefromv0.3tov0.4\">Changes Log for 0.3</a></p>");
        entry.setDescription((SyndContent)description);
        entries.add(entry);
        entry = new SyndEntryImpl();
        entry.setTitle("ROME v0.4");
        entry.setLink("http://wiki.java.net/bin/view/Javawsxml/rome04");
        entry.setPublishedDate(DATE_PARSER.parse("2004-09-24"));
        description = new SyndContentImpl();
        description.setType("text/html");
        description.setValue("<p>Bug fixes, API changes, some new features, Unit testing completed</p><p>For details check the <a href=\"https://rometools.jira.com/wiki/display/ROME/Change+Log#ChangeLog-Changesmadefromv0.4tov0.5\">Changes Log for 0.4</a></p>");
        entry.setDescription((SyndContent)description);
        entries.add(entry);
        feed.setEntries(entries);
        return feed;
    }
}

