/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.memory;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.LinkedBlockingDeque;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.asterix.common.config.ActiveProperties;
import org.apache.asterix.common.memory.ConcurrentFramePool;
import org.apache.asterix.common.memory.FrameAction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ConcurrentFramePoolUnitTest
extends TestCase {
    private static final int DEFAULT_FRAME_SIZE = 32768;
    private static final int NUM_FRAMES = 2048;
    private static final long FEED_MEM_BUDGET = 0x4000000L;
    private static final int NUM_THREADS = 8;
    private static final int MAX_SIZE = 52;
    private static final double RELEASE_PROBABILITY = 0.2;
    private static volatile HyracksDataException cause = null;

    public ConcurrentFramePoolUnitTest(String testName) {
        super(testName);
    }

    public static junit.framework.Test suite() {
        return new TestSuite(ConcurrentFramePoolUnitTest.class);
    }

    @Test
    public void testMemoryManager() {
        ActiveProperties afp = (ActiveProperties)Mockito.mock(ActiveProperties.class);
        Mockito.when((Object)afp.getMemoryComponentGlobalBudget()).thenReturn((Object)0x4000000L);
        ConcurrentFramePool fmm = new ConcurrentFramePool("TestNode", afp.getMemoryComponentGlobalBudget(), 32768);
        int i = 0;
        while (fmm.get() != null) {
            ++i;
        }
        Assert.assertEquals((long)i, (long)2048L);
        Assert.assertNull((Object)((Object)cause));
    }

    @Test
    public void testConcurrentMemoryManager() {
        try {
            int i2;
            ActiveProperties afp = (ActiveProperties)Mockito.mock(ActiveProperties.class);
            Mockito.when((Object)afp.getMemoryComponentGlobalBudget()).thenReturn((Object)0x4000000L);
            ConcurrentFramePool fmm = new ConcurrentFramePool("TestNode", afp.getMemoryComponentGlobalBudget(), 32768);
            FixedSizeAllocator[] runners = new FixedSizeAllocator[8];
            Thread[] threads = new Thread[8];
            Arrays.parallelSetAll(runners, i -> new FixedSizeAllocator(fmm));
            for (i2 = 0; i2 < threads.length; ++i2) {
                threads[i2] = new Thread(runners[i2]);
            }
            for (i2 = 0; i2 < threads.length; ++i2) {
                threads[i2].start();
            }
            for (i2 = 0; i2 < threads.length; ++i2) {
                threads[i2].join();
            }
            i2 = 0;
            for (FixedSizeAllocator allocator : runners) {
                i2 += allocator.getAllocated();
            }
            Assert.assertEquals((long)2048L, (long)i2);
        }
        catch (Throwable th) {
            th.printStackTrace();
            Assert.fail((String)th.getMessage());
        }
        Assert.assertNull((Object)((Object)cause));
    }

    @Test
    public void testVarSizeMemoryManager() {
        try {
            int req;
            ActiveProperties afp = (ActiveProperties)Mockito.mock(ActiveProperties.class);
            Mockito.when((Object)afp.getMemoryComponentGlobalBudget()).thenReturn((Object)0x4000000L);
            ConcurrentFramePool fmm = new ConcurrentFramePool("TestNode", afp.getMemoryComponentGlobalBudget(), 32768);
            Random random = new Random();
            int i = 0;
            while (true) {
                if ((req = random.nextInt(52) + 1) == 1) {
                    if (fmm.get() == null) break;
                    ++i;
                    continue;
                }
                if (fmm.get(req * 32768) == null) break;
                i += req;
            }
            Assert.assertEquals((Object)(i <= 2048 ? 1 : 0), (Object)true);
            Assert.assertEquals((Object)(i + req > 2048 ? 1 : 0), (Object)true);
            Assert.assertEquals((long)(i + fmm.remaining()), (long)2048L);
        }
        catch (Throwable th) {
            th.printStackTrace();
            Assert.fail((String)th.getMessage());
        }
        Assert.assertNull((Object)((Object)cause));
    }

    @Test
    public void testConcurrentVarSizeMemoryManager() {
        try {
            int i2;
            int i3;
            ActiveProperties afp = (ActiveProperties)Mockito.mock(ActiveProperties.class);
            Mockito.when((Object)afp.getMemoryComponentGlobalBudget()).thenReturn((Object)0x4000000L);
            ConcurrentFramePool fmm = new ConcurrentFramePool("TestNode", afp.getMemoryComponentGlobalBudget(), 32768);
            VarSizeAllocator[] runners = new VarSizeAllocator[8];
            Thread[] threads = new Thread[8];
            Arrays.parallelSetAll(runners, i -> new VarSizeAllocator(fmm));
            for (i3 = 0; i3 < threads.length; ++i3) {
                threads[i3] = new Thread(runners[i3]);
            }
            for (i3 = 0; i3 < threads.length; ++i3) {
                threads[i3].start();
            }
            for (i3 = 0; i3 < threads.length; ++i3) {
                threads[i3].join();
            }
            int allocated = 0;
            for (i2 = 0; i2 < threads.length; ++i2) {
                if (runners[i2].cause() != null) {
                    runners[i2].cause().printStackTrace();
                    Assert.fail((String)runners[i2].cause().getMessage());
                }
                allocated += runners[i2].getAllocated();
            }
            Assert.assertEquals((Object)(allocated <= 2048 ? 1 : 0), (Object)true);
            for (i2 = 0; i2 < threads.length; ++i2) {
                Assert.assertEquals((Object)(allocated + runners[i2].getLastReq() > 2048 ? 1 : 0), (Object)true);
            }
            Assert.assertEquals((long)(allocated + fmm.remaining()), (long)2048L);
        }
        catch (Throwable th) {
            th.printStackTrace();
            Assert.fail((String)th.getMessage());
        }
        Assert.assertNull((Object)((Object)cause));
    }

    @Test
    public void testAcquireReleaseMemoryManager() throws HyracksDataException {
        ActiveProperties afp = (ActiveProperties)Mockito.mock(ActiveProperties.class);
        Mockito.when((Object)afp.getMemoryComponentGlobalBudget()).thenReturn((Object)0x4000000L);
        ConcurrentFramePool fmm = new ConcurrentFramePool("TestNode", afp.getMemoryComponentGlobalBudget(), 32768);
        Random random = new Random();
        ArrayDeque<ByteBuffer> stack = new ArrayDeque<ByteBuffer>();
        while (true) {
            if (random.nextDouble() < 0.2) {
                if (stack.isEmpty()) continue;
                fmm.release((ByteBuffer)stack.pop());
                continue;
            }
            ByteBuffer buffer = fmm.get();
            if (buffer == null) break;
            stack.push(buffer);
        }
        Assert.assertEquals((long)stack.size(), (long)2048L);
        Assert.assertEquals((long)fmm.remaining(), (long)0L);
        for (ByteBuffer buffer : stack) {
            fmm.release(buffer);
        }
        stack.clear();
        Assert.assertEquals((long)fmm.remaining(), (long)2048L);
        Assert.assertNull((Object)((Object)cause));
    }

    @Test
    public void testConcurrentAcquireReleaseMemoryManager() {
        try {
            int i2;
            ActiveProperties afp = (ActiveProperties)Mockito.mock(ActiveProperties.class);
            Mockito.when((Object)afp.getMemoryComponentGlobalBudget()).thenReturn((Object)0x4000000L);
            ConcurrentFramePool fmm = new ConcurrentFramePool("TestNode", afp.getMemoryComponentGlobalBudget(), 32768);
            FixedSizeGoodAllocator[] runners = new FixedSizeGoodAllocator[8];
            Thread[] threads = new Thread[8];
            Arrays.parallelSetAll(runners, i -> new FixedSizeGoodAllocator(fmm));
            for (i2 = 0; i2 < threads.length; ++i2) {
                threads[i2] = new Thread(runners[i2]);
            }
            for (i2 = 0; i2 < threads.length; ++i2) {
                threads[i2].start();
            }
            for (i2 = 0; i2 < threads.length; ++i2) {
                threads[i2].join();
            }
            i2 = 0;
            for (FixedSizeGoodAllocator allocator : runners) {
                i2 += allocator.getAllocated();
            }
            Assert.assertEquals((long)2048L, (long)i2);
        }
        catch (Throwable th) {
            th.printStackTrace();
            Assert.fail((String)th.getMessage());
        }
        Assert.assertNull((Object)((Object)cause));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAcquireReleaseVarSizeMemoryManager() {
        try {
            int req;
            ActiveProperties afp = (ActiveProperties)Mockito.mock(ActiveProperties.class);
            Mockito.when((Object)afp.getMemoryComponentGlobalBudget()).thenReturn((Object)0x4000000L);
            ConcurrentFramePool fmm = new ConcurrentFramePool("TestNode", afp.getMemoryComponentGlobalBudget(), 32768);
            Random random = new Random();
            ArrayDeque<ByteBuffer> stack = new ArrayDeque<ByteBuffer>();
            int i = 0;
            while (true) {
                ByteBuffer buffer;
                if (random.nextDouble() < 0.2) {
                    if (stack.isEmpty()) continue;
                    buffer = (ByteBuffer)stack.pop();
                    i -= buffer.capacity() / 32768;
                    fmm.release(buffer);
                    continue;
                }
                req = random.nextInt(52) + 1;
                if (req == 1) {
                    buffer = fmm.get();
                    if (buffer == null) break;
                    stack.push(buffer);
                    ++i;
                    continue;
                }
                buffer = fmm.get(req * 32768);
                if (buffer == null) break;
                stack.push(buffer);
                i += req;
            }
            Assert.assertEquals((Object)(i <= 2048 ? 1 : 0), (Object)true);
            Assert.assertEquals((Object)(i + req > 2048 ? 1 : 0), (Object)true);
            Assert.assertEquals((long)(i + fmm.remaining()), (long)2048L);
        }
        catch (Throwable th) {
            th.printStackTrace();
            Assert.fail((String)th.getMessage());
        }
        finally {
            Assert.assertNull((Object)((Object)cause));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentAcquireReleaseVarSizeMemoryManager() {
        try {
            int i2;
            ActiveProperties afp = (ActiveProperties)Mockito.mock(ActiveProperties.class);
            Mockito.when((Object)afp.getMemoryComponentGlobalBudget()).thenReturn((Object)0x4000000L);
            ConcurrentFramePool fmm = new ConcurrentFramePool("TestNode", afp.getMemoryComponentGlobalBudget(), 32768);
            VarSizeGoodAllocator[] runners = new VarSizeGoodAllocator[8];
            Thread[] threads = new Thread[8];
            Arrays.parallelSetAll(runners, i -> new VarSizeGoodAllocator(fmm));
            for (i2 = 0; i2 < threads.length; ++i2) {
                threads[i2] = new Thread(runners[i2]);
            }
            for (i2 = 0; i2 < threads.length; ++i2) {
                threads[i2].start();
            }
            for (i2 = 0; i2 < threads.length; ++i2) {
                threads[i2].join();
            }
            i2 = 0;
            for (VarSizeGoodAllocator allocator : runners) {
                if (allocator.cause() != null) {
                    allocator.cause().printStackTrace();
                    Assert.fail((String)allocator.cause().getMessage());
                }
                i2 += allocator.getAllocated();
            }
            Assert.assertEquals((long)2048L, (long)(i2 + fmm.remaining()));
        }
        catch (Throwable th) {
            th.printStackTrace();
            Assert.fail((String)th.getMessage());
        }
        finally {
            Assert.assertNull((Object)((Object)cause));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFixedSizeSubscribtion() {
        try {
            ActiveProperties afp = (ActiveProperties)Mockito.mock(ActiveProperties.class);
            Mockito.when((Object)afp.getMemoryComponentGlobalBudget()).thenReturn((Object)0x4000000L);
            ConcurrentFramePool fmm = new ConcurrentFramePool("TestNode", afp.getMemoryComponentGlobalBudget(), 32768);
            int i = 0;
            ByteBuffer buffer = ByteBuffer.allocate(32768);
            LinkedBlockingDeque<ByteBuffer> buffers = new LinkedBlockingDeque<ByteBuffer>();
            FrameAction frameAction = new FrameAction();
            frameAction.setFrame(buffer);
            while (!fmm.subscribe(frameAction)) {
                buffers.put(frameAction.retrieve());
                ++i;
            }
            Assert.assertEquals((long)i, (long)2048L);
            fmm.release((ByteBuffer)buffers.take());
            Assert.assertEquals((long)0L, (long)fmm.remaining());
        }
        catch (Throwable th) {
            th.printStackTrace();
            Assert.fail((String)th.getMessage());
        }
        finally {
            Assert.assertNull((Object)((Object)cause));
        }
    }

    @Test
    public void testLargerThanBudgetRequests() {
        HyracksDataException hde = null;
        try {
            ConcurrentFramePool fmm = new ConcurrentFramePool("TestNode", 524288L, 32768);
            fmm.get(0x100000);
        }
        catch (HyracksDataException e) {
            hde = e;
        }
        catch (Throwable th) {
            th.printStackTrace();
            Assert.fail((String)th.getMessage());
        }
        Assert.assertNotNull((Object)((Object)hde));
        Assert.assertNull((Object)((Object)cause));
    }

    @Test
    public void testLargerThanBudgetSubscribe() {
        HyracksDataException hde = null;
        try {
            ConcurrentFramePool fmm = new ConcurrentFramePool("TestNode", 524288L, 32768);
            ByteBuffer buffer = ByteBuffer.allocate(0x100000);
            FrameAction frameAction = new FrameAction();
            frameAction.setFrame(buffer);
            fmm.subscribe(frameAction);
        }
        catch (HyracksDataException e) {
            hde = e;
        }
        catch (Throwable th) {
            th.printStackTrace();
            Assert.fail((String)th.getMessage());
        }
        Assert.assertNotNull((Object)((Object)hde));
        Assert.assertNull((Object)((Object)cause));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testgetWhileSubscribersExist() {
        try {
            ActiveProperties afp = (ActiveProperties)Mockito.mock(ActiveProperties.class);
            Mockito.when((Object)afp.getMemoryComponentGlobalBudget()).thenReturn((Object)0x4000000L);
            ConcurrentFramePool fmm = new ConcurrentFramePool("TestNode", afp.getMemoryComponentGlobalBudget(), 32768);
            int i = 0;
            ByteBuffer buffer = ByteBuffer.allocate(32768);
            LinkedBlockingDeque<ByteBuffer> buffers = new LinkedBlockingDeque<ByteBuffer>();
            FrameAction frameAction = new FrameAction();
            frameAction.setFrame(buffer);
            while (!fmm.subscribe(frameAction)) {
                buffers.put(frameAction.retrieve());
                ++i;
            }
            Assert.assertEquals((long)i, (long)2048L);
            fmm.release((ByteBuffer)buffers.take());
            Assert.assertEquals((long)fmm.remaining(), (long)0L);
            buffers.put(frameAction.retrieve());
            ByteBuffer bufferTimes2 = ByteBuffer.allocate(65536);
            LinkedBlockingDeque<ByteBuffer> buffersTimes2 = new LinkedBlockingDeque<ByteBuffer>();
            FrameAction frameActionTimes2 = new FrameAction();
            frameActionTimes2.setFrame(bufferTimes2);
            Assert.assertEquals((Object)true, (Object)fmm.subscribe(frameActionTimes2));
            fmm.release((ByteBuffer)buffers.take());
            Assert.assertEquals((long)fmm.remaining(), (long)1L);
            Assert.assertEquals(null, (Object)fmm.get());
            fmm.release((ByteBuffer)buffers.take());
            Assert.assertEquals((long)fmm.remaining(), (long)0L);
            buffersTimes2.add(frameActionTimes2.retrieve());
            fmm.release(buffers);
            fmm.release(bufferTimes2);
            Assert.assertEquals((long)fmm.remaining(), (long)2048L);
        }
        catch (Throwable th) {
            th.printStackTrace();
            Assert.fail((String)th.getMessage());
        }
        finally {
            Assert.assertNull((Object)((Object)cause));
        }
    }

    private class VarSizeAllocator
    implements Runnable {
        private final ConcurrentFramePool fmm;
        private int allocated = 0;
        private int req = 0;
        private final Random random = new Random();
        private Throwable cause;

        public VarSizeAllocator(ConcurrentFramePool fmm) {
            this.fmm = fmm;
        }

        public int getAllocated() {
            return this.allocated;
        }

        public int getLastReq() {
            return this.req;
        }

        public Throwable cause() {
            return this.cause;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.req = this.random.nextInt(52) + 1;
                    if (this.req == 1) {
                        if (this.fmm.get() != null) {
                            ++this.allocated;
                            continue;
                        }
                    } else if (this.fmm.get(this.req * 32768) != null) {
                        this.allocated += this.req;
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable th) {
                this.cause = th;
            }
        }
    }

    private class VarSizeGoodAllocator
    implements Runnable {
        private final ConcurrentFramePool fmm;
        private int allocated = 0;
        private int req = 0;
        private final Random random = new Random();
        private Throwable cause;
        private final ArrayDeque<ByteBuffer> stack = new ArrayDeque();

        public VarSizeGoodAllocator(ConcurrentFramePool fmm) {
            this.fmm = fmm;
        }

        public int getAllocated() {
            return this.allocated;
        }

        public Throwable cause() {
            return this.cause;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    ByteBuffer buffer;
                    if (this.random.nextDouble() < 0.2) {
                        if (this.stack.isEmpty()) continue;
                        buffer = this.stack.pop();
                        this.allocated -= buffer.capacity() / 32768;
                        this.fmm.release(buffer);
                        continue;
                    }
                    this.req = this.random.nextInt(52) + 1;
                    if (this.req == 1) {
                        buffer = this.fmm.get();
                        if (buffer != null) {
                            this.stack.push(buffer);
                            ++this.allocated;
                            continue;
                        }
                    } else {
                        buffer = this.fmm.get(this.req * 32768);
                        if (buffer != null) {
                            this.stack.push(buffer);
                            this.allocated += this.req;
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (Throwable th) {
                this.cause = th;
            }
        }
    }

    private class FixedSizeGoodAllocator
    implements Runnable {
        private final ConcurrentFramePool fmm;
        private final ArrayDeque<ByteBuffer> stack = new ArrayDeque();
        private final Random random = new Random();

        public FixedSizeGoodAllocator(ConcurrentFramePool fmm) {
            this.fmm = fmm;
        }

        public int getAllocated() {
            return this.stack.size();
        }

        @Override
        public void run() {
            while (true) {
                if (this.random.nextDouble() < 0.2) {
                    if (this.stack.isEmpty()) continue;
                    try {
                        this.fmm.release(this.stack.pop());
                    }
                    catch (HyracksDataException e) {
                        e.printStackTrace();
                        cause = e;
                    }
                    continue;
                }
                ByteBuffer buffer = this.fmm.get();
                if (buffer == null) break;
                this.stack.push(buffer);
            }
        }
    }

    private class FixedSizeAllocator
    implements Runnable {
        private final ConcurrentFramePool fmm;
        private int allocated = 0;

        public FixedSizeAllocator(ConcurrentFramePool fmm) {
            this.fmm = fmm;
        }

        public int getAllocated() {
            return this.allocated;
        }

        @Override
        public void run() {
            while (this.fmm.get() != null) {
                ++this.allocated;
            }
        }
    }
}

