/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.ioopcallbacks;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.asterix.common.context.DatasetInfo;
import org.apache.asterix.common.ioopcallbacks.LSMIOOperationCallback;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.test.ioopcallbacks.TestFlushOperation;
import org.apache.asterix.test.ioopcallbacks.TestLSMIndexAccessor;
import org.apache.asterix.test.ioopcallbacks.TestLSMIndexOperationContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.DiskComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentIdGenerator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class LSMIOOperationCallbackTest
extends TestCase {
    private static long COMPONENT_SEQUENCE = 0L;

    private static String getComponentFileName() {
        String sequence = String.valueOf(COMPONENT_SEQUENCE++);
        return sequence + '_' + sequence;
    }

    @Test
    public void testNormalSequence() throws HyracksDataException {
        int numMemoryComponents = 2;
        ILSMIndex mockIndex = (ILSMIndex)Mockito.mock(ILSMIndex.class);
        String indexId = "mockIndexId";
        Mockito.when((Object)mockIndex.getNumberOfAllMemoryComponents()).thenReturn((Object)numMemoryComponents);
        Mockito.when((Object)mockIndex.getCurrentMemoryComponent()).thenReturn(Mockito.mock(AbstractLSMMemoryComponent.class));
        DatasetInfo dsInfo = new DatasetInfo(101, null);
        LSMComponentIdGenerator idGenerator = new LSMComponentIdGenerator(numMemoryComponents, 0L);
        LSMIOOperationCallback callback = new LSMIOOperationCallback(dsInfo, mockIndex, idGenerator.getId(), this.mockIndexCheckpointManagerProvider());
        idGenerator.refresh();
        long flushLsn = 1L;
        ILSMComponentId nextComponentId = idGenerator.getId();
        HashMap<String, Long> flushMap = new HashMap<String, Long>();
        flushMap.put("FlushLogLsn", flushLsn);
        flushMap.put("NextComponentId", (Long)nextComponentId);
        TestLSMIndexAccessor firstAccessor = new TestLSMIndexAccessor(new TestLSMIndexOperationContext(mockIndex));
        firstAccessor.getOpContext().setParameters(flushMap);
        FileReference firstTarget = new FileReference((IODeviceHandle)Mockito.mock(IODeviceHandle.class), LSMIOOperationCallbackTest.getComponentFileName());
        LSMComponentFileReferences firstFiles = new LSMComponentFileReferences(firstTarget, firstTarget, firstTarget);
        TestFlushOperation firstFlush = new TestFlushOperation(firstAccessor, firstTarget, (ILSMIOOperationCallback)callback, indexId, firstFiles, new LSMComponentId(0L, 0L));
        callback.scheduled((ILSMIOOperation)firstFlush);
        callback.beforeOperation((ILSMIOOperation)firstFlush);
        idGenerator.refresh();
        flushLsn = 2L;
        nextComponentId = idGenerator.getId();
        flushMap = new HashMap();
        flushMap.put("FlushLogLsn", flushLsn);
        flushMap.put("NextComponentId", (Long)nextComponentId);
        TestLSMIndexAccessor secondAccessor = new TestLSMIndexAccessor(new TestLSMIndexOperationContext(mockIndex));
        secondAccessor.getOpContext().setParameters(flushMap);
        FileReference secondTarget = new FileReference((IODeviceHandle)Mockito.mock(IODeviceHandle.class), LSMIOOperationCallbackTest.getComponentFileName());
        LSMComponentFileReferences secondFiles = new LSMComponentFileReferences(secondTarget, secondTarget, secondTarget);
        TestFlushOperation secondFlush = new TestFlushOperation(secondAccessor, secondTarget, (ILSMIOOperationCallback)callback, indexId, secondFiles, new LSMComponentId(1L, 1L));
        callback.scheduled((ILSMIOOperation)secondFlush);
        callback.beforeOperation((ILSMIOOperation)secondFlush);
        Map firstFlushMap = firstFlush.getAccessor().getOpContext().getParameters();
        long firstFlushLogLsn = (Long)firstFlushMap.get("FlushLogLsn");
        Assert.assertEquals((long)1L, (long)firstFlushLogLsn);
        ILSMDiskComponent diskComponent1 = this.mockDiskComponent();
        firstFlush.setNewComponent(diskComponent1);
        callback.afterOperation((ILSMIOOperation)firstFlush);
        callback.afterFinalize((ILSMIOOperation)firstFlush);
        callback.completed((ILSMIOOperation)firstFlush);
        Map secondFlushMap = secondFlush.getAccessor().getOpContext().getParameters();
        long secondFlushLogLsn = (Long)secondFlushMap.get("FlushLogLsn");
        Assert.assertEquals((long)2L, (long)secondFlushLogLsn);
        ILSMDiskComponent diskComponent2 = this.mockDiskComponent();
        secondFlush.setNewComponent(diskComponent2);
        callback.afterOperation((ILSMIOOperation)secondFlush);
        callback.afterFinalize((ILSMIOOperation)secondFlush);
        callback.completed((ILSMIOOperation)secondFlush);
    }

    @Test
    public void testAllocateComponentId() throws HyracksDataException {
        int numMemoryComponents = 2;
        DatasetInfo dsInfo = new DatasetInfo(101, null);
        LSMComponentIdGenerator idGenerator = new LSMComponentIdGenerator(numMemoryComponents, 0L);
        ILSMIndex mockIndex = (ILSMIndex)Mockito.mock(ILSMIndex.class);
        Mockito.when((Object)mockIndex.getNumberOfAllMemoryComponents()).thenReturn((Object)numMemoryComponents);
        ILSMMemoryComponent mockComponent = (ILSMMemoryComponent)Mockito.mock(AbstractLSMMemoryComponent.class);
        Mockito.when((Object)mockIndex.getCurrentMemoryComponent()).thenReturn((Object)mockComponent);
        LSMIOOperationCallback callback = new LSMIOOperationCallback(dsInfo, mockIndex, idGenerator.getId(), this.mockIndexCheckpointManagerProvider());
        ILSMComponentId initialId = idGenerator.getId();
        idGenerator.refresh();
        long flushLsn = 1L;
        ILSMComponentId nextComponentId = idGenerator.getId();
        callback.allocated(mockComponent);
        callback.recycled(mockComponent);
        this.checkMemoryComponent(initialId, mockComponent);
    }

    @Test
    public void testRecycleComponentId() throws HyracksDataException {
        int numMemoryComponents = 2;
        DatasetInfo dsInfo = new DatasetInfo(101, null);
        LSMComponentIdGenerator idGenerator = new LSMComponentIdGenerator(numMemoryComponents, 0L);
        ILSMIndex mockIndex = (ILSMIndex)Mockito.mock(ILSMIndex.class);
        Mockito.when((Object)mockIndex.getNumberOfAllMemoryComponents()).thenReturn((Object)numMemoryComponents);
        ILSMMemoryComponent mockComponent = (ILSMMemoryComponent)Mockito.mock(AbstractLSMMemoryComponent.class);
        Mockito.when((Object)mockIndex.getCurrentMemoryComponent()).thenReturn((Object)mockComponent);
        LSMIOOperationCallback callback = new LSMIOOperationCallback(dsInfo, mockIndex, idGenerator.getId(), this.mockIndexCheckpointManagerProvider());
        String indexId = "mockIndexId";
        ILSMComponentId id = idGenerator.getId();
        callback.recycled(mockComponent);
        this.checkMemoryComponent(id, mockComponent);
        Mockito.when((Object)mockIndex.isMemoryComponentsAllocated()).thenReturn((Object)true);
        for (int i = 0; i < 100; ++i) {
            idGenerator.refresh();
            ILSMComponentId expectedId = idGenerator.getId();
            long flushLsn = 0L;
            HashMap<String, Long> flushMap = new HashMap<String, Long>();
            flushMap.put("FlushLogLsn", flushLsn);
            flushMap.put("NextComponentId", (Long)expectedId);
            TestLSMIndexAccessor accessor = new TestLSMIndexAccessor(new TestLSMIndexOperationContext(mockIndex));
            accessor.getOpContext().setParameters(flushMap);
            FileReference target = new FileReference((IODeviceHandle)Mockito.mock(IODeviceHandle.class), LSMIOOperationCallbackTest.getComponentFileName());
            LSMComponentFileReferences files = new LSMComponentFileReferences(target, target, target);
            TestFlushOperation flush = new TestFlushOperation(accessor, target, (ILSMIOOperationCallback)callback, indexId, files, new LSMComponentId(0L, 0L));
            callback.scheduled((ILSMIOOperation)flush);
            callback.beforeOperation((ILSMIOOperation)flush);
            callback.recycled(mockComponent);
            flush.setNewComponent(this.mockDiskComponent());
            callback.afterOperation((ILSMIOOperation)flush);
            callback.afterFinalize((ILSMIOOperation)flush);
            callback.completed((ILSMIOOperation)flush);
            this.checkMemoryComponent(expectedId, mockComponent);
        }
    }

    private void checkMemoryComponent(ILSMComponentId expected, ILSMMemoryComponent memoryComponent) throws HyracksDataException {
        ArgumentCaptor idArgument = ArgumentCaptor.forClass(ILSMComponentId.class);
        ArgumentCaptor forceArgument = ArgumentCaptor.forClass(Boolean.class);
        ((ILSMMemoryComponent)Mockito.verify((Object)memoryComponent)).resetId((ILSMComponentId)idArgument.capture(), ((Boolean)forceArgument.capture()).booleanValue());
        LSMIOOperationCallbackTest.assertEquals((Object)expected, (Object)idArgument.getValue());
        LSMIOOperationCallbackTest.assertEquals((boolean)false, (boolean)((Boolean)forceArgument.getValue()));
        Mockito.reset((Object[])new ILSMMemoryComponent[]{memoryComponent});
    }

    private ILSMDiskComponent mockDiskComponent() {
        ILSMDiskComponent component = (ILSMDiskComponent)Mockito.mock(ILSMDiskComponent.class);
        Mockito.when((Object)component.getMetadata()).thenReturn(Mockito.mock(DiskComponentMetadata.class));
        return component;
    }

    protected IIndexCheckpointManagerProvider mockIndexCheckpointManagerProvider() throws HyracksDataException {
        IIndexCheckpointManagerProvider indexCheckpointManagerProvider = (IIndexCheckpointManagerProvider)Mockito.mock(IIndexCheckpointManagerProvider.class);
        IIndexCheckpointManager indexCheckpointManager = (IIndexCheckpointManager)Mockito.mock(IIndexCheckpointManager.class);
        ((IIndexCheckpointManager)Mockito.doNothing().when((Object)indexCheckpointManager)).flushed(Mockito.anyLong(), Mockito.anyLong(), Mockito.anyLong());
        ((IIndexCheckpointManagerProvider)Mockito.doReturn((Object)indexCheckpointManager).when((Object)indexCheckpointManagerProvider)).get((ResourceReference)Mockito.any());
        return indexCheckpointManagerProvider;
    }
}

