/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.context.CorrelatedPrefixMergePolicy;
import org.apache.asterix.common.context.DatasetInfo;
import org.apache.asterix.common.context.IndexInfo;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.LocalResource;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class CorrelatedPrefixMergePolicyTest
extends TestCase {
    private final long DEFAULT_COMPONENT_SIZE = 1L;
    private final int MAX_COMPONENT_SIZE = 3;
    private final int MAX_COMPONENT_COUNT = 3;
    private final int DATASET_ID = 1;
    private long nextResourceId = 0L;

    @Test
    public void testBasic() {
        try {
            List<ILSMComponentId> componentIDs = Arrays.asList(new LSMComponentId(5L, 5L), new LSMComponentId(4L, 4L), new LSMComponentId(3L, 3L), new LSMComponentId(2L, 2L), new LSMComponentId(1L, 1L));
            ArrayList<ILSMComponentId> resultPrimaryIDs = new ArrayList<ILSMComponentId>();
            IndexInfo primary = this.mockIndex(true, componentIDs, resultPrimaryIDs, 0);
            ArrayList<ILSMComponentId> resultSecondaryIDs = new ArrayList<ILSMComponentId>();
            IndexInfo secondary = this.mockIndex(false, componentIDs, resultSecondaryIDs, 0);
            ILSMMergePolicy policy = this.mockMergePolicy(primary, secondary);
            policy.diskComponentAdded(secondary.getIndex(), false);
            Assert.assertTrue((boolean)resultPrimaryIDs.isEmpty());
            Assert.assertTrue((boolean)resultSecondaryIDs.isEmpty());
            policy.diskComponentAdded(primary.getIndex(), false);
            Assert.assertEquals(Arrays.asList(new LSMComponentId(4L, 4L), new LSMComponentId(3L, 3L), new LSMComponentId(2L, 2L), new LSMComponentId(1L, 1L)), resultPrimaryIDs);
            Assert.assertEquals(Arrays.asList(new LSMComponentId(4L, 4L), new LSMComponentId(3L, 3L), new LSMComponentId(2L, 2L), new LSMComponentId(1L, 1L)), resultSecondaryIDs);
        }
        catch (HyracksDataException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIDIntervals() {
        try {
            List<ILSMComponentId> componentIDs = Arrays.asList(new LSMComponentId(40L, 50L), new LSMComponentId(30L, 35L), new LSMComponentId(25L, 29L), new LSMComponentId(20L, 24L), new LSMComponentId(10L, 19L));
            ArrayList<ILSMComponentId> resultPrimaryIDs = new ArrayList<ILSMComponentId>();
            IndexInfo primary = this.mockIndex(true, componentIDs, resultPrimaryIDs, 0);
            ArrayList<ILSMComponentId> resultSecondaryIDs = new ArrayList<ILSMComponentId>();
            IndexInfo secondary = this.mockIndex(false, componentIDs, resultSecondaryIDs, 0);
            ILSMMergePolicy policy = this.mockMergePolicy(primary, secondary);
            policy.diskComponentAdded(secondary.getIndex(), false);
            Assert.assertTrue((boolean)resultPrimaryIDs.isEmpty());
            Assert.assertTrue((boolean)resultSecondaryIDs.isEmpty());
            policy.diskComponentAdded(primary.getIndex(), false);
            Assert.assertEquals(Arrays.asList(new LSMComponentId(30L, 35L), new LSMComponentId(25L, 29L), new LSMComponentId(20L, 24L), new LSMComponentId(10L, 19L)), resultPrimaryIDs);
            Assert.assertEquals(Arrays.asList(new LSMComponentId(30L, 35L), new LSMComponentId(25L, 29L), new LSMComponentId(20L, 24L), new LSMComponentId(10L, 19L)), resultSecondaryIDs);
        }
        catch (HyracksDataException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSecondaryMissing() {
        try {
            List<ILSMComponentId> primaryComponentIDs = Arrays.asList(new LSMComponentId(40L, 50L), new LSMComponentId(30L, 35L), new LSMComponentId(25L, 29L), new LSMComponentId(20L, 24L), new LSMComponentId(10L, 19L));
            ArrayList<ILSMComponentId> resultPrimaryIDs = new ArrayList<ILSMComponentId>();
            IndexInfo primary = this.mockIndex(true, primaryComponentIDs, resultPrimaryIDs, 0);
            List<ILSMComponentId> secondaryComponentIDs = Arrays.asList(new LSMComponentId(30L, 35L), new LSMComponentId(25L, 29L), new LSMComponentId(20L, 24L));
            ArrayList<ILSMComponentId> resultSecondaryIDs = new ArrayList<ILSMComponentId>();
            IndexInfo secondary = this.mockIndex(false, secondaryComponentIDs, resultSecondaryIDs, 0);
            ILSMMergePolicy policy = this.mockMergePolicy(primary, secondary);
            policy.diskComponentAdded(secondary.getIndex(), false);
            Assert.assertTrue((boolean)resultPrimaryIDs.isEmpty());
            Assert.assertTrue((boolean)resultSecondaryIDs.isEmpty());
            policy.diskComponentAdded(primary.getIndex(), false);
            Assert.assertEquals(Arrays.asList(new LSMComponentId(30L, 35L), new LSMComponentId(25L, 29L), new LSMComponentId(20L, 24L), new LSMComponentId(10L, 19L)), resultPrimaryIDs);
            Assert.assertEquals(Arrays.asList(new LSMComponentId(30L, 35L), new LSMComponentId(25L, 29L), new LSMComponentId(20L, 24L)), resultSecondaryIDs);
        }
        catch (HyracksDataException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMultiPartition() {
        try {
            List<ILSMComponentId> componentIDs = Arrays.asList(new LSMComponentId(40L, 50L), new LSMComponentId(30L, 35L), new LSMComponentId(25L, 29L), new LSMComponentId(20L, 24L), new LSMComponentId(10L, 19L));
            ArrayList<ILSMComponentId> resultPrimaryIDs = new ArrayList<ILSMComponentId>();
            IndexInfo primary = this.mockIndex(true, componentIDs, resultPrimaryIDs, 0);
            ArrayList<ILSMComponentId> resultSecondaryIDs = new ArrayList<ILSMComponentId>();
            IndexInfo secondary = this.mockIndex(false, componentIDs, resultSecondaryIDs, 0);
            ArrayList resultSecondaryIDs1 = new ArrayList();
            IndexInfo secondary1 = this.mockIndex(false, componentIDs, resultSecondaryIDs, 1);
            ILSMMergePolicy policy = this.mockMergePolicy(primary, secondary, secondary1);
            policy.diskComponentAdded(secondary.getIndex(), false);
            Assert.assertTrue((boolean)resultPrimaryIDs.isEmpty());
            Assert.assertTrue((boolean)resultSecondaryIDs.isEmpty());
            policy.diskComponentAdded(primary.getIndex(), false);
            Assert.assertEquals(Arrays.asList(new LSMComponentId(30L, 35L), new LSMComponentId(25L, 29L), new LSMComponentId(20L, 24L), new LSMComponentId(10L, 19L)), resultPrimaryIDs);
            Assert.assertEquals(Arrays.asList(new LSMComponentId(30L, 35L), new LSMComponentId(25L, 29L), new LSMComponentId(20L, 24L), new LSMComponentId(10L, 19L)), resultSecondaryIDs);
            Assert.assertTrue((boolean)resultSecondaryIDs1.isEmpty());
        }
        catch (HyracksDataException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private ILSMMergePolicy mockMergePolicy(IndexInfo ... indexInfos) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("max-tolerance-component-count", String.valueOf(3));
        properties.put("max-mergable-component-size", String.valueOf(3));
        DatasetInfo dsInfo = new DatasetInfo(1, null);
        for (IndexInfo index : indexInfos) {
            dsInfo.addIndex(index.getResourceId(), index);
        }
        IDatasetLifecycleManager manager = (IDatasetLifecycleManager)Mockito.mock(IDatasetLifecycleManager.class);
        Mockito.when((Object)manager.getDatasetInfo(1)).thenReturn((Object)dsInfo);
        CorrelatedPrefixMergePolicy policy = new CorrelatedPrefixMergePolicy(manager, 1);
        policy.configure(properties);
        return policy;
    }

    private IndexInfo mockIndex(boolean isPrimary, List<ILSMComponentId> componentIDs, final List<ILSMComponentId> resultComponentIDs, int partition) throws HyracksDataException {
        ArrayList<ILSMDiskComponent> components = new ArrayList<ILSMDiskComponent>();
        for (ILSMComponentId id : componentIDs) {
            ILSMDiskComponent component = (ILSMDiskComponent)Mockito.mock(ILSMDiskComponent.class);
            Mockito.when((Object)component.getId()).thenReturn((Object)id);
            Mockito.when((Object)component.getComponentSize()).thenReturn((Object)1L);
            Mockito.when((Object)component.getState()).thenReturn((Object)ILSMComponent.ComponentState.READABLE_UNWRITABLE);
            components.add(component);
        }
        ILSMIndex index = (ILSMIndex)Mockito.mock(ILSMIndex.class);
        Mockito.when((Object)index.getDiskComponents()).thenReturn(components);
        ILSMIndexAccessor accessor = (ILSMIndexAccessor)Mockito.mock(ILSMIndexAccessor.class);
        ((ILSMIndexAccessor)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                List mergedComponents = (List)invocation.getArgumentAt(0, List.class);
                mergedComponents.forEach(component -> {
                    try {
                        resultComponentIDs.add(component.getId());
                    }
                    catch (HyracksDataException e) {
                        e.printStackTrace();
                    }
                });
                return null;
            }
        }).when((Object)accessor)).scheduleMerge(Mockito.anyListOf(ILSMDiskComponent.class));
        Mockito.when((Object)index.createAccessor((IIndexAccessParameters)Mockito.any(IIndexAccessParameters.class))).thenReturn((Object)accessor);
        Mockito.when((Object)index.isPrimaryIndex()).thenReturn((Object)isPrimary);
        if (isPrimary) {
            PrimaryIndexOperationTracker opTracker = (PrimaryIndexOperationTracker)Mockito.mock(PrimaryIndexOperationTracker.class);
            Mockito.when((Object)opTracker.getPartition()).thenReturn((Object)partition);
            Mockito.when((Object)index.getOperationTracker()).thenReturn((Object)opTracker);
        }
        LocalResource localResource = (LocalResource)Mockito.mock(LocalResource.class);
        Mockito.when((Object)localResource.getId()).thenReturn((Object)this.nextResourceId++);
        IndexInfo indexInfo = new IndexInfo(index, 1, localResource, partition);
        indexInfo.setOpen(true);
        return indexInfo;
    }
}

