/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.base;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class TestMethodTracer
extends TestWatcher {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Level level;

    public TestMethodTracer(Level level) {
        this.level = level;
    }

    public TestMethodTracer() {
        this(Level.WARN);
    }

    protected void starting(Description description) {
        LOGGER.log(this.level, "### {} START", (Object)description.getMethodName());
    }

    protected void failed(Throwable e, Description description) {
        LOGGER.log(this.level, "### {} FAILED ({})", (Object)description.getMethodName(), (Object)e.getClass().getName());
    }

    protected void succeeded(Description description) {
        LOGGER.log(this.level, "### {} SUCCEEDED", (Object)description.getMethodName());
    }
}

