/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hyracks.util.file.FileUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsterixTestHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    private AsterixTestHelper() {
    }

    public static String extToResExt(String fname, String resultExt) {
        int dot = fname.lastIndexOf(46);
        return fname.substring(0, dot + 1) + resultExt;
    }

    public static ArrayList<String> readTestListFile(String fileName, String basePath) {
        return AsterixTestHelper.readTestListFile(new File(basePath, fileName));
    }

    public static ArrayList<String> readTestListFile(File file) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            BufferedReader result = new BufferedReader(new FileReader(file));
            while ((line = result.readLine()) != null) {
                if ((line = line.replaceAll("#.*", "")).trim().length() == 0) continue;
                list.add(line);
            }
            result.close();
        }
        catch (IOException e) {
            System.err.println("ignoring " + e.getMessage());
        }
        return list;
    }

    public static void deleteRec(File path) {
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                AsterixTestHelper.deleteRec(f);
            }
        }
        path.delete();
    }

    public static void deepSelectiveCopy(File srcDir, File destDir, FileFilter filter) throws IOException {
        if (!srcDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + srcDir);
        }
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IllegalArgumentException("Exists and not a directory: " + destDir);
        }
        for (File child : srcDir.listFiles()) {
            File destChild = new File(destDir, child.getName());
            if (child.isDirectory()) {
                AsterixTestHelper.deepSelectiveCopy(child, destChild, filter);
                continue;
            }
            if (!filter.accept(child)) continue;
            FileUtil.safeCopyFile((File)child, (File)destChild);
            return;
        }
    }
}

