/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.asterix.test.server.FileTestServer;

public class OpenSocketFileTestServer
extends FileTestServer {
    private boolean closed;

    public OpenSocketFileTestServer(int port) {
        super(port);
    }

    @Override
    public void start() throws IOException {
        this.serverSocket = new ServerSocket(this.port);
        this.listenerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!OpenSocketFileTestServer.this.serverSocket.isClosed()) {
                    try {
                        Socket socket = OpenSocketFileTestServer.this.serverSocket.accept();
                        new Thread(new SocketThread(socket)).start();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.listenerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException, InterruptedException {
        ServerSocket serverSocket = this.serverSocket;
        synchronized (serverSocket) {
            this.closed = true;
            try {
                this.serverSocket.close();
                if (this.listenerThread.isAlive()) {
                    this.listenerThread.join();
                }
            }
            finally {
                this.serverSocket.notifyAll();
            }
        }
    }

    private class SocketThread
    implements Runnable {
        private Socket socket;
        private OutputStream os;

        public SocketThread(Socket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerSocket serverSocket;
            Object chunk;
            try {
                this.os = this.socket.getOutputStream();
                chunk = new byte[1024];
                for (String path : OpenSocketFileTestServer.this.paths) {
                    try (FileInputStream fin = new FileInputStream(new File(path));){
                        int read = fin.read((byte[])chunk);
                        while (read > 0) {
                            this.os.write((byte[])chunk, 0, read);
                            read = fin.read((byte[])chunk);
                        }
                    }
                }
                serverSocket = OpenSocketFileTestServer.this.serverSocket;
            }
            catch (Throwable th2) {
                try {
                    th2.printStackTrace();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    ServerSocket th2 = OpenSocketFileTestServer.this.serverSocket;
                    synchronized (th2) {
                        if (!OpenSocketFileTestServer.this.closed) {
                            try {
                                OpenSocketFileTestServer.this.serverSocket.wait();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    try {
                        this.os.close();
                    }
                    catch (Throwable th22) {
                        th22.printStackTrace();
                    }
                    try {
                        this.socket.close();
                    }
                    catch (Throwable th3) {
                        th3.printStackTrace();
                    }
                }
            }
            chunk = serverSocket;
            synchronized (serverSocket) {
                if (!OpenSocketFileTestServer.this.closed) {
                    try {
                        OpenSocketFileTestServer.this.serverSocket.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                // ** MonitorExit[chunk /* !! */ ] (shouldn't be in output)
                try {
                    this.os.close();
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
                try {
                    this.socket.close();
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
            {
                return;
            }
        }
    }
}

