/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.context.CorrelatedPrefixMergePolicy;
import org.apache.asterix.common.context.DatasetInfo;
import org.apache.asterix.common.context.IndexInfo;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMDiskComponentId;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class CorrelatedPrefixMergePolicyTest
extends TestCase {
    private final long DEFAULT_COMPONENT_SIZE = 1L;
    private final int MAX_COMPONENT_SIZE = 3;
    private final int MAX_COMPONENT_COUNT = 3;
    private final int DATASET_ID = 1;

    @Test
    public void testBasic() {
        try {
            List<ILSMDiskComponentId> componentIDs = Arrays.asList(new LSMDiskComponentId(5L, 5L), new LSMDiskComponentId(4L, 4L), new LSMDiskComponentId(3L, 3L), new LSMDiskComponentId(2L, 2L), new LSMDiskComponentId(1L, 1L));
            ArrayList<ILSMDiskComponentId> resultPrimaryIDs = new ArrayList<ILSMDiskComponentId>();
            IndexInfo primary = this.mockIndex(true, componentIDs, resultPrimaryIDs, 0);
            ArrayList<ILSMDiskComponentId> resultSecondaryIDs = new ArrayList<ILSMDiskComponentId>();
            IndexInfo secondary = this.mockIndex(false, componentIDs, resultSecondaryIDs, 0);
            ILSMMergePolicy policy = this.mockMergePolicy(primary, secondary);
            policy.diskComponentAdded(secondary.getIndex(), false);
            Assert.assertTrue((boolean)resultPrimaryIDs.isEmpty());
            Assert.assertTrue((boolean)resultSecondaryIDs.isEmpty());
            policy.diskComponentAdded(primary.getIndex(), false);
            Assert.assertEquals(Arrays.asList(new LSMDiskComponentId(4L, 4L), new LSMDiskComponentId(3L, 3L), new LSMDiskComponentId(2L, 2L), new LSMDiskComponentId(1L, 1L)), resultPrimaryIDs);
            Assert.assertEquals(Arrays.asList(new LSMDiskComponentId(4L, 4L), new LSMDiskComponentId(3L, 3L), new LSMDiskComponentId(2L, 2L), new LSMDiskComponentId(1L, 1L)), resultSecondaryIDs);
        }
        catch (HyracksDataException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIDIntervals() {
        try {
            List<ILSMDiskComponentId> componentIDs = Arrays.asList(new LSMDiskComponentId(40L, 50L), new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(25L, 29L), new LSMDiskComponentId(20L, 24L), new LSMDiskComponentId(10L, 19L));
            ArrayList<ILSMDiskComponentId> resultPrimaryIDs = new ArrayList<ILSMDiskComponentId>();
            IndexInfo primary = this.mockIndex(true, componentIDs, resultPrimaryIDs, 0);
            ArrayList<ILSMDiskComponentId> resultSecondaryIDs = new ArrayList<ILSMDiskComponentId>();
            IndexInfo secondary = this.mockIndex(false, componentIDs, resultSecondaryIDs, 0);
            ILSMMergePolicy policy = this.mockMergePolicy(primary, secondary);
            policy.diskComponentAdded(secondary.getIndex(), false);
            Assert.assertTrue((boolean)resultPrimaryIDs.isEmpty());
            Assert.assertTrue((boolean)resultSecondaryIDs.isEmpty());
            policy.diskComponentAdded(primary.getIndex(), false);
            Assert.assertEquals(Arrays.asList(new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(25L, 29L), new LSMDiskComponentId(20L, 24L), new LSMDiskComponentId(10L, 19L)), resultPrimaryIDs);
            Assert.assertEquals(Arrays.asList(new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(25L, 29L), new LSMDiskComponentId(20L, 24L), new LSMDiskComponentId(10L, 19L)), resultSecondaryIDs);
        }
        catch (HyracksDataException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSecondaryMissing() {
        try {
            List<ILSMDiskComponentId> primaryComponentIDs = Arrays.asList(new LSMDiskComponentId(40L, 50L), new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(25L, 29L), new LSMDiskComponentId(20L, 24L), new LSMDiskComponentId(10L, 19L));
            ArrayList<ILSMDiskComponentId> resultPrimaryIDs = new ArrayList<ILSMDiskComponentId>();
            IndexInfo primary = this.mockIndex(true, primaryComponentIDs, resultPrimaryIDs, 0);
            List<ILSMDiskComponentId> secondaryComponentIDs = Arrays.asList(new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(25L, 29L), new LSMDiskComponentId(20L, 24L));
            ArrayList<ILSMDiskComponentId> resultSecondaryIDs = new ArrayList<ILSMDiskComponentId>();
            IndexInfo secondary = this.mockIndex(false, secondaryComponentIDs, resultSecondaryIDs, 0);
            ILSMMergePolicy policy = this.mockMergePolicy(primary, secondary);
            policy.diskComponentAdded(secondary.getIndex(), false);
            Assert.assertTrue((boolean)resultPrimaryIDs.isEmpty());
            Assert.assertTrue((boolean)resultSecondaryIDs.isEmpty());
            policy.diskComponentAdded(primary.getIndex(), false);
            Assert.assertEquals(Arrays.asList(new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(25L, 29L), new LSMDiskComponentId(20L, 24L), new LSMDiskComponentId(10L, 19L)), resultPrimaryIDs);
            Assert.assertEquals(Arrays.asList(new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(25L, 29L), new LSMDiskComponentId(20L, 24L)), resultSecondaryIDs);
        }
        catch (HyracksDataException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPrimaryNotFound() {
        try {
            List<ILSMDiskComponentId> primaryComponentIDs = Arrays.asList(new LSMDiskComponentId(40L, 50L), new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(25L, 29L), new LSMDiskComponentId(-1L, -1L), new LSMDiskComponentId(10L, 19L));
            ArrayList<ILSMDiskComponentId> resultPrimaryIDs = new ArrayList<ILSMDiskComponentId>();
            IndexInfo primary = this.mockIndex(true, primaryComponentIDs, resultPrimaryIDs, 0);
            List<ILSMDiskComponentId> secondaryComponentIDs = Arrays.asList(new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(25L, 29L), new LSMDiskComponentId(20L, 24L));
            ArrayList<ILSMDiskComponentId> resultSecondaryIDs = new ArrayList<ILSMDiskComponentId>();
            IndexInfo secondary = this.mockIndex(false, secondaryComponentIDs, resultSecondaryIDs, 0);
            ILSMMergePolicy policy = this.mockMergePolicy(primary, secondary);
            policy.diskComponentAdded(secondary.getIndex(), false);
            Assert.assertTrue((boolean)resultPrimaryIDs.isEmpty());
            Assert.assertTrue((boolean)resultSecondaryIDs.isEmpty());
            policy.diskComponentAdded(primary.getIndex(), false);
            Assert.assertEquals(Arrays.asList(new LSMDiskComponentId(40L, 50L), new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(25L, 29L)), resultPrimaryIDs);
            Assert.assertEquals(Arrays.asList(new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(25L, 29L)), resultSecondaryIDs);
        }
        catch (HyracksDataException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSecondaryNotFound() {
        try {
            List<ILSMDiskComponentId> primaryComponentIDs = Arrays.asList(new LSMDiskComponentId(40L, 50L), new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(25L, 29L), new LSMDiskComponentId(20L, 24L), new LSMDiskComponentId(10L, 19L));
            ArrayList<ILSMDiskComponentId> resultPrimaryIDs = new ArrayList<ILSMDiskComponentId>();
            IndexInfo primary = this.mockIndex(true, primaryComponentIDs, resultPrimaryIDs, 0);
            List<ILSMDiskComponentId> secondaryComponentIDs = Arrays.asList(new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(-1L, -1L), new LSMDiskComponentId(20L, 24L));
            ArrayList<ILSMDiskComponentId> resultSecondaryIDs = new ArrayList<ILSMDiskComponentId>();
            IndexInfo secondary = this.mockIndex(false, secondaryComponentIDs, resultSecondaryIDs, 0);
            ILSMMergePolicy policy = this.mockMergePolicy(primary, secondary);
            policy.diskComponentAdded(secondary.getIndex(), false);
            Assert.assertTrue((boolean)resultPrimaryIDs.isEmpty());
            Assert.assertTrue((boolean)resultSecondaryIDs.isEmpty());
            policy.diskComponentAdded(primary.getIndex(), false);
            Assert.assertEquals(Arrays.asList(new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(25L, 29L), new LSMDiskComponentId(20L, 24L), new LSMDiskComponentId(10L, 19L)), resultPrimaryIDs);
            Assert.assertEquals(Arrays.asList(new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(20L, 24L)), resultSecondaryIDs);
        }
        catch (HyracksDataException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMultiPartition() {
        try {
            List<ILSMDiskComponentId> componentIDs = Arrays.asList(new LSMDiskComponentId(40L, 50L), new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(25L, 29L), new LSMDiskComponentId(20L, 24L), new LSMDiskComponentId(10L, 19L));
            ArrayList<ILSMDiskComponentId> resultPrimaryIDs = new ArrayList<ILSMDiskComponentId>();
            IndexInfo primary = this.mockIndex(true, componentIDs, resultPrimaryIDs, 0);
            ArrayList<ILSMDiskComponentId> resultSecondaryIDs = new ArrayList<ILSMDiskComponentId>();
            IndexInfo secondary = this.mockIndex(false, componentIDs, resultSecondaryIDs, 0);
            ArrayList resultSecondaryIDs1 = new ArrayList();
            IndexInfo secondary1 = this.mockIndex(false, componentIDs, resultSecondaryIDs, 1);
            ILSMMergePolicy policy = this.mockMergePolicy(primary, secondary, secondary1);
            policy.diskComponentAdded(secondary.getIndex(), false);
            Assert.assertTrue((boolean)resultPrimaryIDs.isEmpty());
            Assert.assertTrue((boolean)resultSecondaryIDs.isEmpty());
            policy.diskComponentAdded(primary.getIndex(), false);
            Assert.assertEquals(Arrays.asList(new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(25L, 29L), new LSMDiskComponentId(20L, 24L), new LSMDiskComponentId(10L, 19L)), resultPrimaryIDs);
            Assert.assertEquals(Arrays.asList(new LSMDiskComponentId(30L, 35L), new LSMDiskComponentId(25L, 29L), new LSMDiskComponentId(20L, 24L), new LSMDiskComponentId(10L, 19L)), resultSecondaryIDs);
            Assert.assertTrue((boolean)resultSecondaryIDs1.isEmpty());
        }
        catch (HyracksDataException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private ILSMMergePolicy mockMergePolicy(IndexInfo ... indexes) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("max-tolerance-component-count", String.valueOf(3));
        properties.put("max-mergable-component-size", String.valueOf(3));
        HashSet<IndexInfo> indexInfos = new HashSet<IndexInfo>();
        for (IndexInfo info : indexes) {
            indexInfos.add(info);
        }
        DatasetInfo dsInfo = (DatasetInfo)Mockito.mock(DatasetInfo.class);
        Mockito.when((Object)dsInfo.getDatsetIndexInfos()).thenReturn(indexInfos);
        IDatasetLifecycleManager manager = (IDatasetLifecycleManager)Mockito.mock(IDatasetLifecycleManager.class);
        Mockito.when((Object)manager.getDatasetInfo(1)).thenReturn((Object)dsInfo);
        CorrelatedPrefixMergePolicy policy = new CorrelatedPrefixMergePolicy(manager, 1);
        policy.configure(properties);
        return policy;
    }

    private IndexInfo mockIndex(boolean isPrimary, List<ILSMDiskComponentId> componentIDs, final List<ILSMDiskComponentId> resultComponentIDs, int partition) throws HyracksDataException {
        ArrayList<ILSMDiskComponent> components = new ArrayList<ILSMDiskComponent>();
        for (ILSMDiskComponentId id : componentIDs) {
            ILSMDiskComponent component = (ILSMDiskComponent)Mockito.mock(ILSMDiskComponent.class);
            Mockito.when((Object)component.getComponentId()).thenReturn((Object)id);
            Mockito.when((Object)component.getComponentSize()).thenReturn((Object)1L);
            Mockito.when((Object)component.getState()).thenReturn((Object)ILSMComponent.ComponentState.READABLE_UNWRITABLE);
            components.add(component);
        }
        ILSMIndex index = (ILSMIndex)Mockito.mock(ILSMIndex.class);
        Mockito.when((Object)index.getImmutableComponents()).thenReturn(components);
        ILSMIndexAccessor accessor = (ILSMIndexAccessor)Mockito.mock(ILSMIndexAccessor.class);
        ((ILSMIndexAccessor)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                List mergedComponents = (List)invocation.getArgumentAt(1, List.class);
                mergedComponents.forEach(component -> {
                    try {
                        resultComponentIDs.add(component.getComponentId());
                    }
                    catch (HyracksDataException e) {
                        e.printStackTrace();
                    }
                });
                return null;
            }
        }).when((Object)accessor)).scheduleMerge((ILSMIOOperationCallback)Mockito.any(ILSMIOOperationCallback.class), Mockito.anyListOf(ILSMDiskComponent.class));
        Mockito.when((Object)index.createAccessor((IModificationOperationCallback)Mockito.any(IModificationOperationCallback.class), (ISearchOperationCallback)Mockito.any(ISearchOperationCallback.class))).thenReturn((Object)accessor);
        Mockito.when((Object)index.isPrimaryIndex()).thenReturn((Object)isPrimary);
        return new IndexInfo(index, 1, 0L, partition);
    }
}

