/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.base;

import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import org.apache.asterix.test.base.AsterixTestHelper;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class RetainLogsRule
extends TestWatcher {
    private final File baseDir;
    private final File destDir;
    private final Object instance;
    private long startTime;

    public RetainLogsRule(File baseDir, File destDir, Object instance) {
        this.baseDir = baseDir;
        this.destDir = destDir;
        this.instance = instance;
    }

    public RetainLogsRule(String baseDir, String destDir, Object instance) {
        this(new File(baseDir), new File(destDir), instance);
    }

    protected void starting(Description description) {
        this.startTime = System.currentTimeMillis();
    }

    protected void failed(Throwable e, Description description) {
        File reportDir = new File(this.destDir, description.getTestClass().getSimpleName() + "." + description.getMethodName());
        reportDir.mkdirs();
        try {
            AsterixTestHelper.deepSelectiveCopy(this.baseDir, reportDir, pathname -> pathname.getName().endsWith("log") && pathname.lastModified() > this.startTime);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    protected void finished(Description description) {
        if (this.instance != null) {
            for (Method m : this.instance.getClass().getMethods()) {
                if (!m.isAnnotationPresent(After.class)) continue;
                try {
                    m.invoke(this.instance, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface After {
    }
}

