/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.client;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.test.client.ITestClient;

public class FileFeedSocketAdapterClient
implements ITestClient {
    private final int port;
    private final int wait;
    private final String url;
    private Socket socket;
    private String path;
    private int batchSize;
    private int maxCount;
    private OutputStream out = null;
    static final Logger LOGGER = Logger.getLogger(FileFeedSocketAdapterClient.class.getName());

    public FileFeedSocketAdapterClient(int port, String[] args) throws Exception {
        this.port = port;
        if (args.length != 5) {
            throw new Exception("Invalid arguments for FileFeedSocketAdapterClient. Expected arguments <url> <source-file-path> <max-count> <batch-size> <wait>");
        }
        this.url = args[0];
        this.path = args[1];
        this.maxCount = Integer.parseInt(args[2]);
        this.batchSize = Integer.parseInt(args[3]);
        this.wait = Integer.parseInt(args[4]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        FileFeedSocketAdapterClient fileFeedSocketAdapterClient = this;
        synchronized (fileFeedSocketAdapterClient) {
            this.wait(this.wait);
        }
        try {
            this.socket = new Socket(this.url, this.port);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Problem in creating socket against host " + this.url + " on the port " + this.port, e);
            throw e;
        }
        int recordCount = 0;
        BufferedReader br = null;
        try {
            String nextRecord;
            this.out = this.socket.getOutputStream();
            br = new BufferedReader(new FileReader(this.path));
            while ((nextRecord = br.readLine()) != null) {
                ByteBuffer b = StandardCharsets.UTF_8.encode(nextRecord);
                if (this.wait >= 1 && recordCount % this.batchSize == 0) {
                    Thread.sleep(this.wait);
                }
                this.out.write(b.array(), 0, b.limit());
                LOGGER.log(Level.FINE, "One record filed into feed");
                if (++recordCount != this.maxCount) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            System.err.println("Problem in closing socket against host " + this.url + " on the port " + this.port);
            e.printStackTrace();
        }
    }
}

