/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.base;

import java.io.File;
import org.apache.asterix.test.base.AsterixTestHelper;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class RetainLogsRule
extends TestWatcher {
    private final File baseDir;
    private final File destDir;
    private long startTime;

    public RetainLogsRule(File baseDir, File destDir) {
        this.baseDir = baseDir;
        this.destDir = destDir;
    }

    public RetainLogsRule(String baseDir, String destDir) {
        this(new File(baseDir), new File(destDir));
    }

    protected void starting(Description description) {
        this.startTime = System.currentTimeMillis();
    }

    protected void failed(Throwable e, Description description) {
        File reportDir = new File(this.destDir, description.getTestClass().getName() + "." + description.getMethodName());
        reportDir.mkdirs();
        try {
            AsterixTestHelper.deepSelectiveCopy(this.baseDir, reportDir, pathname -> pathname.getName().endsWith("log") && pathname.lastModified() > this.startTime);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

