/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.asterix.test.server.ITestServer;

public class FileTestServer
implements ITestServer {
    protected String[] paths;
    protected final int port;
    protected ServerSocket serverSocket;
    protected Thread listenerThread;

    public FileTestServer(int port) {
        this.port = port;
    }

    @Override
    public void configure(String[] args) {
        this.paths = args;
    }

    @Override
    public void start() throws IOException {
        this.serverSocket = new ServerSocket(this.port);
        this.listenerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!FileTestServer.this.serverSocket.isClosed()) {
                    try {
                        Socket socket = FileTestServer.this.serverSocket.accept();
                        Throwable throwable = null;
                        try {
                            OutputStream os = socket.getOutputStream();
                            Throwable throwable2 = null;
                            try {
                                byte[] chunk = new byte[1024];
                                for (String path : FileTestServer.this.paths) {
                                    try (FileInputStream fin = new FileInputStream(new File(path));){
                                        int read = fin.read(chunk);
                                        while (read > 0) {
                                            os.write(chunk, 0, read);
                                            read = fin.read(chunk);
                                        }
                                    }
                                }
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (os == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        os.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                os.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (socket == null) continue;
                            if (throwable != null) {
                                try {
                                    socket.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            socket.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        this.listenerThread.start();
    }

    @Override
    public void stop() throws IOException, InterruptedException {
        if (this.serverSocket.isBound()) {
            this.serverSocket.close();
            if (this.listenerThread.isAlive()) {
                this.listenerThread.join();
            }
        }
    }
}

