/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.aql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.utils.ServletUtil;
import org.apache.asterix.test.aql.ITestLibrarian;
import org.apache.asterix.test.aql.ResultExtractor;
import org.apache.asterix.test.base.ComparisonException;
import org.apache.asterix.test.server.ITestServer;
import org.apache.asterix.test.server.TestServerProvider;
import org.apache.asterix.testframework.context.TestCaseContext;
import org.apache.asterix.testframework.context.TestFileContext;
import org.apache.asterix.testframework.xml.TestCase;
import org.apache.asterix.testframework.xml.TestGroup;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.util.EntityUtils;
import org.apache.hyracks.util.StorageUtil;

public class TestExecutor {
    protected static final Logger LOGGER = Logger.getLogger(TestExecutor.class.getName());
    private static final long MAX_URL_LENGTH = 2000L;
    private static final Pattern JAVA_BLOCK_COMMENT_PATTERN = Pattern.compile("/\\*.*\\*/", 40);
    private static final Pattern REGEX_LINES_PATTERN = Pattern.compile("^(-)?/(.*)/([im]*)$");
    private static final Pattern POLL_TIMEOUT_PATTERN = Pattern.compile("polltimeoutsecs=(\\d+)(\\D|$)", 8);
    private static final Pattern POLL_DELAY_PATTERN = Pattern.compile("polldelaysecs=(\\d+)(\\D|$)", 8);
    public static final int TRUNCATE_THRESHOLD = 16384;
    private static Method managixExecuteMethod = null;
    private static final HashMap<Integer, ITestServer> runningTestServers = new HashMap();
    protected final String host;
    protected final int port;
    protected ITestLibrarian librarian;

    public TestExecutor(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public TestExecutor() {
        this(Inet4Address.getLoopbackAddress().getHostAddress(), 19002);
    }

    public void setLibrarian(ITestLibrarian librarian) {
        this.librarian = librarian;
    }

    public boolean deleteRec(File path) {
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                if (this.deleteRec(f)) continue;
                return false;
            }
        }
        return path.delete();
    }

    public void runScriptAndCompareWithResult(File scriptFile, PrintWriter print, File expectedFile, File actualFile) throws Exception {
        System.err.println("Expected results file: " + expectedFile.toString());
        BufferedReader readerExpected = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(expectedFile), "UTF-8"));
        BufferedReader readerActual = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(actualFile), "UTF-8"));
        boolean regex = false;
        try {
            String lineActual;
            String lineExpected;
            if (actualFile.toString().endsWith(".regex")) {
                this.runScriptAndCompareWithResultRegex(scriptFile, expectedFile, actualFile);
                return;
            }
            if (actualFile.toString().endsWith(".regexadm")) {
                this.runScriptAndCompareWithResultRegexAdm(scriptFile, expectedFile, actualFile);
                return;
            }
            int num = 1;
            while ((lineExpected = readerExpected.readLine()) != null) {
                String[] lineSplitsActual;
                String[] lineSplitsExpected;
                lineActual = readerActual.readLine();
                if (lineActual == null) {
                    if (lineExpected.isEmpty()) continue;
                    this.throwLineChanged(scriptFile, lineExpected, "<EOF>", num);
                }
                if ((lineSplitsExpected = lineExpected.split("Time")).length != (lineSplitsActual = lineActual.split("Time")).length) {
                    this.throwLineChanged(scriptFile, lineExpected, lineActual, num);
                }
                if (!this.equalStrings(lineSplitsExpected[0], lineSplitsActual[0], regex)) {
                    this.throwLineChanged(scriptFile, lineExpected, lineActual, num);
                }
                for (int i = 1; i < lineSplitsExpected.length; ++i) {
                    String[] splitsByCommaActual;
                    String[] splitsByCommaExpected = lineSplitsExpected[i].split(",");
                    if (splitsByCommaExpected.length != (splitsByCommaActual = lineSplitsActual[i].split(",")).length) {
                        this.throwLineChanged(scriptFile, lineExpected, lineActual, num);
                    }
                    for (int j = 1; j < splitsByCommaExpected.length; ++j) {
                        if (splitsByCommaExpected[j].indexOf("DatasetId") >= 0 || this.equalStrings(splitsByCommaExpected[j], splitsByCommaActual[j], regex)) continue;
                        this.throwLineChanged(scriptFile, lineExpected, lineActual, num);
                    }
                }
                ++num;
            }
            lineActual = readerActual.readLine();
            if (lineActual != null) {
                this.throwLineChanged(scriptFile, "<EOF>", lineActual, num);
            }
        }
        catch (Exception e) {
            System.err.println("Actual results file: " + actualFile.toString());
            throw e;
        }
        finally {
            readerExpected.close();
            readerActual.close();
        }
    }

    private void throwLineChanged(File scriptFile, String lineExpected, String lineActual, int num) throws ComparisonException {
        throw new ComparisonException("Result for " + scriptFile + " changed at line " + num + ":\n< " + this.truncateIfLong(lineExpected) + "\n> " + this.truncateIfLong(lineActual));
    }

    private String truncateIfLong(String string) {
        if (string.length() < 16384) {
            return string;
        }
        StringBuilder truncatedString = new StringBuilder(string);
        truncatedString.setLength(16384);
        truncatedString.append("\n<truncated ").append(StorageUtil.toHumanReadableSize((long)(string.length() - 16384))).append("...>");
        return truncatedString.toString();
    }

    private boolean equalStrings(String expected, String actual, boolean regexMatch) {
        String[] rowsExpected = expected.split("\n");
        String[] rowsActual = actual.split("\n");
        for (int i = 0; i < rowsExpected.length; ++i) {
            String expectedRow = rowsExpected[i];
            String actualRow = rowsActual[i];
            if (regexMatch ? actualRow.matches(expectedRow) : actualRow.equals(expectedRow)) continue;
            String[] expectedFields = expectedRow.split(" ");
            String[] actualFields = actualRow.split(" ");
            boolean bagEncountered = false;
            HashSet<String> expectedBagElements = new HashSet<String>();
            HashSet<String> actualBagElements = new HashSet<String>();
            for (int j = 0; j < expectedFields.length; ++j) {
                if (j >= actualFields.length) {
                    return false;
                }
                if (expectedFields[j].equals(actualFields[j])) {
                    bagEncountered = expectedFields[j].equals("{{");
                    if (!expectedFields[j].startsWith("}}")) continue;
                    if (regexMatch) {
                        if (expectedBagElements.size() != actualBagElements.size()) {
                            return false;
                        }
                        int[] expectedHits = new int[expectedBagElements.size()];
                        int[] actualHits = new int[actualBagElements.size()];
                        int k = 0;
                        for (String expectedElement : expectedBagElements) {
                            int l = 0;
                            for (String actualElement : actualBagElements) {
                                if (actualElement.matches(expectedElement)) {
                                    int n = k;
                                    expectedHits[n] = expectedHits[n] + 1;
                                    int n2 = l;
                                    actualHits[n2] = actualHits[n2] + 1;
                                }
                                ++l;
                            }
                            ++k;
                        }
                        for (int m = 0; m < expectedHits.length; ++m) {
                            if (expectedHits[m] != 0 && actualHits[m] != 0) continue;
                            return false;
                        }
                    } else if (!expectedBagElements.equals(actualBagElements)) {
                        return false;
                    }
                    bagEncountered = false;
                    expectedBagElements.clear();
                    actualBagElements.clear();
                    continue;
                }
                if (expectedFields[j].indexOf(46) < 0) {
                    if (bagEncountered) {
                        expectedBagElements.add(expectedFields[j].replaceAll(",$", ""));
                        actualBagElements.add(actualFields[j].replaceAll(",$", ""));
                        continue;
                    }
                    return false;
                }
                expectedFields[j] = expectedFields[j].split(",")[0];
                actualFields[j] = actualFields[j].split(",")[0];
                try {
                    Double double1 = Double.parseDouble(expectedFields[j]);
                    Double double2 = Double.parseDouble(actualFields[j]);
                    float float1 = (float)double1.doubleValue();
                    float float2 = (float)double2.doubleValue();
                    if (Math.abs(float1 - float2) == 0.0f) continue;
                    return false;
                }
                catch (NumberFormatException ignored) {
                    return false;
                }
            }
        }
        return true;
    }

    public void runScriptAndCompareWithResultRegex(File scriptFile, File expectedFile, File actualFile) throws Exception {
        System.err.println("Expected results file: " + expectedFile.toString());
        try (BufferedReader readerExpected = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(expectedFile), "UTF-8"));
             BufferedReader readerActual = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(actualFile), "UTF-8"));){
            String lineExpected;
            String lineActual;
            StringBuilder actual = new StringBuilder();
            while ((lineActual = readerActual.readLine()) != null) {
                actual.append(lineActual).append('\n');
            }
            while ((lineExpected = readerExpected.readLine()) != null) {
                Pattern linePattern;
                boolean match;
                if ("".equals(lineExpected.trim())) continue;
                Matcher m = REGEX_LINES_PATTERN.matcher(lineExpected);
                if (!m.matches()) {
                    throw new IllegalArgumentException("Each line of regex file must conform to: [-]/regex/[flags]: " + expectedFile);
                }
                String negateStr = m.group(1);
                String expression = m.group(2);
                String flagStr = m.group(3);
                boolean negate = "-".equals(negateStr);
                int flags = 8;
                if (flagStr.contains("m")) {
                    flags |= 0x20;
                }
                if (flagStr.contains("i")) {
                    flags |= 2;
                }
                if ((match = (linePattern = Pattern.compile(expression, flags)).matcher(actual).find()) && !negate || negate && !match) continue;
                throw new Exception("Result for " + scriptFile + ": expected pattern '" + expression + "' not found in result.");
            }
        }
        catch (Exception e) {
            System.err.println("Actual results file: " + actualFile.toString());
            throw e;
        }
    }

    public void runScriptAndCompareWithResultRegexAdm(File scriptFile, File expectedFile, File actualFile) throws Exception {
        StringWriter actual = new StringWriter();
        StringWriter expected = new StringWriter();
        IOUtils.copy((InputStream)new FileInputStream(actualFile), (Writer)actual, (Charset)StandardCharsets.UTF_8);
        IOUtils.copy((InputStream)new FileInputStream(expectedFile), (Writer)expected, (Charset)StandardCharsets.UTF_8);
        Pattern pattern = Pattern.compile(expected.toString(), 40);
        if (!pattern.matcher(actual.toString()).matches()) {
            throw new Exception("Result for " + scriptFile + ": actual file did not match expected result");
        }
    }

    private static void writeOutputToFile(File actualFile, InputStream resultStream) throws Exception {
        if (!actualFile.getParentFile().mkdirs()) {
            LOGGER.warning("Unable to create actual file parent dir: " + actualFile.getParentFile());
        }
        try (FileOutputStream out = new FileOutputStream(actualFile);){
            IOUtils.copy((InputStream)resultStream, (OutputStream)out);
        }
    }

    protected HttpResponse executeAndCheckHttpRequest(HttpUriRequest method) throws Exception {
        return this.checkResponse(this.executeHttpRequest(method));
    }

    protected HttpResponse executeHttpRequest(HttpUriRequest method) throws Exception {
        CloseableHttpClient client = HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)StandardHttpRequestRetryHandler.INSTANCE).build();
        try {
            return client.execute(method);
        }
        catch (Exception e) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.SEVERE, e.getMessage(), e);
            e.printStackTrace();
            throw e;
        }
    }

    protected HttpResponse checkResponse(HttpResponse httpResponse) throws Exception {
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            String exceptionMsg;
            String errorBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            try {
                ObjectMapper om = new ObjectMapper();
                JsonNode result = om.readTree(errorBody);
                String[] errors = new String[]{result.get("error-code").asText(), result.get("summary").asText(), result.get("stacktrace").asText()};
                GlobalConfig.ASTERIX_LOGGER.log(Level.SEVERE, errors[2]);
                exceptionMsg = "HTTP operation failed: " + errors[0] + "\nSTATUS LINE: " + httpResponse.getStatusLine() + "\nSUMMARY: " + errors[1] + "\nSTACKTRACE: " + errors[2];
            }
            catch (Exception e) {
                GlobalConfig.ASTERIX_LOGGER.log(Level.SEVERE, errorBody);
                exceptionMsg = "HTTP operation failed:\nSTATUS LINE: " + httpResponse.getStatusLine() + "\nERROR_BODY: " + errorBody;
            }
            throw new Exception(exceptionMsg);
        }
        return httpResponse;
    }

    public InputStream executeQuery(String str, TestCaseContext.OutputFormat fmt, String url, List<TestCase.CompilationUnit.Parameter> params) throws Exception {
        HttpUriRequest method = this.constructHttpMethod(str, url, "query", false, params);
        method.setHeader("Accept", fmt.mimeType());
        HttpResponse response = this.executeAndCheckHttpRequest(method);
        return response.getEntity().getContent();
    }

    public InputStream executeQueryService(String str, String url) throws Exception {
        return this.executeQueryService(str, TestCaseContext.OutputFormat.CLEAN_JSON, url, new ArrayList<TestCase.CompilationUnit.Parameter>(), false);
    }

    public InputStream executeQueryService(String str, TestCaseContext.OutputFormat fmt, String url, List<TestCase.CompilationUnit.Parameter> params, boolean jsonEncoded) throws Exception {
        this.setParam(params, "format", fmt.mimeType());
        HttpUriRequest method = jsonEncoded ? this.constructPostMethodJson(str, url, "statement", params) : this.constructPostMethodUrl(str, url, "statement", params);
        method.setHeader("Accept", TestCaseContext.OutputFormat.CLEAN_JSON.mimeType());
        HttpResponse response = this.executeHttpRequest(method);
        return response.getEntity().getContent();
    }

    public InputStream executeQueryService(String statement, TestCaseContext.OutputFormat fmt, String url, List<TestCase.CompilationUnit.Parameter> params, boolean jsonEncoded, String deferred) throws Exception {
        this.setParam(params, "mode", deferred);
        InputStream resultStream = this.executeQueryService(statement, fmt, url, params, jsonEncoded);
        String handle = ResultExtractor.extractHandle(resultStream);
        return this.getHandleResult(handle, fmt);
    }

    protected void setParam(List<TestCase.CompilationUnit.Parameter> params, String name, String value) {
        for (TestCase.CompilationUnit.Parameter param : params) {
            if (!name.equals(param.getName())) continue;
            param.setValue(value);
            return;
        }
        TestCase.CompilationUnit.Parameter formatParam = new TestCase.CompilationUnit.Parameter();
        formatParam.setName(name);
        formatParam.setValue(value);
        params.add(formatParam);
    }

    private List<TestCase.CompilationUnit.Parameter> injectStatement(String statement, String stmtParamName, List<TestCase.CompilationUnit.Parameter> otherParams) {
        TestCase.CompilationUnit.Parameter stmtParam = new TestCase.CompilationUnit.Parameter();
        stmtParam.setName(stmtParamName);
        stmtParam.setValue(statement);
        ArrayList<TestCase.CompilationUnit.Parameter> params = new ArrayList<TestCase.CompilationUnit.Parameter>(otherParams);
        params.add(stmtParam);
        return params;
    }

    private HttpUriRequest constructHttpMethod(String statement, String endpoint, String stmtParam, boolean postStmtAsParam, List<TestCase.CompilationUnit.Parameter> otherParams) {
        if ((long)(statement.length() + endpoint.length()) < 2000L) {
            return this.constructGetMethod(endpoint, this.injectStatement(statement, stmtParam, otherParams));
        }
        String stmtParamName = postStmtAsParam ? stmtParam : null;
        return this.constructPostMethodUrl(statement, endpoint, stmtParamName, otherParams);
    }

    private HttpUriRequest constructGetMethod(String endpoint, List<TestCase.CompilationUnit.Parameter> params) {
        RequestBuilder builder = RequestBuilder.get((String)endpoint);
        for (TestCase.CompilationUnit.Parameter param : params) {
            builder.addParameter(param.getName(), param.getValue());
        }
        builder.setCharset(StandardCharsets.UTF_8);
        return builder.build();
    }

    private HttpUriRequest constructGetMethod(String endpoint, TestCaseContext.OutputFormat fmt, List<TestCase.CompilationUnit.Parameter> params) {
        HttpUriRequest method = this.constructGetMethod(endpoint, params);
        method.setHeader("Accept", fmt.mimeType());
        return method;
    }

    private HttpUriRequest constructPostMethod(String endpoint, List<TestCase.CompilationUnit.Parameter> params) {
        RequestBuilder builder = RequestBuilder.post((String)endpoint);
        for (TestCase.CompilationUnit.Parameter param : params) {
            builder.addParameter(param.getName(), param.getValue());
        }
        builder.setCharset(StandardCharsets.UTF_8);
        return builder.build();
    }

    private HttpUriRequest constructPostMethod(String endpoint, TestCaseContext.OutputFormat fmt, List<TestCase.CompilationUnit.Parameter> params) {
        HttpUriRequest method = this.constructPostMethod(endpoint, params);
        method.setHeader("Accept", fmt.mimeType());
        return method;
    }

    protected HttpUriRequest constructPostMethodUrl(String statement, String endpoint, String stmtParam, List<TestCase.CompilationUnit.Parameter> otherParams) {
        RequestBuilder builder = RequestBuilder.post((String)endpoint);
        if (stmtParam != null) {
            for (TestCase.CompilationUnit.Parameter param : this.injectStatement(statement, stmtParam, otherParams)) {
                builder.addParameter(param.getName(), param.getValue());
            }
            builder.addParameter(stmtParam, statement);
        } else {
            builder.setEntity((HttpEntity)new StringEntity(statement, StandardCharsets.UTF_8));
        }
        builder.setCharset(StandardCharsets.UTF_8);
        return builder.build();
    }

    protected HttpUriRequest constructPostMethodJson(String statement, String endpoint, String stmtParam, List<TestCase.CompilationUnit.Parameter> otherParams) {
        if (stmtParam == null) {
            throw new NullPointerException("Statement parameter required.");
        }
        RequestBuilder builder = RequestBuilder.post((String)endpoint);
        ObjectMapper om = new ObjectMapper();
        ObjectNode content = om.createObjectNode();
        for (TestCase.CompilationUnit.Parameter param : this.injectStatement(statement, stmtParam, otherParams)) {
            content.put(param.getName(), param.getValue());
        }
        try {
            builder.setEntity((HttpEntity)new StringEntity(om.writeValueAsString((Object)content), ContentType.APPLICATION_JSON));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        builder.setCharset(StandardCharsets.UTF_8);
        return builder.build();
    }

    public InputStream executeJSONGet(TestCaseContext.OutputFormat fmt, String url) throws Exception {
        HttpUriRequest request = this.constructGetMethod(url, fmt, new ArrayList<TestCase.CompilationUnit.Parameter>());
        HttpResponse response = this.executeAndCheckHttpRequest(request);
        return response.getEntity().getContent();
    }

    public InputStream executeJSONPost(TestCaseContext.OutputFormat fmt, String url) throws Exception {
        HttpUriRequest request = this.constructPostMethod(url, fmt, new ArrayList<TestCase.CompilationUnit.Parameter>());
        HttpResponse response = this.executeAndCheckHttpRequest(request);
        return response.getEntity().getContent();
    }

    public void executeUpdate(String str, String url) throws Exception {
        HttpUriRequest request = RequestBuilder.post((String)url).setEntity((HttpEntity)new StringEntity(str, StandardCharsets.UTF_8)).build();
        this.executeAndCheckHttpRequest(request);
    }

    public InputStream executeAnyAQLAsync(String str, boolean defer, TestCaseContext.OutputFormat fmt, String url) throws Exception {
        HttpUriRequest request = RequestBuilder.post((String)url).addParameter("mode", defer ? "asynchronous-deferred" : "asynchronous").setEntity((HttpEntity)new StringEntity(str, StandardCharsets.UTF_8)).setHeader("Accept", fmt.mimeType()).build();
        HttpResponse response = this.executeAndCheckHttpRequest(request);
        InputStream resultStream = response.getEntity().getContent();
        String theHandle = IOUtils.toString((InputStream)resultStream, (String)"UTF-8");
        return this.getHandleResult(theHandle, fmt);
    }

    private InputStream getHandleResult(String handle, TestCaseContext.OutputFormat fmt) throws Exception {
        String url = this.getEndpoint(ServletUtil.Servlets.QUERY_RESULT);
        HttpUriRequest request = RequestBuilder.get((String)url).addParameter("handle", handle).setHeader("Accept", fmt.mimeType()).build();
        HttpResponse response = this.executeAndCheckHttpRequest(request);
        return response.getEntity().getContent();
    }

    public void executeDDL(String str, String url) throws Exception {
        HttpUriRequest request = RequestBuilder.post((String)url).setEntity((HttpEntity)new StringEntity(str, StandardCharsets.UTF_8)).build();
        this.executeAndCheckHttpRequest(request);
    }

    public String readTestFile(File testFile) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(testFile), StandardCharsets.UTF_8));
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        return stringBuilder.toString();
    }

    public static void executeManagixCommand(String command) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (managixExecuteMethod == null) {
            Class<?> clazz = Class.forName("org.apache.asterix.installer.test.AsterixInstallerIntegrationUtil");
            managixExecuteMethod = clazz.getMethod("executeCommand", String.class);
        }
        managixExecuteMethod.invoke(null, command);
    }

    public static String executeScript(ProcessBuilder pb, String scriptPath) throws Exception {
        LOGGER.info("Executing script: " + scriptPath);
        pb.command(scriptPath);
        Process p = pb.start();
        return TestExecutor.getProcessOutput(p);
    }

    private static String executeVagrantScript(ProcessBuilder pb, String node, String scriptName) throws Exception {
        pb.command("vagrant", "ssh", node, "--", pb.environment().get("SCRIPT_HOME") + scriptName);
        Process p = pb.start();
        p.waitFor();
        InputStream input = p.getInputStream();
        return IOUtils.toString((InputStream)input, (String)StandardCharsets.UTF_8.name());
    }

    private static String executeVagrantManagix(ProcessBuilder pb, String command) throws Exception {
        pb.command("vagrant", "ssh", "cc", "--", pb.environment().get("MANAGIX_HOME") + command);
        Process p = pb.start();
        p.waitFor();
        InputStream input = p.getInputStream();
        return IOUtils.toString((InputStream)input, (String)StandardCharsets.UTF_8.name());
    }

    private static String getScriptPath(String queryPath, String scriptBasePath, String scriptFileName) {
        String targetWord = "queries" + File.separator;
        int targetWordSize = targetWord.lastIndexOf(File.separator);
        int beginIndex = queryPath.lastIndexOf(targetWord) + targetWordSize;
        int endIndex = queryPath.lastIndexOf(File.separator);
        String prefix = queryPath.substring(beginIndex, endIndex);
        return scriptBasePath + prefix + File.separator + scriptFileName;
    }

    private static String getProcessOutput(Process p) throws Exception {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Future<Integer> future = Executors.newSingleThreadExecutor().submit(() -> IOUtils.copy((InputStream)p.getInputStream(), (OutputStream)new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                baos.write(b);
                System.out.write(b);
            }

            @Override
            public void flush() throws IOException {
                baos.flush();
                System.out.flush();
            }

            @Override
            public void close() throws IOException {
                baos.close();
                System.out.close();
            }
        }));
        p.waitFor();
        future.get();
        ByteArrayInputStream bisIn = new ByteArrayInputStream(baos.toByteArray());
        StringWriter writerIn = new StringWriter();
        IOUtils.copy((InputStream)bisIn, (Writer)writerIn, (Charset)StandardCharsets.UTF_8);
        StringWriter writerErr = new StringWriter();
        IOUtils.copy((InputStream)p.getErrorStream(), (Writer)writerErr, (Charset)StandardCharsets.UTF_8);
        StringBuffer stdOut = writerIn.getBuffer();
        if (writerErr.getBuffer().length() > 0) {
            StringBuilder sbErr = new StringBuilder();
            sbErr.append("script execution failed - error message:\n-------------------------------------------\nstdout: ").append(stdOut).append("\nstderr: ").append(writerErr.getBuffer()).append("-------------------------------------------");
            LOGGER.info(sbErr.toString());
            throw new Exception(sbErr.toString());
        }
        return stdOut.toString();
    }

    public void executeTest(String actualPath, TestCaseContext testCaseCtx, ProcessBuilder pb, boolean isDmlRecoveryTest) throws Exception {
        this.executeTest(actualPath, testCaseCtx, pb, isDmlRecoveryTest, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeTest(TestCaseContext testCaseCtx, TestFileContext ctx, String statement, boolean isDmlRecoveryTest, ProcessBuilder pb, TestCase.CompilationUnit cUnit, MutableInt queryCount, List<TestFileContext> expectedResultFileCtxs, File testFile, String actualPath) throws Exception {
        boolean failed = false;
        switch (ctx.getType()) {
            case "ddl": {
                if (ctx.getFile().getName().endsWith("aql")) {
                    this.executeDDL(statement, this.getEndpoint(ServletUtil.Servlets.AQL_DDL));
                    return;
                }
                InputStream resultStream = this.executeQueryService(statement, this.getEndpoint(ServletUtil.Servlets.QUERY_SERVICE));
                ResultExtractor.extract(resultStream);
                return;
            }
            case "update": {
                if (isDmlRecoveryTest && statement.contains("nc1://")) {
                    statement = statement.replaceAll("nc1://", "127.0.0.1://../../../../../../asterix-app/");
                }
                if (ctx.getFile().getName().endsWith("aql")) {
                    this.executeUpdate(statement, this.getEndpoint(ServletUtil.Servlets.AQL_UPDATE));
                    return;
                }
                InputStream resultStream = this.executeQueryService(statement, this.getEndpoint(ServletUtil.Servlets.QUERY_SERVICE));
                ResultExtractor.extract(resultStream);
                return;
            }
            case "pollquery": {
                Exception finalException;
                Matcher timeoutMatcher = POLL_TIMEOUT_PATTERN.matcher(statement);
                if (!timeoutMatcher.find()) throw new IllegalArgumentException("ERROR: polltimeoutsecs=nnn must be present in poll file");
                int timeoutSecs = Integer.parseInt(timeoutMatcher.group(1));
                Matcher retryDelayMatcher = POLL_DELAY_PATTERN.matcher(statement);
                int retryDelaySecs = retryDelayMatcher.find() ? Integer.parseInt(timeoutMatcher.group(1)) : 1;
                long startTime = System.currentTimeMillis();
                long limitTime = startTime + TimeUnit.SECONDS.toMillis(timeoutSecs);
                ctx.setType(ctx.getType().substring("poll".length()));
                LOGGER.fine("polling for up to " + timeoutSecs + " seconds w/ " + retryDelaySecs + " second(s) delay");
                while (true) {
                    try {
                        this.executeTest(testCaseCtx, ctx, statement, isDmlRecoveryTest, pb, cUnit, queryCount, expectedResultFileCtxs, testFile, actualPath);
                        return;
                    }
                    catch (Exception e) {
                        if (System.currentTimeMillis() > limitTime) {
                            finalException = e;
                            break;
                        }
                        LOGGER.fine("sleeping " + retryDelaySecs + " second(s) before polling again");
                        Thread.sleep(TimeUnit.SECONDS.toMillis(retryDelaySecs));
                        continue;
                    }
                    break;
                }
                if (finalException == null) return;
                throw new Exception("Poll limit (" + timeoutSecs + "s) exceeded without obtaining expected result", finalException);
            }
            case "query": 
            case "async": 
            case "asyncdefer": {
                if (isDmlRecoveryTest) {
                    TestExecutor.executeScript(pb, pb.environment().get("SCRIPT_HOME") + File.separator + "dml_recovery" + File.separator + "kill_cc_and_nc.sh");
                    TestExecutor.executeScript(pb, pb.environment().get("SCRIPT_HOME") + File.separator + "dml_recovery" + File.separator + "stop_and_start.sh");
                }
                InputStream resultStream = null;
                TestCaseContext.OutputFormat fmt = TestCaseContext.OutputFormat.forCompilationUnit((TestCase.CompilationUnit)cUnit);
                if (ctx.getFile().getName().endsWith("aql")) {
                    if (ctx.getType().equalsIgnoreCase("query")) {
                        resultStream = this.executeQuery(statement, fmt, this.getEndpoint(ServletUtil.Servlets.AQL_QUERY), cUnit.getParameter());
                    } else if (ctx.getType().equalsIgnoreCase("async")) {
                        resultStream = this.executeAnyAQLAsync(statement, false, fmt, this.getEndpoint(ServletUtil.Servlets.AQL));
                    } else if (ctx.getType().equalsIgnoreCase("asyncdefer")) {
                        resultStream = this.executeAnyAQLAsync(statement, true, fmt, this.getEndpoint(ServletUtil.Servlets.AQL));
                    }
                } else {
                    String reqType = ctx.getType();
                    String url = this.getEndpoint(ServletUtil.Servlets.QUERY_SERVICE);
                    List params = cUnit.getParameter();
                    if (reqType.equalsIgnoreCase("query")) {
                        resultStream = this.executeQueryService(statement, fmt, url, params, true);
                        resultStream = ResultExtractor.extract(resultStream);
                    } else if (reqType.equalsIgnoreCase("async")) {
                        resultStream = this.executeQueryService(statement, fmt, url, params, true, "async");
                    } else if (reqType.equalsIgnoreCase("asyncdefer")) {
                        resultStream = this.executeQueryService(statement, fmt, url, params, true, "deferred");
                    }
                }
                if (queryCount.intValue() >= expectedResultFileCtxs.size()) {
                    throw new IllegalStateException("no result file for " + testFile.toString() + "; queryCount: " + queryCount + ", filectxs.size: " + expectedResultFileCtxs.size());
                }
                File expectedResultFile = expectedResultFileCtxs.get(queryCount.intValue()).getFile();
                File actualResultFile = testCaseCtx.getActualResultFile(cUnit, expectedResultFile, new File(actualPath));
                TestExecutor.writeOutputToFile(actualResultFile, resultStream);
                this.runScriptAndCompareWithResult(testFile, new PrintWriter(System.err), expectedResultFile, actualResultFile);
                queryCount.increment();
                actualResultFile.getParentFile().delete();
                return;
            }
            case "mgx": {
                TestExecutor.executeManagixCommand(statement);
                return;
            }
            case "txnqbc": {
                InputStream resultStream = this.executeQuery(statement, TestCaseContext.OutputFormat.forCompilationUnit((TestCase.CompilationUnit)cUnit), this.getEndpoint(ServletUtil.Servlets.AQL_QUERY), cUnit.getParameter());
                File qbcFile = TestExecutor.getTestCaseQueryBeforeCrashFile(actualPath, testCaseCtx, cUnit);
                TestExecutor.writeOutputToFile(qbcFile, resultStream);
                return;
            }
            case "txnqar": {
                InputStream resultStream = this.executeQuery(statement, TestCaseContext.OutputFormat.forCompilationUnit((TestCase.CompilationUnit)cUnit), this.getEndpoint(ServletUtil.Servlets.AQL_QUERY), cUnit.getParameter());
                File qarFile = new File(actualPath + File.separator + testCaseCtx.getTestCase().getFilePath().replace(File.separator, "_") + "_" + cUnit.getName() + "_qar.adm");
                TestExecutor.writeOutputToFile(qarFile, resultStream);
                File qbcFile = TestExecutor.getTestCaseQueryBeforeCrashFile(actualPath, testCaseCtx, cUnit);
                this.runScriptAndCompareWithResult(testFile, new PrintWriter(System.err), qbcFile, qarFile);
                return;
            }
            case "txneu": {
                try {
                    this.executeUpdate(statement, this.getEndpoint(ServletUtil.Servlets.AQL_UPDATE));
                }
                catch (Exception e) {
                    failed = true;
                    e.printStackTrace();
                }
                if (!failed) {
                    throw new Exception("Test \"" + testFile + "\" FAILED!\n  An exception" + "is expected.");
                }
                System.err.println("...but that was expected.");
                return;
            }
            case "script": {
                try {
                    String output = TestExecutor.executeScript(pb, TestExecutor.getScriptPath(testFile.getAbsolutePath(), pb.environment().get("SCRIPT_HOME"), statement.trim()));
                    if (!output.contains("ERROR")) return;
                    throw new Exception(output);
                }
                catch (Exception e) {
                    throw new Exception("Test \"" + testFile + "\" FAILED!\n", e);
                }
            }
            case "sleep": {
                String[] lines = statement.split("\n");
                Thread.sleep(Long.parseLong(lines[lines.length - 1].trim()));
                return;
            }
            case "errddl": {
                try {
                    this.executeDDL(statement, this.getEndpoint(ServletUtil.Servlets.AQL_DDL));
                }
                catch (Exception e) {
                    failed = true;
                    e.printStackTrace();
                }
                if (!failed) {
                    throw new Exception("Test \"" + testFile + "\" FAILED!\n  An exception is expected.");
                }
                System.err.println("...but that was expected.");
                return;
            }
            case "vscript": {
                try {
                    String[] command = statement.trim().split(" ");
                    if (command.length != 2) {
                        throw new Exception("invalid vagrant script format");
                    }
                    String nodeId = command[0];
                    String scriptName = command[1];
                    String output = TestExecutor.executeVagrantScript(pb, nodeId, scriptName);
                    if (!output.contains("ERROR")) return;
                    throw new Exception(output);
                }
                catch (Exception e) {
                    throw new Exception("Test \"" + testFile + "\" FAILED!\n", e);
                }
            }
            case "vmgx": {
                String output = TestExecutor.executeVagrantManagix(pb, statement);
                if (!output.contains("ERROR")) return;
                throw new Exception(output);
            }
            case "get": 
            case "post": {
                InputStream resultStream;
                if (!"http".equals(ctx.extension())) {
                    throw new IllegalArgumentException("Unexpected format for method " + ctx.getType() + ": " + ctx.extension());
                }
                TestCaseContext.OutputFormat fmt = TestCaseContext.OutputFormat.forCompilationUnit((TestCase.CompilationUnit)cUnit);
                String endpoint = TestExecutor.stripJavaComments(statement).trim();
                switch (ctx.getType()) {
                    case "get": {
                        resultStream = this.executeJSONGet(fmt, "http://" + this.host + ":" + this.port + endpoint);
                        break;
                    }
                    case "post": {
                        resultStream = this.executeJSONPost(fmt, "http://" + this.host + ":" + this.port + endpoint);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("NYI: " + ctx.getType());
                    }
                }
                File expectedResultFile = expectedResultFileCtxs.get(queryCount.intValue()).getFile();
                File actualResultFile = testCaseCtx.getActualResultFile(cUnit, expectedResultFile, new File(actualPath));
                TestExecutor.writeOutputToFile(actualResultFile, resultStream);
                this.runScriptAndCompareWithResult(testFile, new PrintWriter(System.err), expectedResultFile, actualResultFile);
                queryCount.increment();
                return;
            }
            case "server": {
                try {
                    String[] lines = statement.trim().split("\n");
                    String[] command = lines[lines.length - 1].trim().split(" ");
                    if (command.length < 2) {
                        throw new Exception("invalid server command format. expected format = (start <test server name> <port> [<arg1>][<arg2>][<arg3>]...|stop (<port>|all))");
                    }
                    String action = command[0];
                    if (action.equals("start")) {
                        if (command.length < 3) {
                            throw new Exception("invalid server start command. expected format = (start <test server name> <port> [<arg1>][<arg2>][<arg3>]...");
                        }
                        String name = command[1];
                        Integer port = new Integer(command[2]);
                        if (runningTestServers.containsKey(port)) {
                            throw new Exception("server with port " + port + " is already running");
                        }
                        ITestServer server = TestServerProvider.createTestServer(name, port);
                        server.configure(Arrays.copyOfRange(command, 3, command.length));
                        server.start();
                        runningTestServers.put(port, server);
                        return;
                    }
                    if (!action.equals("stop")) throw new Exception("unknown server action");
                    String target = command[1];
                    if (target.equals("all")) {
                        for (ITestServer server : runningTestServers.values()) {
                            server.stop();
                        }
                        runningTestServers.clear();
                        return;
                    }
                    Integer port = new Integer(command[1]);
                    ITestServer server = runningTestServers.get(port);
                    if (server == null) {
                        throw new Exception("no server is listening to port " + port);
                    }
                    server.stop();
                    runningTestServers.remove(port);
                    return;
                }
                catch (Exception e) {
                    throw new Exception("Test \"" + testFile + "\" FAILED!\n", e);
                }
            }
            case "lib": {
                String[] lines = statement.split("\n");
                String lastLine = lines[lines.length - 1];
                String[] command = lastLine.trim().split(" ");
                if (command.length < 3) {
                    throw new Exception("invalid library format");
                }
                String dataverse = command[1];
                String library = command[2];
                switch (command[0]) {
                    case "install": {
                        if (command.length != 4) {
                            throw new Exception("invalid library format");
                        }
                        String libPath = command[3];
                        this.librarian.install(dataverse, library, libPath);
                        return;
                    }
                    case "uninstall": {
                        if (command.length != 3) {
                            throw new Exception("invalid library format");
                        }
                        this.librarian.uninstall(dataverse, library);
                        return;
                    }
                }
                throw new Exception("invalid library format");
            }
            case "node": {
                String[] command = TestExecutor.stripJavaComments(statement).trim().split(" ");
                String commandType = command[0];
                String nodeId = command[1];
                if (!commandType.equals("kill")) return;
                this.killNC(nodeId, cUnit);
                return;
            }
            default: {
                throw new IllegalArgumentException("No statements of type " + ctx.getType());
            }
        }
    }

    private void killNC(String nodeId, TestCase.CompilationUnit cUnit) throws Exception {
        TestCaseContext.OutputFormat fmt = TestCaseContext.OutputFormat.forCompilationUnit((TestCase.CompilationUnit)cUnit);
        String endpoint = "/admin/cluster/node/" + nodeId + "/config";
        InputStream executeJSONGet = this.executeJSONGet(fmt, "http://" + this.host + ":" + this.port + endpoint);
        StringWriter actual = new StringWriter();
        IOUtils.copy((InputStream)executeJSONGet, (Writer)actual, (Charset)StandardCharsets.UTF_8);
        String config = actual.toString();
        int nodePid = ((ObjectNode)new ObjectMapper().readValue(config, ObjectNode.class)).get("pid").asInt();
        if (nodePid <= 1) {
            throw new IllegalArgumentException("Could not retrieve node pid from admin API");
        }
        ProcessBuilder pb = new ProcessBuilder("kill", "-9", Integer.toString(nodePid));
        pb.start().waitFor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTest(String actualPath, TestCaseContext testCaseCtx, ProcessBuilder pb, boolean isDmlRecoveryTest, TestGroup failedGroup) throws Exception {
        MutableInt queryCount = new MutableInt(0);
        int numOfErrors = 0;
        int numOfFiles = 0;
        List cUnits = testCaseCtx.getTestCase().getCompilationUnit();
        for (TestCase.CompilationUnit cUnit : cUnits) {
            LOGGER.info("Starting [TEST]: " + testCaseCtx.getTestCase().getFilePath() + "/" + cUnit.getName() + " ... ");
            List testFileCtxs = testCaseCtx.getTestFiles(cUnit);
            List expectedResultFileCtxs = testCaseCtx.getExpectedResultFiles(cUnit);
            for (TestFileContext ctx : testFileCtxs) {
                ++numOfFiles;
                File testFile = ctx.getFile();
                String statement = this.readTestFile(testFile);
                try {
                    this.executeTest(testCaseCtx, ctx, statement, isDmlRecoveryTest, pb, cUnit, queryCount, expectedResultFileCtxs, testFile, actualPath);
                }
                catch (Exception e) {
                    System.err.println("testFile " + testFile.toString() + " raised an exception: " + e);
                    boolean unExpectedFailure = false;
                    String expectedError = null;
                    if (cUnit.getExpectedError().size() < ++numOfErrors) {
                        unExpectedFailure = true;
                    } else {
                        expectedError = (String)cUnit.getExpectedError().get(numOfErrors - 1);
                        if (e.toString().contains(expectedError)) {
                            System.err.println("...but that was expected.");
                        } else {
                            unExpectedFailure = true;
                        }
                    }
                    if (!unExpectedFailure) continue;
                    e.printStackTrace();
                    System.err.println("...Unexpected!");
                    if (expectedError != null) {
                        System.err.println("Expected to find the following in error text:\n+++++\n" + expectedError + "\n+++++");
                    }
                    if (failedGroup != null) {
                        failedGroup.getTestCase().add(testCaseCtx.getTestCase());
                    }
                    throw new Exception("Test \"" + testFile + "\" FAILED!", e);
                }
                finally {
                    if (numOfFiles == testFileCtxs.size() && numOfErrors < cUnit.getExpectedError().size()) {
                        System.err.println("...Unexpected!");
                        e = new Exception("Test \"" + cUnit.getName() + "\" FAILED!\nExpected error was not thrown...");
                        e.printStackTrace();
                        throw e;
                    }
                    if (numOfFiles != testFileCtxs.size()) continue;
                    LOGGER.info("[TEST]: " + testCaseCtx.getTestCase().getFilePath() + "/" + cUnit.getName() + " PASSED ");
                }
            }
        }
    }

    private static File getTestCaseQueryBeforeCrashFile(String actualPath, TestCaseContext testCaseCtx, TestCase.CompilationUnit cUnit) {
        return new File(actualPath + File.separator + testCaseCtx.getTestCase().getFilePath().replace(File.separator, "_") + "_" + cUnit.getName() + "_qbc.adm");
    }

    protected String getPath(ServletUtil.Servlets servlet) {
        return servlet.getPath();
    }

    protected String getEndpoint(ServletUtil.Servlets servlet) {
        return "http://" + this.host + ":" + this.port + this.getPath(servlet).replaceAll("/\\*$", "");
    }

    public static String stripJavaComments(String text) {
        return JAVA_BLOCK_COMMENT_PATTERN.matcher(text).replaceAll("");
    }

    public void cleanup(String testCase, List<String> badtestcases) throws Exception {
        try {
            ArrayNode result;
            ArrayList<String> toBeDropped = new ArrayList<String>();
            InputStream resultStream = this.executeQueryService("select dv.DataverseName from Metadata.`Dataverse` as dv;", this.getEndpoint(ServletUtil.Servlets.QUERY_SERVICE));
            String out = IOUtils.toString((InputStream)resultStream);
            ObjectMapper om = new ObjectMapper();
            om.setConfig(om.getDeserializationConfig().with(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT));
            try {
                result = ((ObjectNode)om.readValue(out, ObjectNode.class)).get("results");
            }
            catch (JsonMappingException e) {
                result = om.createArrayNode();
            }
            for (int i = 0; i < result.size(); ++i) {
                String dvName;
                JsonNode json = result.get(i);
                if (json == null || (dvName = json.get("DataverseName").asText()).equals("Metadata") || dvName.equals("Default")) continue;
                toBeDropped.add(dvName);
            }
            if (!toBeDropped.isEmpty()) {
                badtestcases.add(testCase);
                LOGGER.warning("Last test left some garbage. Dropping dataverses: " + StringUtils.join(toBeDropped, (char)','));
                StringBuilder dropStatement = new StringBuilder();
                for (String dv : toBeDropped) {
                    dropStatement.append("drop dataverse ");
                    dropStatement.append(dv);
                    dropStatement.append(";\n");
                }
                resultStream = this.executeQueryService(dropStatement.toString(), this.getEndpoint(ServletUtil.Servlets.QUERY_SERVICE));
                ResultExtractor.extract(resultStream);
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw th;
        }
    }
}

