/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.aql;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.util.Instantiatable;
import java.io.IOException;
import java.io.Serializable;

public class SingleLinePrettyPrinter
implements PrettyPrinter,
Instantiatable<SingleLinePrettyPrinter>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final SerializedString DEFAULT_ROOT_VALUE_SEPARATOR = new SerializedString(" ");
    protected Indenter _arrayIndenter = FixedSpaceIndenter.instance;
    protected Indenter _objectIndenter = new FixedSpaceIndenter();
    protected final SerializableString _rootSeparator;
    protected boolean _spacesInObjectEntries = true;
    protected transient int _nesting;

    public SingleLinePrettyPrinter() {
        this((SerializableString)DEFAULT_ROOT_VALUE_SEPARATOR);
    }

    public SingleLinePrettyPrinter(String rootSeparator) {
        this((SerializableString)(rootSeparator == null ? null : new SerializedString(rootSeparator)));
    }

    public SingleLinePrettyPrinter(SerializableString rootSeparator) {
        this._rootSeparator = rootSeparator;
    }

    public SingleLinePrettyPrinter(SingleLinePrettyPrinter base) {
        this(base, base._rootSeparator);
    }

    public SingleLinePrettyPrinter(SingleLinePrettyPrinter base, SerializableString rootSeparator) {
        this._arrayIndenter = base._arrayIndenter;
        this._objectIndenter = base._objectIndenter;
        this._spacesInObjectEntries = base._spacesInObjectEntries;
        this._nesting = base._nesting;
        this._rootSeparator = rootSeparator;
    }

    public SingleLinePrettyPrinter withRootSeparator(SerializableString rootSeparator) {
        if (this._rootSeparator == rootSeparator || rootSeparator != null && rootSeparator.equals(this._rootSeparator)) {
            return this;
        }
        return new SingleLinePrettyPrinter(this, rootSeparator);
    }

    public SingleLinePrettyPrinter withRootSeparator(String rootSeparator) {
        return this.withRootSeparator((SerializableString)(rootSeparator == null ? null : new SerializedString(rootSeparator)));
    }

    public void indentArraysWith(Indenter i) {
        this._arrayIndenter = i == null ? NopIndenter.instance : i;
    }

    public void indentObjectsWith(Indenter i) {
        this._objectIndenter = i == null ? NopIndenter.instance : i;
    }

    @Deprecated
    public void spacesInObjectEntries(boolean b) {
        this._spacesInObjectEntries = b;
    }

    public SingleLinePrettyPrinter withArrayIndenter(Indenter i) {
        if (i == null) {
            i = NopIndenter.instance;
        }
        if (this._arrayIndenter == i) {
            return this;
        }
        SingleLinePrettyPrinter pp = new SingleLinePrettyPrinter(this);
        pp._arrayIndenter = i;
        return pp;
    }

    public SingleLinePrettyPrinter withObjectIndenter(Indenter i) {
        if (i == null) {
            i = NopIndenter.instance;
        }
        if (this._objectIndenter == i) {
            return this;
        }
        SingleLinePrettyPrinter pp = new SingleLinePrettyPrinter(this);
        pp._objectIndenter = i;
        return pp;
    }

    public SingleLinePrettyPrinter withSpacesInObjectEntries() {
        return this._withSpaces(true);
    }

    public SingleLinePrettyPrinter withoutSpacesInObjectEntries() {
        return this._withSpaces(false);
    }

    protected SingleLinePrettyPrinter _withSpaces(boolean state) {
        if (this._spacesInObjectEntries == state) {
            return this;
        }
        SingleLinePrettyPrinter pp = new SingleLinePrettyPrinter(this);
        pp._spacesInObjectEntries = state;
        return pp;
    }

    public SingleLinePrettyPrinter createInstance() {
        return new SingleLinePrettyPrinter(this);
    }

    public void writeRootValueSeparator(JsonGenerator jg) throws IOException {
        if (this._rootSeparator != null) {
            jg.writeRaw(this._rootSeparator);
        }
    }

    public void writeStartObject(JsonGenerator jg) throws IOException {
        jg.writeRaw('{');
        ++this._nesting;
    }

    public void beforeObjectEntries(JsonGenerator jg) throws IOException {
        this._objectIndenter.writeIndentation(jg, this._nesting);
    }

    public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException {
        if (this._spacesInObjectEntries) {
            jg.writeRaw(": ");
        } else {
            jg.writeRaw(':');
        }
    }

    public void writeObjectEntrySeparator(JsonGenerator jg) throws IOException {
        jg.writeRaw(',');
        this._objectIndenter.writeIndentation(jg, this._nesting);
    }

    public void writeEndObject(JsonGenerator jg, int nrOfEntries) throws IOException {
        --this._nesting;
        if (nrOfEntries > 1) {
            this._objectIndenter.writeIndentation(jg, this._nesting);
        } else {
            jg.writeRaw(' ');
        }
        jg.writeRaw('}');
    }

    public void writeStartArray(JsonGenerator jg) throws IOException {
        ++this._nesting;
        jg.writeRaw('[');
    }

    public void beforeArrayValues(JsonGenerator jg) throws IOException {
        this._arrayIndenter.writeIndentation(jg, this._nesting);
    }

    public void writeArrayValueSeparator(JsonGenerator gen) throws IOException {
        gen.writeRaw(',');
        this._arrayIndenter.writeIndentation(gen, this._nesting);
    }

    public void writeEndArray(JsonGenerator gen, int nrOfValues) throws IOException {
        --this._nesting;
        if (this._nesting == 0) {
            gen.writeRaw('\n');
        }
        if (nrOfValues > 1) {
            this._arrayIndenter.writeIndentation(gen, this._nesting);
        } else {
            gen.writeRaw(' ');
        }
        gen.writeRaw(']');
    }

    public static class FixedSpaceIndenter
    extends NopIndenter {
        public static final FixedSpaceIndenter instance = new FixedSpaceIndenter();

        @Override
        public void writeIndentation(JsonGenerator jg, int level) throws IOException {
            jg.writeRaw(' ');
        }

        @Override
        public boolean isInline() {
            return true;
        }
    }

    public static class NopIndenter
    implements Indenter,
    Serializable {
        public static final NopIndenter instance = new NopIndenter();

        @Override
        public void writeIndentation(JsonGenerator jg, int level) throws IOException {
        }

        @Override
        public boolean isInline() {
            return true;
        }
    }

    public static interface Indenter {
        public void writeIndentation(JsonGenerator var1, int var2) throws IOException;

        public boolean isInline();
    }
}

