/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.test.aql;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Iterators;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.test.aql.SingleLinePrettyPrinter;
import org.apache.commons.io.IOUtils;

public class ResultExtractor {
    private static final Logger LOGGER = Logger.getLogger(ResultExtractor.class.getName());

    public static InputStream extract(InputStream resultStream) throws Exception {
        ObjectMapper om = new ObjectMapper();
        StringWriter sw = new StringWriter();
        String resultStr = IOUtils.toString((InputStream)resultStream, (Charset)Charset.defaultCharset());
        SingleLinePrettyPrinter singleLine = new SingleLinePrettyPrinter();
        ObjectNode result = (ObjectNode)om.readValue(resultStr, ObjectNode.class);
        LOGGER.fine("+++++++\n" + result + "\n+++++++\n");
        String type = "";
        String status = "";
        String results = "";
        String field = "";
        Iterator sIter = result.fieldNames();
        block18: while (sIter.hasNext()) {
            switch (field = (String)sIter.next()) {
                case "requestID": {
                    continue block18;
                }
                case "signature": {
                    continue block18;
                }
                case "status": {
                    status = om.writeValueAsString((Object)result.get(field));
                    continue block18;
                }
                case "type": {
                    type = om.writeValueAsString((Object)result.get(field));
                    continue block18;
                }
                case "metrics": {
                    LOGGER.fine(om.writeValueAsString((Object)result.get(field)));
                    continue block18;
                }
                case "errors": {
                    JsonNode errors = result.get(field).get(0).get("msg");
                    throw new AsterixException(errors.asText());
                }
                case "results": {
                    if (result.get(field).size() <= 1) {
                        if (result.get(field).size() == 0) {
                            results = "";
                            continue block18;
                        }
                        if (result.get(field).isArray()) {
                            if (result.get(field).get(0).isTextual()) {
                                results = result.get(field).get(0).asText();
                                continue block18;
                            }
                            ObjectMapper omm = new ObjectMapper();
                            omm.setDefaultPrettyPrinter((PrettyPrinter)singleLine);
                            omm.enable(SerializationFeature.INDENT_OUTPUT);
                            results = omm.writer((PrettyPrinter)singleLine).writeValueAsString((Object)result.get(field));
                            continue block18;
                        }
                        results = om.writeValueAsString((Object)result.get(field));
                        continue block18;
                    }
                    StringBuilder sb = new StringBuilder();
                    JsonNode[] fields = (JsonNode[])Iterators.toArray((Iterator)result.get(field).elements(), JsonNode.class);
                    if (fields.length > 1) {
                        for (JsonNode f : fields) {
                            if (f.isObject()) {
                                sb.append(om.writeValueAsString((Object)f));
                                continue;
                            }
                            sb.append(f.asText());
                        }
                    }
                    results = sb.toString();
                    continue block18;
                }
            }
            throw new AsterixException(field + "unanticipated field");
        }
        return IOUtils.toInputStream((String)results);
    }

    public static String extractHandle(InputStream resultStream) throws Exception {
        Charset utf8 = Charset.forName("UTF-8");
        ObjectMapper om = new ObjectMapper();
        String result = IOUtils.toString((InputStream)resultStream, (Charset)utf8);
        ObjectNode resultJson = (ObjectNode)om.readValue(result, ObjectNode.class);
        JsonNode handle = resultJson.get("handle");
        ObjectNode res = om.createObjectNode();
        res.set("handle", handle);
        return om.writeValueAsString((Object)res);
    }
}

