/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.active;

import java.util.Objects;
import org.apache.asterix.active.EntityId;
import org.apache.hyracks.api.job.JobId;

public class ActiveEvent {
    private final JobId jobId;
    private final EntityId entityId;
    private final Kind eventKind;
    private final Object eventObject;

    public ActiveEvent(JobId jobId, Kind eventKind, EntityId entityId, Object eventObject) {
        this.jobId = jobId;
        this.entityId = entityId;
        this.eventKind = eventKind;
        this.eventObject = eventObject;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public Kind getEventKind() {
        return this.eventKind;
    }

    public Object getEventObject() {
        return this.eventObject;
    }

    public String toString() {
        return "JobId:" + this.jobId + ",EntityId:" + this.entityId + ", Kind" + (Object)((Object)this.eventKind);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ActiveEvent)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        ActiveEvent other = (ActiveEvent)o;
        return Objects.equals(this.entityId, other.entityId) && Objects.equals((Object)this.eventKind, (Object)other.eventKind) && Objects.equals(this.eventObject, other.eventObject);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.entityId, this.eventKind, this.eventObject});
    }

    public static enum Kind {
        JOB_CREATED,
        JOB_STARTED,
        JOB_FINISHED,
        PARTITION_EVENT,
        EXTENSION_EVENT,
        STATS_UPDATED,
        STATE_CHANGED,
        FAILURE;

    }
}

