/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.active;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.active.IActiveRuntime;
import org.apache.asterix.active.message.ActiveManagerMessage;
import org.apache.asterix.common.memory.ConcurrentFramePool;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.log4j.Logger;

public class ActiveManager {
    private static final Logger LOGGER = Logger.getLogger((String)ActiveManager.class.getName());
    private final Executor executor;
    private final Map<ActiveRuntimeId, IActiveRuntime> runtimes;
    private final ConcurrentFramePool activeFramePool;
    private final String nodeId;

    public ActiveManager(Executor executor, String nodeId, long activeMemoryBudget, int frameSize) throws HyracksDataException {
        this.executor = executor;
        this.nodeId = nodeId;
        this.activeFramePool = new ConcurrentFramePool(nodeId, activeMemoryBudget, frameSize);
        this.runtimes = new ConcurrentHashMap<ActiveRuntimeId, IActiveRuntime>();
    }

    public ConcurrentFramePool getFramePool() {
        return this.activeFramePool;
    }

    public void registerRuntime(IActiveRuntime runtime) {
        ActiveRuntimeId id = runtime.getRuntimeId();
        if (!this.runtimes.containsKey(id)) {
            this.runtimes.put(id, runtime);
        }
    }

    public void deregisterRuntime(ActiveRuntimeId id) {
        this.runtimes.remove(id);
    }

    public IActiveRuntime getRuntime(ActiveRuntimeId runtimeId) {
        return this.runtimes.get(runtimeId);
    }

    public String toString() {
        return ActiveManager.class.getSimpleName() + "[" + this.nodeId + "]";
    }

    public void submit(ActiveManagerMessage message) {
        switch (message.getKind()) {
            case 0: {
                this.stopRuntime(message);
                break;
            }
            default: {
                LOGGER.warn((Object)("Unknown message type received: " + message.getKind()));
            }
        }
    }

    private void stopRuntime(ActiveManagerMessage message) {
        ActiveRuntimeId runtimeId = (ActiveRuntimeId)message.getPayload();
        IActiveRuntime runtime = this.runtimes.get(runtimeId);
        if (runtime == null) {
            LOGGER.warn((Object)("Request to stop a runtime that is not registered " + runtimeId));
        } else {
            this.executor.execute(() -> {
                try {
                    runtime.stop();
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("Failed to stop runtime: " + runtimeId), (Throwable)e);
                }
            });
        }
    }
}

