/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.active;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.ActiveEvent;
import org.apache.asterix.active.ActiveJobNotificationHandler;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.active.message.ActivePartitionMessage;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IActivityClusterGraphGeneratorFactory;
import org.apache.hyracks.api.job.IJobLifecycleListener;
import org.apache.hyracks.api.job.JobId;

public class ActiveLifecycleListener
implements IJobLifecycleListener {
    private static final Logger LOGGER = Logger.getLogger(ActiveLifecycleListener.class.getName());
    public static final ActiveLifecycleListener INSTANCE = new ActiveLifecycleListener();
    private final LinkedBlockingQueue<ActiveEvent> jobEventInbox = ActiveJobNotificationHandler.INSTANCE.getEventInbox();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    private ActiveLifecycleListener() {
        this.executorService.execute(ActiveJobNotificationHandler.INSTANCE);
    }

    public synchronized void notifyJobStart(JobId jobId) throws HyracksException {
        EntityId entityId = ActiveJobNotificationHandler.INSTANCE.getEntity(jobId);
        if (entityId != null) {
            this.jobEventInbox.add(new ActiveEvent(jobId, ActiveEvent.EventKind.JOB_START, entityId));
        }
    }

    public synchronized void notifyJobFinish(JobId jobId) throws HyracksException {
        EntityId entityId = ActiveJobNotificationHandler.INSTANCE.getEntity(jobId);
        if (entityId != null) {
            this.jobEventInbox.add(new ActiveEvent(jobId, ActiveEvent.EventKind.JOB_FINISH, entityId));
        } else if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("NO NEED TO NOTIFY JOB FINISH!");
        }
    }

    public void notifyJobCreation(JobId jobId, IActivityClusterGraphGeneratorFactory acggf) throws HyracksException {
        ActiveJobNotificationHandler.INSTANCE.notifyJobCreation(jobId, acggf.getJobSpecification());
    }

    public void receive(ActivePartitionMessage message) {
        if (ActiveJobNotificationHandler.INSTANCE.isActiveJob(message.getJobId())) {
            this.jobEventInbox.add(new ActiveEvent(message.getJobId(), ActiveEvent.EventKind.PARTITION_EVENT, message.getActiveRuntimeId().getEntityId(), message));
        }
    }

    public void stop() {
        this.executorService.shutdown();
    }
}

