/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.active;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.ActivityState;
import org.apache.asterix.active.EntityId;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;

public class ActiveJob
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ActiveJob.class.getName());
    protected final EntityId entityId;
    protected JobId jobId;
    protected final Serializable jobObject;
    protected ActivityState state;
    protected JobSpecification spec;

    public ActiveJob(EntityId entityId, JobId jobId, ActivityState state, Serializable jobInfo, JobSpecification spec) {
        this.entityId = entityId;
        this.state = state;
        this.jobId = jobId;
        this.jobObject = jobInfo;
        this.spec = spec;
    }

    public ActiveJob(EntityId entityId, ActivityState state, Serializable jobInfo, JobSpecification spec) {
        this.entityId = entityId;
        this.state = state;
        this.jobObject = jobInfo;
        this.spec = spec;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public void setJobId(JobId jobId) {
        this.jobId = jobId;
    }

    public ActivityState getState() {
        return this.state;
    }

    public void setState(ActivityState state) {
        this.state = state;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(this + " is in " + (Object)((Object)state) + " state.");
        }
    }

    public Object getJobObject() {
        return this.jobObject;
    }

    public JobSpecification getSpec() {
        return this.spec;
    }

    public void setSpec(JobSpecification spec) {
        this.spec = spec;
    }

    public String toString() {
        return this.jobId + " [" + this.jobObject + "]";
    }

    public EntityId getEntityId() {
        return this.entityId;
    }
}

