/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.jpa.xa.plugin.hibernate.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.persistence.TransactionRequiredException;
import javax.transaction.Synchronization;
import org.hibernate.ConnectionAcquisitionMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.engine.transaction.spi.TransactionObserver;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.transaction.SynchronizationRegistry;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.hibernate.resource.transaction.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;
import org.osgi.service.transaction.control.TransactionContext;
import org.osgi.service.transaction.control.TransactionControl;
import org.osgi.service.transaction.control.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateTxControlPlatform
implements TransactionCoordinatorBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateTxControlPlatform.class);
    private static final long serialVersionUID = 1L;
    private final ThreadLocal<TransactionControl> txControlToUse;

    public HibernateTxControlPlatform(ThreadLocal<TransactionControl> txControlToUse) {
        this.txControlToUse = txControlToUse;
    }

    public TransactionControl getTxControl() {
        TransactionControl transactionControl = this.txControlToUse.get();
        if (transactionControl == null) {
            throw new TransactionException("A No Transaction Context could not be created because there is no associated Transaction Control");
        }
        return transactionControl;
    }

    public TransactionCoordinator buildTransactionCoordinator(TransactionCoordinatorOwner owner, TransactionCoordinatorBuilder.TransactionCoordinatorOptions options) {
        return new HibernateTxControlCoordinator(owner, options.shouldAutoJoinTransaction());
    }

    public boolean isJta() {
        return true;
    }

    public ConnectionReleaseMode getDefaultConnectionReleaseMode() {
        return ConnectionReleaseMode.AFTER_STATEMENT;
    }

    public ConnectionAcquisitionMode getDefaultConnectionAcquisitionMode() {
        return ConnectionAcquisitionMode.AS_NEEDED;
    }

    public class HibernateTxControlCoordinator
    implements TransactionCoordinator,
    SynchronizationRegistry,
    TransactionCoordinator.TransactionDriver,
    IsolationDelegate {
        private static final long serialVersionUID = 1L;
        private final List<TransactionObserver> registeredObservers = new ArrayList<TransactionObserver>();
        private final TransactionCoordinatorOwner owner;
        private final boolean autoJoin;
        private boolean joined = false;

        public HibernateTxControlCoordinator(TransactionCoordinatorOwner owner, boolean autoJoin) {
            this.owner = owner;
            this.autoJoin = autoJoin;
        }

        public void explicitJoin() {
            if (!this.joined) {
                if (!HibernateTxControlPlatform.this.getTxControl().activeTransaction()) {
                    throw new TransactionRequiredException("There is no transaction active to join");
                }
                this.internalJoin();
            }
        }

        private void internalJoin() {
            TransactionContext currentContext = HibernateTxControlPlatform.this.getTxControl().getCurrentContext();
            currentContext.preCompletion(this::beforeCompletion);
            currentContext.postCompletion(this::afterCompletion);
            this.joined = true;
        }

        public boolean isJoined() {
            return this.joined;
        }

        public void pulse() {
            if (this.autoJoin && !this.joined && HibernateTxControlPlatform.this.getTxControl().activeTransaction()) {
                this.internalJoin();
            }
        }

        public TransactionCoordinator.TransactionDriver getTransactionDriverControl() {
            return this;
        }

        public SynchronizationRegistry getLocalSynchronizations() {
            return this;
        }

        public boolean isActive() {
            return HibernateTxControlPlatform.this.getTxControl().activeTransaction();
        }

        public IsolationDelegate createIsolationDelegate() {
            return this;
        }

        public void addObserver(TransactionObserver observer) {
            this.registeredObservers.add(observer);
        }

        public void removeObserver(TransactionObserver observer) {
            this.registeredObservers.remove(observer);
        }

        public TransactionCoordinatorBuilder getTransactionCoordinatorBuilder() {
            return HibernateTxControlPlatform.this;
        }

        public void setTimeOut(int seconds) {
        }

        public int getTimeOut() {
            return -1;
        }

        public void registerSynchronization(Synchronization synchronization) {
            LOGGER.debug("Registering a synchronization with the current transaction");
            TransactionContext currentContext = HibernateTxControlPlatform.this.getTxControl().getCurrentContext();
            currentContext.preCompletion(() -> ((Synchronization)synchronization).beforeCompletion());
            currentContext.postCompletion(status -> synchronization.afterCompletion(this.toIntStatus((TransactionStatus)status)));
        }

        private void beforeCompletion() {
            try {
                this.owner.beforeTransactionCompletion();
            }
            catch (RuntimeException re) {
                HibernateTxControlPlatform.this.getTxControl().setRollbackOnly();
                throw re;
            }
            finally {
                this.registeredObservers.forEach(TransactionObserver::beforeCompletion);
            }
        }

        private void afterCompletion(TransactionStatus status) {
            if (this.owner.isActive()) {
                this.toIntStatus(status);
                boolean committed = status == TransactionStatus.COMMITTED;
                this.owner.afterTransactionCompletion(committed, false);
                this.registeredObservers.forEach(o -> o.afterCompletion(committed, false));
            }
        }

        private int toIntStatus(TransactionStatus status) {
            switch (status) {
                case COMMITTED: {
                    return 3;
                }
                case ROLLED_BACK: {
                    return 4;
                }
            }
            return 5;
        }

        public void begin() {
            if (!HibernateTxControlPlatform.this.getTxControl().activeTransaction()) {
                throw new IllegalStateException("There is no existing active transaction scope");
            }
        }

        public void commit() {
            if (!HibernateTxControlPlatform.this.getTxControl().activeTransaction()) {
                throw new IllegalStateException("There is no existing active transaction scope");
            }
        }

        public void rollback() {
            if (!HibernateTxControlPlatform.this.getTxControl().activeTransaction()) {
                throw new IllegalStateException("There is no existing active transaction scope");
            }
            HibernateTxControlPlatform.this.getTxControl().setRollbackOnly();
        }

        public org.hibernate.resource.transaction.spi.TransactionStatus getStatus() {
            TransactionStatus status = HibernateTxControlPlatform.this.getTxControl().getCurrentContext().getTransactionStatus();
            switch (status) {
                case ACTIVE: {
                    return org.hibernate.resource.transaction.spi.TransactionStatus.ACTIVE;
                }
                case COMMITTED: {
                    return org.hibernate.resource.transaction.spi.TransactionStatus.COMMITTED;
                }
                case PREPARING: 
                case PREPARED: 
                case COMMITTING: {
                    return org.hibernate.resource.transaction.spi.TransactionStatus.COMMITTING;
                }
                case MARKED_ROLLBACK: {
                    return org.hibernate.resource.transaction.spi.TransactionStatus.MARKED_ROLLBACK;
                }
                case NO_TRANSACTION: {
                    return org.hibernate.resource.transaction.spi.TransactionStatus.NOT_ACTIVE;
                }
                case ROLLED_BACK: {
                    return org.hibernate.resource.transaction.spi.TransactionStatus.ROLLED_BACK;
                }
                case ROLLING_BACK: {
                    return org.hibernate.resource.transaction.spi.TransactionStatus.ROLLING_BACK;
                }
            }
            throw new IllegalStateException("The state " + status + " is unknown");
        }

        public void markRollbackOnly() {
            HibernateTxControlPlatform.this.getTxControl().setRollbackOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T delegateWork(WorkExecutorVisitable<T> work, boolean transacted) throws HibernateException {
            Callable<Object> c = () -> {
                JdbcSessionOwner sessionOwner = this.owner.getJdbcSessionOwner();
                Connection conn = sessionOwner.getJdbcConnectionAccess().obtainConnection();
                try {
                    Object object = work.accept(new WorkExecutor(), conn);
                    return object;
                }
                finally {
                    sessionOwner.getJdbcConnectionAccess().releaseConnection(conn);
                }
            };
            try {
                if (transacted) {
                    LOGGER.debug("Performing a query in a nested transaction");
                    Object object = HibernateTxControlPlatform.this.getTxControl().requiresNew(c);
                    return (T)object;
                }
                LOGGER.debug("Suspending the current transaction to run a query");
                Object object = HibernateTxControlPlatform.this.getTxControl().notSupported(c);
                return (T)object;
            }
            finally {
                LOGGER.debug("The previous transaction has been resumed");
            }
        }
    }
}

