/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.jdbc.xa.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.aries.tx.control.jdbc.common.impl.AbstractJDBCConnectionProvider;
import org.apache.aries.tx.control.jdbc.xa.impl.JDBCConnectionProviderFactoryImpl;
import org.apache.aries.tx.control.resource.common.impl.ConfigurationDefinedResourceFactory;
import org.apache.aries.tx.control.resource.common.impl.LifecycleAware;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.service.transaction.control.jdbc.JDBCConnectionProvider;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedServiceFactoryImpl
extends ConfigurationDefinedResourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedServiceFactoryImpl.class);
    private static final String DSF_TARGET_FILTER = "aries.dsf.target.filter";
    private static final String JDBC_PROP_NAMES = "aries.jdbc.property.names";
    private static final List<String> JDBC_PROPERTIES = Arrays.asList("databaseName", "dataSourceName", "description", "networkProtocol", "password", "portNumber", "roleName", "serverName", "url", "user");

    public ManagedServiceFactoryImpl(BundleContext context) {
        super(context);
    }

    @Override
    public String getName() {
        return "Aries JDBCConnectionProvider (XA enabled) service";
    }

    @Override
    protected LifecycleAware getConfigurationDrivenResource(BundleContext context, String pid, Map<String, Object> properties) throws Exception {
        Properties jdbcProps = this.getJdbcProps(pid, properties);
        try {
            return new ManagedJDBCResourceProvider(context, pid, jdbcProps, properties);
        }
        catch (InvalidSyntaxException e) {
            LOG.error("The configuration {} contained an invalid target filter {}", (Object)pid, (Object)e.getFilter());
            throw new ConfigurationException(DSF_TARGET_FILTER, "The target filter was invalid", e);
        }
    }

    private Properties getJdbcProps(String pid, Map<String, Object> properties) throws ConfigurationException {
        Collection<String> propnames;
        List<String> object = properties.getOrDefault(JDBC_PROP_NAMES, JDBC_PROPERTIES);
        if (object instanceof String) {
            propnames = Arrays.asList(((String)((Object)object)).split(","));
        } else if (object instanceof String[]) {
            propnames = Arrays.asList((String[])object);
        } else if (object instanceof Collection) {
            propnames = object;
        } else {
            LOG.error("The configuration {} contained an invalid list of JDBC property names", (Object)pid, object);
            throw new ConfigurationException(JDBC_PROP_NAMES, "The jdbc property names must be a String+ or comma-separated String");
        }
        Properties p = new Properties();
        propnames.stream().filter(properties::containsKey).forEach(s -> p.setProperty((String)s, String.valueOf(properties.get(s))));
        return p;
    }

    private static class ManagedJDBCResourceProvider
    implements ServiceTrackerCustomizer<DataSourceFactory, DataSourceFactory>,
    LifecycleAware {
        private final BundleContext context;
        private final String pid;
        private final Properties jdbcProperties;
        private final Map<String, Object> providerProperties;
        private final ServiceTracker<DataSourceFactory, DataSourceFactory> dsfTracker;
        private DataSourceFactory activeDsf;
        private ServiceRegistration<JDBCConnectionProvider> serviceReg;
        private AbstractJDBCConnectionProvider provider;

        public ManagedJDBCResourceProvider(BundleContext context, String pid, Properties jdbcProperties, Map<String, Object> providerProperties) throws InvalidSyntaxException, ConfigurationException {
            this.context = context;
            this.pid = pid;
            this.jdbcProperties = jdbcProperties;
            this.providerProperties = providerProperties;
            String targetFilter = (String)providerProperties.get(ManagedServiceFactoryImpl.DSF_TARGET_FILTER);
            if (targetFilter == null) {
                String driver = (String)providerProperties.get("osgi.jdbc.driver.class");
                if (driver == null) {
                    LOG.error("The configuration {} must specify a target filter or a JDBC driver class", (Object)pid);
                    throw new ConfigurationException("osgi.jdbc.driver.class", "The configuration must specify either a target filter or a JDBC driver class");
                }
                targetFilter = "(&(objectClass=" + DataSourceFactory.class.getName() + ")(" + "osgi.jdbc.driver.class" + "=" + driver + "))";
            }
            targetFilter = "(&(objectClass=" + DataSourceFactory.class.getName() + ")" + targetFilter + ")";
            this.dsfTracker = new ServiceTracker(context, context.createFilter(targetFilter), (ServiceTrackerCustomizer)this);
        }

        @Override
        public void start() {
            this.dsfTracker.open();
        }

        @Override
        public void stop() {
            this.dsfTracker.close();
        }

        public DataSourceFactory addingService(ServiceReference<DataSourceFactory> reference) {
            DataSourceFactory service = (DataSourceFactory)this.context.getService(reference);
            return this.updateService(service);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DataSourceFactory updateService(DataSourceFactory service) {
            boolean setDsf;
            ManagedJDBCResourceProvider managedJDBCResourceProvider = this;
            synchronized (managedJDBCResourceProvider) {
                boolean bl = setDsf = this.activeDsf == null;
                if (setDsf) {
                    this.activeDsf = service;
                }
            }
            ServiceRegistration<JDBCConnectionProvider> reg = null;
            AbstractJDBCConnectionProvider provider = null;
            if (setDsf) {
                try {
                    AbstractJDBCConnectionProvider oldProvider;
                    ServiceRegistration<JDBCConnectionProvider> oldReg;
                    provider = new JDBCConnectionProviderFactoryImpl(this.context).getProviderFor(service, this.jdbcProperties, (Map)this.providerProperties);
                    reg = this.context.registerService(JDBCConnectionProvider.class, (Object)provider, this.getServiceProperties());
                    ManagedJDBCResourceProvider managedJDBCResourceProvider2 = this;
                    synchronized (managedJDBCResourceProvider2) {
                        if (this.activeDsf == service) {
                            oldReg = this.serviceReg;
                            this.serviceReg = reg;
                            oldProvider = this.provider;
                            this.provider = provider;
                        } else {
                            oldReg = reg;
                            oldProvider = provider;
                        }
                    }
                    this.safeUnregister(oldReg);
                    this.safeClose(oldProvider);
                }
                catch (Exception e) {
                    LOG.error("An error occurred when creating the connection provider for {}.", (Object)this.pid, (Object)e);
                    ManagedJDBCResourceProvider managedJDBCResourceProvider3 = this;
                    synchronized (managedJDBCResourceProvider3) {
                        if (this.activeDsf == service) {
                            this.activeDsf = null;
                        }
                    }
                    this.safeUnregister(reg);
                    this.safeClose(provider);
                }
            }
            return service;
        }

        private void safeUnregister(ServiceRegistration<?> reg) {
            if (reg != null) {
                try {
                    reg.unregister();
                }
                catch (IllegalStateException ise) {
                    LOG.debug("An exception occurred when unregistering a service for {}", (Object)this.pid);
                }
            }
        }

        private void safeClose(AbstractJDBCConnectionProvider oldProvider) {
            if (oldProvider != null) {
                try {
                    oldProvider.close();
                }
                catch (Exception e) {
                    LOG.debug("An exception occurred when closing a provider for {}", (Object)this.pid, (Object)e);
                }
            }
        }

        private Dictionary<String, ?> getServiceProperties() {
            Hashtable props = new Hashtable();
            this.providerProperties.keySet().stream().filter(s -> !s.startsWith(".")).filter(s -> !"password".equals(s)).forEach(s -> props.put(s, this.providerProperties.get(s)));
            return props;
        }

        public void modifiedService(ServiceReference<DataSourceFactory> reference, DataSourceFactory service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<DataSourceFactory> reference, DataSourceFactory service) {
            DataSourceFactory newDSF;
            boolean dsfLeft;
            ServiceRegistration<JDBCConnectionProvider> oldReg = null;
            AbstractJDBCConnectionProvider oldProvider = null;
            ManagedJDBCResourceProvider managedJDBCResourceProvider = this;
            synchronized (managedJDBCResourceProvider) {
                boolean bl = dsfLeft = this.activeDsf == service;
                if (dsfLeft) {
                    this.activeDsf = null;
                    oldReg = this.serviceReg;
                    oldProvider = this.provider;
                    this.serviceReg = null;
                    this.provider = null;
                }
            }
            this.safeUnregister(oldReg);
            this.safeClose(oldProvider);
            if (dsfLeft && (newDSF = (DataSourceFactory)this.dsfTracker.getService()) != null) {
                this.updateService((DataSourceFactory)this.dsfTracker.getService());
            }
        }
    }
}

