/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.jdbc.xa.impl;

import java.sql.Connection;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.aries.tx.control.jdbc.common.impl.AbstractInternalJDBCConnectionProviderFactory;
import org.apache.aries.tx.control.jdbc.common.impl.AbstractJDBCConnectionProvider;
import org.apache.aries.tx.control.jdbc.xa.impl.RecoverableXAResourceImpl;
import org.apache.aries.tx.control.jdbc.xa.impl.XAEnabledTxContextBindingConnection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.transaction.control.TransactionControl;
import org.osgi.service.transaction.control.TransactionException;
import org.osgi.service.transaction.control.recovery.RecoverableXAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCConnectionProviderImpl
extends AbstractJDBCConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCConnectionProviderImpl.class);
    private final UUID uuid = UUID.randomUUID();
    private final boolean xaEnabled;
    private final boolean localEnabled;
    private final String recoveryIdentifier;
    private final ServiceRegistration<RecoverableXAResource> reg;

    public JDBCConnectionProviderImpl(DataSource dataSource, boolean xaEnabled, boolean localEnabled, String recoveryIdentifier, BundleContext ctx, Map<String, Object> providerProperties) {
        super(dataSource);
        this.xaEnabled = xaEnabled;
        this.localEnabled = localEnabled;
        this.recoveryIdentifier = recoveryIdentifier;
        if (recoveryIdentifier != null) {
            if (!AbstractInternalJDBCConnectionProviderFactory.toBoolean(providerProperties, "osgi.xa.enabled", true)) {
                LOG.warn("A JDBCResourceProvider has been configured with a recovery identifier {} but it has also been configured not to use XA transactions. No recovery will be available.", (Object)recoveryIdentifier);
                this.reg = null;
            } else {
                this.reg = ctx.registerService(RecoverableXAResource.class, (Object)new RecoverableXAResourceImpl(recoveryIdentifier, this, (String)providerProperties.get("recovery.user"), (String)providerProperties.get(".recovery.password)")), null);
            }
        } else {
            this.reg = null;
        }
    }

    @Override
    public Connection getResource(TransactionControl txControl) throws TransactionException {
        return new XAEnabledTxContextBindingConnection(txControl, this, this.uuid, this.xaEnabled, this.localEnabled, this.recoveryIdentifier);
    }

    @Override
    public void close() {
        if (this.reg != null) {
            try {
                this.reg.unregister();
            }
            catch (IllegalStateException ise) {
                LOG.debug("An exception occurred when unregistering the recovery service for {}", (Object)this.recoveryIdentifier);
            }
        }
        super.close();
    }
}

