/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.jdbc.xa.impl;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.aries.tx.control.jdbc.common.impl.AbstractInternalJDBCConnectionProviderFactory;
import org.apache.aries.tx.control.jdbc.common.impl.AbstractJDBCConnectionProvider;
import org.apache.aries.tx.control.jdbc.common.impl.DriverDataSource;
import org.apache.aries.tx.control.jdbc.xa.connection.impl.XADataSourceMapper;
import org.apache.aries.tx.control.jdbc.xa.impl.JDBCConnectionProviderImpl;
import org.apache.aries.tx.control.jdbc.xa.impl.ManagedServiceFactoryImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.service.transaction.control.TransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCConnectionProviderFactoryImpl
extends AbstractInternalJDBCConnectionProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedServiceFactoryImpl.class);
    private final BundleContext context;

    public JDBCConnectionProviderFactoryImpl(BundleContext context) {
        this.context = context;
    }

    @Override
    public JDBCConnectionProviderImpl getProviderFor(DataSourceFactory dsf, Properties jdbcProperties, Map<String, Object> resourceProviderProperties) {
        DataSource unpooled;
        boolean xaEnabled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.xa.enabled", true);
        boolean localEnabled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.local.enabled", true);
        boolean useDriver = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.use.driver", false);
        this.checkEnlistment(xaEnabled, localEnabled, !useDriver);
        try {
            unpooled = useDriver ? new DriverDataSource(dsf.createDriver(null), jdbcProperties.getProperty("url"), jdbcProperties) : (xaEnabled ? new XADataSourceMapper(dsf.createXADataSource(jdbcProperties)) : dsf.createDataSource(jdbcProperties));
        }
        catch (SQLException sqle) {
            throw new TransactionException("Unable to create the JDBC resource provider", (Throwable)sqle);
        }
        DataSource toUse = this.poolIfNecessary(resourceProviderProperties, unpooled);
        return new JDBCConnectionProviderImpl(toUse, xaEnabled, localEnabled, this.getRecoveryId(resourceProviderProperties, xaEnabled), this.context, resourceProviderProperties);
    }

    private String getRecoveryId(Map<String, Object> resourceProviderProps, boolean xaEnabled) {
        String recoveryIdentifier = Optional.ofNullable(resourceProviderProps).map(m -> m.get("osgi.recovery.identifier")).map(String::valueOf).orElse(null);
        if (recoveryIdentifier != null && !xaEnabled) {
            LOG.warn("A recovery identifier {} has been declared, but the JDBCConnectionProvider is configured to disable XA", (Object)recoveryIdentifier);
        }
        return recoveryIdentifier;
    }

    @Override
    public AbstractJDBCConnectionProvider getProviderFor(DataSource ds, Map<String, Object> resourceProviderProperties) {
        XADataSource xaDS;
        boolean xaEnabled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.xa.enabled", true);
        boolean localEnabled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.local.enabled", true);
        if (ds instanceof XADataSource) {
            xaDS = (XADataSource)((Object)ds);
        } else {
            try {
                xaDS = ds.isWrapperFor(XADataSource.class) ? ds.unwrap(XADataSource.class) : null;
            }
            catch (SQLException sqle) {
                xaDS = null;
            }
        }
        this.checkEnlistment(xaEnabled, localEnabled, xaDS != null);
        DataSource toUse = this.poolIfNecessary(resourceProviderProperties, xaEnabled ? new XADataSourceMapper(xaDS) : ds);
        return new JDBCConnectionProviderImpl(toUse, xaEnabled, localEnabled, this.getRecoveryId(resourceProviderProperties, xaEnabled), this.context, resourceProviderProperties);
    }

    @Override
    public AbstractJDBCConnectionProvider getProviderFor(Driver driver, Properties jdbcProperties, Map<String, Object> resourceProviderProperties) {
        boolean xaEnabled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.xa.enabled", false);
        boolean localEnabled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.local.enabled", true);
        this.checkEnlistment(xaEnabled, localEnabled, false);
        DataSource toUse = this.poolIfNecessary(resourceProviderProperties, new DriverDataSource(driver, jdbcProperties.getProperty("url"), jdbcProperties));
        return new JDBCConnectionProviderImpl(toUse, xaEnabled, localEnabled, this.getRecoveryId(resourceProviderProperties, xaEnabled), this.context, resourceProviderProperties);
    }

    @Override
    public AbstractJDBCConnectionProvider getProviderFor(XADataSource ds, Map<String, Object> resourceProviderProperties) {
        boolean xaEnabled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.xa.enabled", true);
        boolean localEnabled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.local.enabled", true);
        this.checkEnlistment(xaEnabled, localEnabled, true);
        XADataSourceMapper unpooled = new XADataSourceMapper(ds);
        return new JDBCConnectionProviderImpl(this.poolIfNecessary(resourceProviderProperties, unpooled), xaEnabled, localEnabled, this.getRecoveryId(resourceProviderProperties, xaEnabled), this.context, resourceProviderProperties);
    }

    private void checkEnlistment(boolean xaEnabled, boolean localEnabled, boolean isXA) {
        if (!xaEnabled && !localEnabled) {
            throw new TransactionException("The configuration supports neither local nor XA transactions");
        }
        if (xaEnabled && !isXA) {
            throw new TransactionException("The configuration is XA enabled but the resource is not suitable for XA enlistment");
        }
    }
}

