/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.jdbc.xa.impl;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(factoryPid={"org.apache.aries.tx.control.jdbc.xa"}, description="Aries Transaction Control Factory for XA enabled JDBCResourceProvider Services")
public @interface Config {
    @AttributeDefinition(required=false, description="The name of the driver class for the DataSourceFactory service. This property need not be defined if aries.dsf.target.filter is defined.")
    public String osgi_jdbc_driver_class();

    @AttributeDefinition(required=false, description="The JDBC URL to pass to the DataSourceFactory")
    public String url();

    @AttributeDefinition(required=false, description="The userid to pass to the DataSourceFactory")
    public String user();

    @AttributeDefinition(type=AttributeType.PASSWORD, required=false, description="The password to pass to the DataSourceFactory (not visible as a service property)")
    public String password();

    @AttributeDefinition(required=false, description="The recovery identifier for this resource. If not set then this resource will not be recoverable. This identifier must uniquely identify a single resource, and must not change if the framework is restarted.")
    public String osgi_recovery_identifier();

    @AttributeDefinition(required=false, description="Is connection pooling enabled for this JDBCResourceProvider")
    public boolean osgi_connection_pooling_enabled() default true;

    @AttributeDefinition(required=false, description="The maximum number of connections in the pool")
    public int osgi_connection_max() default 10;

    @AttributeDefinition(required=false, description="The minimum number of connections in the pool")
    public int osgi_connection_min() default 10;

    @AttributeDefinition(required=false, description="The maximum time (in ms) that the pool will wait for a connection before failing")
    public long osgi_connection_timeout() default 30000L;

    @AttributeDefinition(required=false, description="The minimum time (in ms) a connection will be idle before being reclaimed by the pool")
    public long osgi_idle_timeout() default 180000L;

    @AttributeDefinition(required=false, description="The maximum time (in ms) that a connection will stay in the pool before being discarded")
    public long osgi_connection_lifetime() default 10800000L;

    @AttributeDefinition(required=false, description="The query that will be executed just before a connection is given to you from the pool to validate that the connection to the database is still alive. If your driver supports JDBC4 we strongly recommend not setting this property. This is for 'legacy' databases that do not support the JDBC Connection.isValid() API")
    public String aries_connection_test_query();

    @AttributeDefinition(required=false, description="The user that should be used for recovery. If not specified then recovery will use the same user credentials as normal operation")
    public String recovery_user();

    @AttributeDefinition(type=AttributeType.PASSWORD, required=false, description="The password that should be used for recovery. Only used if recovery.user is specified")
    public String _recovery_password();

    @AttributeDefinition(required=false, description="Should this Resource participate in transactions using XA")
    public boolean osgi_xa_enabled() default true;

    @AttributeDefinition(required=false, description="Should this Resource participate as a Local Resource if XA is not available")
    public boolean osgi_local_enabled() default true;

    @AttributeDefinition(required=false, description="The filter to use when finding the DataSourceFactory service. This property need not be defined if osgi.jdbc.driver.class is defined.")
    public String aries_dsf_target_filter();

    @AttributeDefinition(required=false, description="The names of the properties from this configuration that should be passed to the DataSourceFactory")
    public String[] aries_jdbc_property_names() default {"databaseName", "dataSourceName", "description", "networkProtocol", "password", "portNumber", "roleName", "serverName", "url", "user"};

    @AttributeDefinition(required=false, description="JDBC configuration property")
    public String databaseName();

    @AttributeDefinition(required=false, description="JDBC configuration property")
    public String dataSourceName();

    @AttributeDefinition(required=false, description="JDBC configuration property")
    public String description();

    @AttributeDefinition(required=false, description="JDBC configuration property")
    public String networkProtocol();

    @AttributeDefinition(required=false, description="JDBC configuration property")
    public int portNumber();

    @AttributeDefinition(required=false, description="JDBC configuration property")
    public String roleName();

    @AttributeDefinition(required=false, description="JDBC configuration property")
    public String serverName();
}

