/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.jdbc.xa.connection.impl;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.aries.tx.control.jdbc.xa.connection.impl.XAConnectionWrapper;

public class XADataSourceMapper
implements DataSource {
    private final XADataSource xaDataSource;

    public XADataSourceMapper(XADataSource xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.xaDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.xaDataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.xaDataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.xaDataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.xaDataSource.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this.xaDataSource;
        }
        throw new SQLException("This datasource is not a wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface == XADataSource.class || iface.isInstance(this.xaDataSource);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new XAConnectionWrapper(this.xaDataSource.getXAConnection());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return new XAConnectionWrapper(this.xaDataSource.getXAConnection(username, password));
    }
}

