/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.jdbc.xa.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;
import javax.transaction.xa.XAResource;
import org.apache.aries.tx.control.jdbc.common.impl.AbstractJDBCConnectionProvider;
import org.apache.aries.tx.control.jdbc.common.impl.ConnectionWrapper;
import org.apache.aries.tx.control.jdbc.common.impl.ScopedConnectionWrapper;
import org.apache.aries.tx.control.jdbc.common.impl.TxConnectionWrapper;
import org.apache.aries.tx.control.jdbc.xa.connection.impl.XAConnectionWrapper;
import org.osgi.service.transaction.control.LocalResource;
import org.osgi.service.transaction.control.TransactionContext;
import org.osgi.service.transaction.control.TransactionControl;
import org.osgi.service.transaction.control.TransactionException;
import org.osgi.service.transaction.control.TransactionStatus;

public class XAEnabledTxContextBindingConnection
extends ConnectionWrapper {
    private final TransactionControl txControl;
    private final UUID resourceId;
    private final AbstractJDBCConnectionProvider provider;
    private final boolean xaEnabled;
    private final boolean localEnabled;
    private final String recoveryIdentifier;

    public XAEnabledTxContextBindingConnection(TransactionControl txControl, AbstractJDBCConnectionProvider provider, UUID resourceId, boolean xaEnabled, boolean localEnabled, String recoveryIdentifier) {
        this.txControl = txControl;
        this.provider = provider;
        this.resourceId = resourceId;
        this.xaEnabled = xaEnabled;
        this.localEnabled = localEnabled;
        this.recoveryIdentifier = recoveryIdentifier;
    }

    @Override
    protected final Connection getDelegate() {
        ConnectionWrapper toReturn;
        Connection toClose;
        TransactionContext txContext;
        block7: {
            txContext = this.txControl.getCurrentContext();
            if (txContext == null) {
                throw new TransactionException("The resource " + this.provider + " cannot be accessed outside of an active Transaction Context");
            }
            Connection existing = (Connection)txContext.getScopedValue((Object)this.resourceId);
            if (existing != null) {
                return existing;
            }
            try {
                if (txContext.getTransactionStatus() == TransactionStatus.NO_TRANSACTION) {
                    toClose = this.provider.getConnection();
                    toReturn = new ScopedConnectionWrapper(toClose);
                    break block7;
                }
                if (txContext.supportsXA() && this.xaEnabled) {
                    toClose = this.provider.getConnection();
                    toReturn = new TxConnectionWrapper(toClose);
                    txContext.registerXAResource(XAEnabledTxContextBindingConnection.getXAResource(toClose), this.recoveryIdentifier);
                    break block7;
                }
                if (txContext.supportsLocal() && this.localEnabled) {
                    toClose = this.provider.getConnection();
                    toReturn = new TxConnectionWrapper(toClose);
                    txContext.registerLocalResource(this.getLocalResource(toClose));
                    break block7;
                }
                throw new TransactionException("There is a transaction active, but it does not support local participants");
            }
            catch (Exception sqle) {
                throw new TransactionException("There was a problem getting hold of a database connection", (Throwable)sqle);
            }
        }
        txContext.postCompletion(x -> {
            try {
                toClose.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        });
        txContext.putScopedValue((Object)this.resourceId, (Object)toReturn);
        return toReturn;
    }

    static XAResource getXAResource(Connection conn) throws SQLException {
        if (conn instanceof XAConnectionWrapper) {
            return ((XAConnectionWrapper)conn).getXaResource();
        }
        if (conn.isWrapperFor(XAConnectionWrapper.class)) {
            return conn.unwrap(XAConnectionWrapper.class).getXaResource();
        }
        throw new IllegalArgumentException("The XAResource for the connection cannot be found");
    }

    private LocalResource getLocalResource(final Connection conn) {
        return new LocalResource(){

            public void commit() throws TransactionException {
                try {
                    conn.commit();
                }
                catch (SQLException e) {
                    throw new TransactionException("An error occurred when committing the connection", (Throwable)e);
                }
            }

            public void rollback() throws TransactionException {
                try {
                    conn.rollback();
                }
                catch (SQLException e) {
                    throw new TransactionException("An error occurred when rolling back the connection", (Throwable)e);
                }
            }
        };
    }
}

