/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.jdbc.xa.impl;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.aries.tx.control.jdbc.xa.impl.JDBCConnectionProviderImpl;
import org.apache.aries.tx.control.jdbc.xa.impl.XAEnabledTxContextBindingConnection;
import org.osgi.service.transaction.control.recovery.RecoverableXAResource;

public class RecoverableXAResourceImpl
implements RecoverableXAResource {
    private final String id;
    private final JDBCConnectionProviderImpl providerImpl;
    private final String recoveryUser;
    private final String recoveryPw;

    public RecoverableXAResourceImpl(String id, JDBCConnectionProviderImpl providerImpl, String recoveryUser, String recoveryPw) {
        this.id = id;
        this.providerImpl = providerImpl;
        this.recoveryUser = recoveryUser;
        this.recoveryPw = recoveryPw;
    }

    public String getId() {
        return this.id;
    }

    public XAResource getXAResource() throws Exception {
        Connection recoveryConn = this.recoveryUser != null ? this.providerImpl.getConnection(this.recoveryUser, this.recoveryPw) : this.providerImpl.getConnection();
        return new CloseableXAResource(recoveryConn);
    }

    public void releaseXAResource(XAResource xaRes) {
        if (xaRes instanceof CloseableXAResource) {
            try {
                ((CloseableXAResource)xaRes).close();
            }
            catch (Exception exception) {}
        } else {
            throw new IllegalArgumentException("The XAResource being returned was not created by this provider implementation");
        }
    }

    private static class CloseableXAResource
    implements XAResource,
    AutoCloseable {
        private final Connection conn;
        private final XAResource resource;

        public CloseableXAResource(Connection conn) throws SQLException {
            conn.isValid(5);
            this.conn = conn;
            this.resource = XAEnabledTxContextBindingConnection.getXAResource(conn);
        }

        @Override
        public void close() throws Exception {
            this.conn.close();
        }

        @Override
        public void commit(Xid arg0, boolean arg1) throws XAException {
            this.resource.commit(arg0, arg1);
        }

        @Override
        public void end(Xid arg0, int arg1) throws XAException {
            this.resource.end(arg0, arg1);
        }

        @Override
        public void forget(Xid arg0) throws XAException {
            this.resource.forget(arg0);
        }

        @Override
        public int getTransactionTimeout() throws XAException {
            return this.resource.getTransactionTimeout();
        }

        @Override
        public boolean isSameRM(XAResource arg0) throws XAException {
            return this.resource.isSameRM(arg0);
        }

        @Override
        public int prepare(Xid arg0) throws XAException {
            return this.resource.prepare(arg0);
        }

        @Override
        public Xid[] recover(int arg0) throws XAException {
            return this.resource.recover(arg0);
        }

        @Override
        public void rollback(Xid arg0) throws XAException {
            this.resource.rollback(arg0);
        }

        @Override
        public boolean setTransactionTimeout(int arg0) throws XAException {
            return this.resource.setTransactionTimeout(arg0);
        }

        @Override
        public void start(Xid arg0, int arg1) throws XAException {
            this.resource.start(arg0, arg1);
        }
    }
}

